/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.mdb;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.MDBInternalHome;
import com.ibm.ejs.container.util.MethodAttribUtils;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.EJBTransactionAttribute;
import com.ibm.ws.ejbcontainer.mdb.MessageEndpointBase;
import com.ibm.ws.ejbcontainer.mdb.MessageEndpointHandlerPool;
import com.ibm.ws.ejbcontainer.runtime.EJBApplicationEventListener;
import com.ibm.ws.ejbcontainer.util.Pool;
import com.ibm.ws.ejbcontainer.util.PoolDiscardStrategy;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tx.embeddable.RecoverableXAResourceAccessor;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.resource.ResourceException;
import javax.resource.spi.ApplicationServerInternalException;
import javax.resource.spi.RetryableUnavailableException;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

public abstract class BaseMessageEndpointFactory
extends EJSHome
implements MessageEndpointFactory,
MDBInternalHome,
EJBApplicationEventListener {
    private static final String CLASS_NAME = BaseMessageEndpointFactory.class.getName();
    private static TraceComponent tc = Tr.register(BaseMessageEndpointFactory.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    protected static final byte INACTIVE_STATE = 0;
    protected static final byte ACTIVATING_STATE = 1;
    protected static final byte ACTIVE_STATE = 2;
    protected static final byte DEACTIVATING_STATE = 3;
    protected static final byte DEACTIVATE_PENDING_STATE = 4;
    protected static final int RA_DOES_NOT_SUPPORT_XATRANSACTIONS = 0;
    protected static final int ERROR_DURING_TRAN_RECOVERY_SETUP = 1;
    protected byte ivState = 0;
    protected Thread ivActivatingThread = null;
    protected int ivRecoveryId;
    protected boolean ivRecoveryIdKnown = false;
    private boolean ivEnlistNotNeeded = false;
    private int ivEnlistNotNeededReason;
    private boolean ivEnlistNotNeededMessageLogged = false;
    protected final Object ivStateLock = new Object(){};
    private Pool ivInvocationHandlerPool = null;
    private int ivNumberOfMessageEndpointsCreated;
    protected volatile int ivMaxCreation;
    private EJBMethodInfoImpl[] ivMdbMethods;
    private String ivRAKey = null;
    protected int majorJCAVersion = 1;
    protected int minorJCAVersion = 5;
    protected boolean ivRRSTransactional = false;

    public abstract void activateEndpoint() throws ResourceException;

    public abstract void deactivateEndpoint() throws ResourceException;

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        return this.createEndpoint(xaResource, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageEndpoint createEndpoint(XAResource xaResource, long timeout) throws UnavailableException {
        UnavailableException ex;
        boolean newInstanceRequired;
        MessageEndpointBase endpoint;
        Object proxy;
        block46: {
            boolean recoverableXAResource;
            block44: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("MEF.createEndpoint for enterprise class " + this.beanMetaData.enterpriseBeanName), (Object[])new Object[0]);
                }
                recoverableXAResource = false;
                proxy = null;
                endpoint = null;
                newInstanceRequired = false;
                Object object = this.ivStateLock;
                synchronized (object) {
                    block47: {
                        if (!(xaResource == null && !this.ivRRSTransactional || this.ivRecoveryIdKnown && this.ivRecoveryId != 0 || this.ivEnlistNotNeeded)) {
                            if (!RecoverableXAResourceAccessor.isRecoverableXAResource((XAResource)xaResource)) {
                                Tr.error((TraceComponent)tc, (String)"ENDPOINT_RECOVERY_ID_UNKNOWN_CNTR0082E", (Object[])new Object[]{this.ivRAKey, this.beanMetaData.j2eeName});
                                throw new UnavailableException("setRecoveryId must be called prior to createEndpoint");
                            }
                            recoverableXAResource = true;
                        }
                        if (this.ivState != 2) break block47;
                        if (!this.isEndpointActive()) {
                            throw new UnavailableException("endpoint needs to be activated.");
                        }
                        if (this.ivInvocationHandlerPool == null || (endpoint = (MessageEndpointBase)((Object)this.ivInvocationHandlerPool.get())) != null) break block44;
                        if (this.ivNumberOfMessageEndpointsCreated < this.ivMaxCreation) {
                            ++this.ivNumberOfMessageEndpointsCreated;
                            newInstanceRequired = true;
                            break block44;
                        } else {
                            if (timeout <= 0L) {
                                if (this.majorJCAVersion == 1 && this.minorJCAVersion == 5) {
                                    throw new UnavailableException("limit for number of MessageEndpoint proxies reached. Limit = " + this.ivMaxCreation);
                                }
                                throw new RetryableUnavailableException("limit for number of MessageEndpoint proxies reached.  Limit = " + this.ivMaxCreation);
                            }
                            try {
                                this.ivStateLock.wait(timeout);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            endpoint = (MessageEndpointBase)((Object)this.ivInvocationHandlerPool.get());
                            if (endpoint == null) {
                                throw new RetryableUnavailableException("timed out waiting for a MessageEndpoint proxy to become available.");
                            }
                            if (this.ivState == 2) {
                                newInstanceRequired = false;
                                break block44;
                            } else {
                                if (this.ivState != 3 && this.ivState != 4) {
                                    throw new UnavailableException("endpoint needs to be activated.");
                                }
                                throw new UnavailableException("deactivate of endpoint is in progress.");
                            }
                        }
                    }
                    if (this.ivState == 1) {
                        if (this.ivActivatingThread == Thread.currentThread()) {
                            throw new UnavailableException("activating thread not allowed to create endpoint during activation.");
                        }
                        try {
                            if (timeout > 0L) {
                                this.ivStateLock.wait(timeout);
                            } else {
                                this.ivStateLock.wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.ivState != 2) {
                            if (this.ivState == 1) {
                                throw new RetryableUnavailableException("timed out while waiting for activation to complete.");
                            }
                            throw new UnavailableException("endpoint needs to be activated.");
                        }
                    } else {
                        if (this.ivState != 3 && this.ivState != 4) {
                            throw new UnavailableException("endpoint needs to be activated.");
                        }
                        throw new UnavailableException("deactivate of endpoint is in progress.");
                    }
                }
            }
            ex = null;
            try {
                if (endpoint != null) {
                    proxy = endpoint.ivProxy;
                } else {
                    proxy = this.beanMetaData.localImplClass.newInstance();
                    if (this.beanMetaData.ivIsNoMethodInterfaceMDB) {
                        endpoint = new MessageEndpointBase();
                        this.beanMetaData.ivMessageEndpointBaseField.set(proxy, (Object)endpoint);
                    } else {
                        endpoint = (MessageEndpointBase)((Object)proxy);
                    }
                    MessageEndpointBase.construct(this, endpoint, this.ivRecoveryId, this.container, this.beanMetaData, this.pmiBean, this.wrapperManager, this.ivRRSTransactional);
                    endpoint.ivProxy = proxy;
                }
                if (this.ivEnlistNotNeeded) {
                    if (xaResource == null) {
                        MessageEndpointBase.initialize(endpoint, null, false, this.majorJCAVersion, this.minorJCAVersion);
                        break block46;
                    } else {
                        ex = this.mapAndLogTranEnlistmentNotNeeded();
                    }
                    break block46;
                }
                MessageEndpointBase.initialize(endpoint, xaResource, recoverableXAResource, this.majorJCAVersion, this.minorJCAVersion);
            }
            catch (Throwable t) {
                Tr.error((TraceComponent)tc, (String)"CREATE_ENDPOINT_FAILED_CNTR0083E", (Object[])new Object[]{t});
                ex = new UnavailableException("Creation of MessageEndpoint Proxy failed", t);
            }
        }
        if (ex != null) {
            if (this.ivInvocationHandlerPool != null) {
                if (endpoint != null && proxy != null) {
                    MessageEndpointBase.reset(endpoint);
                    this.ivInvocationHandlerPool.put((Object)endpoint);
                } else if (newInstanceRequired) {
                    Object t = this.ivStateLock;
                    synchronized (t) {
                        --this.ivNumberOfMessageEndpointsCreated;
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                BeanMetaData bmd = this.beanMetaData;
                Tr.exit((TraceComponent)tc, (String)("createEndpoint for enterprise class " + bmd.enterpriseBeanName + " failed."));
            }
            throw ex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MEF.createEndpoint for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
        return (MessageEndpoint)proxy;
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        boolean transacted;
        EJBMethodInfoImpl minfo;
        BeanMetaData bmd = this.beanMetaData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("MEF.isDeliveryTransacted called for " + bmd.enterpriseBeanName + "." + method.getName()), (Object[])new Object[0]);
        }
        if ((minfo = this.getEJBMethodInfo(method)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("MEF.isDeliveryTransacted failed to find method " + bmd.enterpriseBeanName + "." + method.getName()));
            }
            Tr.error((TraceComponent)tc, (String)"NO_SUCH_MDB_METHOD_CNTR0085E", (Object[])new Object[]{bmd.j2eeName, method.getName(), bmd.localInterfaceClass});
            throw new NoSuchMethodException(bmd.enterpriseBeanName + "." + method.getName() + " not found");
        }
        EJBTransactionAttribute txAttr = minfo.getEJBTransactionAttribute();
        if (txAttr == EJBTransactionAttribute.REQUIRED) {
            transacted = true;
        } else if (txAttr == EJBTransactionAttribute.NOT_SUPPORTED) {
            transacted = false;
        } else if (txAttr == EJBTransactionAttribute.BEAN_MANAGED) {
            transacted = false;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("MEF.isDeliveryTransacted detected invalid TX attribute for " + bmd.enterpriseBeanName + "." + method.getName() + ", TX attribute is " + txAttr));
            }
            Tr.error((TraceComponent)tc, (String)"INVALID_MDB_TX_ATTR_CNTR0084E", (Object[])new Object[]{method.getName(), bmd.j2eeName});
            ApplicationServerInternalException r = new ApplicationServerInternalException("Method exists, but TX attribute is neither REQUIRED, NOT_SUPPORTED, nor BEAN_MANAGED: " + txAttr);
            NoSuchMethodException ex = new NoSuchMethodException("see chained exception");
            ex.initCause((Throwable)r);
            throw ex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MEF.isDeliveryTransacted returning " + transacted + " for " + bmd.enterpriseBeanName + "." + method.getName()));
        }
        return transacted;
    }

    private EJBMethodInfoImpl getEJBMethodInfo(Method method) {
        String targetSignature = MethodAttribUtils.methodSignature((Method)method);
        EJBMethodInfoImpl minfo2 = null;
        for (EJBMethodInfoImpl minfo2 : this.ivMdbMethods) {
            if (!targetSignature.equals(minfo2.getMethodSignature())) continue;
            return minfo2;
        }
        return null;
    }

    public void initialize(EJSContainer ejbContainer, BeanId id, BeanMetaData bmd) throws RemoteException {
        super.initialize(ejbContainer, id, bmd);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("MEF Initializing MessageEndpointFactory for enterprise class " + bmd.enterpriseBeanName + ", with message listener interface of " + bmd.localInterfaceClass.getName()), (Object[])new Object[0]);
        }
        this.ivMdbMethods = this.beanMetaData.localMethodInfos;
        this.ivMaxCreation = bmd.maxPoolSize;
        if (this.ivMaxCreation > 0) {
            MessageEndpointHandlerPool messageEndpointHandlerPool = new MessageEndpointHandlerPool(this);
            this.ivInvocationHandlerPool = this.container.poolManager.create(bmd.minPoolSize, bmd.maxPoolSize, null, (PoolDiscardStrategy)messageEndpointHandlerPool);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MessageEndpointFactory initialized for enterprise class " + bmd.enterpriseBeanName + " with messaging listener interface of " + bmd.localInterfaceClass.getName()));
        }
    }

    public void setRecoveryID(int recoveryId) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("MEF.setRecoveryID for enterprise class " + this.beanMetaData.enterpriseBeanName), (Object[])new Object[0]);
        }
        if (this.ivRecoveryIdKnown) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("MEF.setRecoveryID for enterprise class " + this.beanMetaData.enterpriseBeanName));
            }
            throw new ApplicationServerInternalException("setRecoveryId can only be called once per factory");
        }
        this.ivRecoveryId = recoveryId;
        this.ivRecoveryIdKnown = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MEF.setRecoveryID for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
    }

    public void setTranEnlistmentNotNeeded(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("MEF.setTranEnlistmentNotNeeded for enterprise class " + this.beanMetaData.enterpriseBeanName + ", reason =  " + reason), (Object[])new Object[0]);
        }
        this.ivEnlistNotNeeded = true;
        this.ivEnlistNotNeededReason = reason;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MEF.setTranEnlistmentNotNeeded for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
    }

    private UnavailableException mapAndLogTranEnlistmentNotNeeded() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("MEF.mapAndLogTranEnlistmentNotNeeded for enterprise class " + this.beanMetaData.enterpriseBeanName), (Object[])new Object[0]);
        }
        UnavailableException ex = null;
        switch (this.ivEnlistNotNeededReason) {
            case 0: {
                if (!this.ivEnlistNotNeededMessageLogged) {
                    Tr.error((TraceComponent)tc, (String)"RA_DOES_NOT_SUPPORT_XATRANSACTIONS_CNTR0087E", (Object[])new Object[]{this.ivRAKey, this.beanMetaData.j2eeName});
                }
                ex = new UnavailableException("Transaction recovery not setup for this RA since RA does not support XA transactions");
                break;
            }
            case 1: {
                if (!this.ivEnlistNotNeededMessageLogged) {
                    Tr.error((TraceComponent)tc, (String)"ERROR_DURING_TRAN_RECOVERY_SETUP_CNTR0086E", (Object[])new Object[]{this.ivRAKey, this.beanMetaData.j2eeName});
                }
                ex = new UnavailableException("Error occured during transaction recovery setup for this Resource Adapter");
                break;
            }
            default: {
                if (!this.ivEnlistNotNeededMessageLogged) {
                    Tr.error((TraceComponent)tc, (String)"REASON_CODE_NOT_RECOGNIZED_CNTR0081E", (Object[])new Object[]{this.ivEnlistNotNeededReason});
                }
                ex = new UnavailableException("Error occured during transaction recovery setup for this Resource Adapter");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MEF.mapAndLogTranEnlistmentNotNeeded for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
        this.ivEnlistNotNeededMessageLogged = true;
        return ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnInvocationHandler(MessageEndpointBase endpoint, boolean reuse) {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"MEF.returnInvocationHandler", (Object[])new Object[0]);
        }
        if (this.ivInvocationHandlerPool != null) {
            if (reuse) {
                MessageEndpointBase.reset(endpoint);
                this.ivInvocationHandlerPool.put((Object)endpoint);
            }
            object = this.ivStateLock;
            synchronized (object) {
                this.ivStateLock.notify();
            }
        }
        if (this.ivInvocationHandlerPool == null || !reuse) {
            object = this.ivStateLock;
            synchronized (object) {
                --this.ivNumberOfMessageEndpointsCreated;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"MEF.returnInvocationHandler");
        }
    }

    public void setRAKey(String raKey) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("MEF.setRAKey for enterprise class " + this.beanMetaData.enterpriseBeanName), (Object[])new Object[0]);
        }
        this.ivRAKey = raKey;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MEF.setRAKey for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
    }

    protected abstract boolean isEndpointActive();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"MEF.discard", (Object[])new Object[0]);
        }
        if (this.ivInvocationHandlerPool != null) {
            Object object = this.ivStateLock;
            synchronized (object) {
                --this.ivNumberOfMessageEndpointsCreated;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"MEF.discard");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationStarted(String appName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("MEF.applicationStarted for application " + appName), (Object[])new Object[0]);
        }
        Object object = this.ivStateLock;
        synchronized (object) {
            this.ivState = (byte)2;
            this.ivStateLock.notifyAll();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MEF.applicationStarted for application " + appName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationStopping(String appName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("MEF.applicationStopping for application " + appName), (Object[])new Object[0]);
        }
        Object object = this.ivStateLock;
        synchronized (object) {
            if (this.ivState == 2) {
                this.ivState = (byte)4;
            } else if (this.ivState == 1) {
                this.ivState = (byte)4;
                this.ivStateLock.notifyAll();
            } else if (this.ivState == 4) {
                this.ivStateLock.notifyAll();
            } else if (this.ivState == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("MEF.applicationStopping for application " + appName + " was called for an inactive endpoint."), (Object[])new Object[0]);
                }
            } else {
                String msg = "Internal programming error - applicationStopping called for application \"" + appName + "\" while in deactivating state. This should NEVER occur.";
                IllegalStateException ex = new IllegalStateException(msg);
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".applicationStopping"), (String)"1208", (Object)((Object)this));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MEF.applicationStopping for application " + appName));
        }
    }

    protected void setMaxEndpoints(int maxEndpoints) {
        if (this.ivMaxCreation != maxEndpoints) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setMaxEndpoints = " + maxEndpoints), (Object[])new Object[0]);
            }
            this.ivMaxCreation = maxEndpoints;
            if (this.beanPool != null) {
                this.beanPool.setMaxSize(Math.min(maxEndpoints, this.beanPool.getMaxSize()));
            }
            if (this.ivInvocationHandlerPool != null) {
                this.ivInvocationHandlerPool.setMaxSize(Math.min(maxEndpoints, this.ivInvocationHandlerPool.getMaxSize()));
            }
        }
    }

    public String getActivationName() {
        return this.beanMetaData.getJ2EEName().toString();
    }

    public Class<?> getEndpointClass() {
        return this.beanMetaData.enterpriseBeanClass;
    }
}

