/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.websphere.cpi.CPIException;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSITransactionRolledbackException;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.ContainerSynchronization;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.transaction.Synchronization;

public class ContainerAS
implements Synchronization,
ContainerSynchronization {
    private static final String CLASS_NAME = ContainerAS.class.getName();
    private static final TraceComponent tc = Tr.register(ContainerAS.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final int ACTIVE = 0;
    private static final int PREPARING = 1;
    private static final String[] stateStrs = new String[]{"Active", "Preparing"};
    private EJSContainer ivContainer;
    private HashMap<BeanId, BeanO> ivBeanOs;
    private ArrayList<BeanO> ivBeanOList;
    private int ivState;
    private Object ivASKey;
    private long ivASCacheHits = 0L;
    private long ivASCacheSearch = 0L;

    private final void becomePreparing() {
        if (this.ivState != 0) {
            throw new IllegalStateException(stateStrs[this.ivState]);
        }
        this.ivState = 1;
    }

    private final void ensureActive() {
        switch (this.ivState) {
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException(stateStrs[this.ivState]);
            }
        }
    }

    public ContainerAS(EJSContainer container2, Object asKey) {
        this.ivContainer = container2;
        this.ivASKey = asKey;
        this.ivBeanOs = new HashMap();
        this.ivBeanOList = new ArrayList();
        this.ivState = 0;
    }

    public void beforeCompletion() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"beforeCompletion", (Object[])new Object[0]);
        }
        this.becomePreparing();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"beforeCompletion");
        }
    }

    public void afterCompletion(int status) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("afterCompletion (" + status + ") : " + this), (Object[])new Object[0]);
        }
        try {
            BeanO[] beanOs = this.getBeanOs();
            EJBKey[] ejbKeys = this.getEJBKeys(beanOs);
            if (beanOs != null) {
                for (int i = 0; i < beanOs.length; ++i) {
                    BeanO beanO = beanOs[i];
                    try {
                        this.ivContainer.activator.unitOfWorkEnd(this, beanO);
                        continue;
                    }
                    catch (Throwable ex) {
                        FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".afterCompletion"), (String)"214", (Object)this);
                        if (!isTraceOn || !tc.isEventEnabled()) continue;
                        Tr.event((TraceComponent)tc, (String)"Exception thrown in afterCompletion()", (Object[])new Object[]{beanO, ex});
                    }
                }
            }
            this.ivContainer.uowCtrl.sessionEnded(ejbKeys);
            ContainerTx tx = this.ivContainer.getCurrentTx(false);
            if (tx != null) {
                tx.setContainerAS(null);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"removed ContainerAS during afterCompletion", (Object[])new Object[0]);
                }
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".afterCompletion"), (String)"219", (Object)this);
            if (isTraceOn && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Exception during afterCompletion", (Object[])new Object[]{t});
            }
            throw new RuntimeException(t.toString());
        }
        finally {
            this.ivContainer.containerASCompleted(this.ivASKey);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"afterCompletion");
        }
    }

    public BeanO find(BeanId beanId) {
        BeanO bean = this.ivBeanOs.get(beanId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            ++this.ivASCacheSearch;
            if (bean != null) {
                ++this.ivASCacheHits;
                Tr.debug((TraceComponent)tc, (String)("Bean found in ActivitySession cache (Hit Rate:" + this.ivASCacheHits + "/" + this.ivASCacheSearch + ")"), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)("Bean not in ActivitySession cache (Hit Rate:" + this.ivASCacheHits + "/" + this.ivASCacheSearch + ")"), (Object[])new Object[0]);
            }
        }
        return bean;
    }

    public boolean isEnlisted(BeanId beanId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isEnlisted : " + (this.ivBeanOs.get(beanId) != null)), (Object[])new Object[0]);
        }
        return this.ivBeanOs.get(beanId) != null;
    }

    public boolean enlist(BeanO beanO) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("enlist : " + beanO), (Object[])new Object[0]);
        }
        this.ensureActive();
        BeanO oldBeanO = this.ivBeanOs.put(beanO.beanId, beanO);
        if (oldBeanO == null) {
            this.ivBeanOList.add(beanO);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlist : true");
            }
            return true;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enlist : false");
        }
        return false;
    }

    public void delist(BeanO beanO) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("delist : " + beanO), (Object[])new Object[0]);
        }
        this.ensureActive();
        this.ivBeanOs.remove(beanO.beanId);
        this.ivBeanOList.remove(beanO);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("delist : " + beanO));
        }
    }

    public void registerSynchronization(Synchronization s) throws CPIException {
        try {
            this.ivContainer.uowCtrl.enlistWithSession(s);
        }
        catch (CSIException e) {
            throw new CPIException(e.toString());
        }
    }

    private EJBKey[] getEJBKeys(BeanO[] beans) {
        EJBKey[] result = null;
        if (beans != null) {
            result = new EJBKey[beans.length];
            for (int i = 0; i < beans.length; ++i) {
                result[i] = beans[i].getId();
            }
        }
        return result;
    }

    private BeanO[] getBeanOs() {
        BeanO[] result = new BeanO[this.ivBeanOs.size()];
        Iterator<BeanO> iter = this.ivBeanOs.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            result[i++] = iter.next();
        }
        return result;
    }

    boolean isBmasActive(EJBMethodInfoImpl methodInfo) {
        return this.ivContainer.uowCtrl.isBmasActive(methodInfo);
    }

    public static ContainerAS getContainerAS(ContainerTx tx) {
        ContainerAS as;
        block3: {
            as = null;
            try {
                if (tx != null) {
                    as = tx.getContainerAS();
                    return as;
                }
                as = ContainerAS.getCurrentContainerAS();
            }
            catch (CSIException ce) {
                FFDCFilter.processException((Throwable)ce, (String)(CLASS_NAME + ".getContainerAS"), (String)"402");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block3;
                Tr.event((TraceComponent)tc, (String)"Exception thrown getting ContainerAS", (Object[])new Object[]{ce});
            }
        }
        return as;
    }

    public static ContainerAS getCurrentContainerAS() throws CSIException, CSITransactionRolledbackException {
        EJSContainer container2 = EJSContainer.getDefaultContainer();
        ContainerAS cas = null;
        cas = container2.getCurrentSessionalUOW(false);
        return cas;
    }

    public void setCompleting(boolean isCompleting) {
    }

    public void dump() {
        Tr.dump((TraceComponent)tc, (String)"-- ContainerAS Dump --", (Object[])new Object[]{this, this.ivBeanOs});
    }
}

