/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.interceptors;

import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.interceptors.InterceptorProxy;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.ejs.csi.EJBModuleMetaDataImpl;
import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.managedobject.ConstructionCallback;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectContext;
import com.ibm.ws.managedobject.ManagedObjectInvocationContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.interceptor.InvocationContext;

public class InvocationContextImpl<T>
implements InvocationContext,
ManagedObjectInvocationContext<T> {
    private static final TraceComponent tc = Tr.register(InvocationContextImpl.class, (String)"EJB3Interceptors", (String)"com.ibm.ejs.container.container");
    private Method ivMethod;
    private T ivBean;
    private Object[] ivParameters = new Object[0];
    private Timer ivTimer;
    private InterceptorProxy[] ivInterceptorProxies;
    private int ivNextIndex;
    private int ivNumberOfInterceptors;
    private Object[] ivInterceptors;
    private boolean ivParametersModified = false;
    private EJSDeployedSupport ivEJSDeployedSupport;
    private final EJSContainer ivContainer = EJSContainer.getDefaultContainer();
    private ConstructionCallback<T> ivConstructCallback;
    private boolean ivIsAroundConstruct;
    public Exception ivAroundConstructException;
    private ManagedObjectContext ivManagedObjectContext;

    public void initialize(T bean, ManagedObjectContext managedObjectContext, Object[] interceptors) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("initialize for bean = " + bean + ", context = " + managedObjectContext + ", interceptors = " + Arrays.toString(interceptors)), (Object[])new Object[0]);
        }
        this.ivBean = bean;
        this.ivManagedObjectContext = managedObjectContext;
        this.ivInterceptors = interceptors;
        this.ivInterceptorProxies = null;
        this.ivTimer = null;
    }

    public void setTimer(Timer timer) {
        this.ivTimer = timer;
    }

    public void initializeForAroundConstruct(ManagedObjectContext managedObjectContext, Object[] interceptors, InterceptorProxy[] proxies) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("initializeForAroundConstruct : context = " + managedObjectContext + " interceptors = " + Arrays.toString(interceptors) + ", proxies = " + Arrays.toString(proxies)), (Object[])new Object[0]);
        }
        this.ivBean = null;
        this.ivManagedObjectContext = managedObjectContext;
        this.ivInterceptors = interceptors;
        this.ivInterceptorProxies = proxies;
        this.ivTimer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T aroundConstruct(ConstructionCallback<T> constructionCallback, Object[] parameters, Map<String, Object> data) throws Exception {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("aroundConstruct : " + constructionCallback + ", " + Util.identity((Object[])parameters) + ", " + data), (Object[])new Object[0]);
        }
        try {
            this.ivConstructCallback = constructionCallback;
            this.ivParameters = parameters;
            this.ivIsAroundConstruct = true;
            if (data != null && data.size() > 0) {
                this.getContextData().putAll(data);
            }
            this.doAroundInterceptor();
            T t = this.ivBean;
            return t;
        }
        finally {
            this.ivConstructCallback = null;
            this.ivParameters = null;
            this.ivIsAroundConstruct = false;
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"aroundConstruct");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doAroundInvoke(InterceptorProxy[] proxies, Method businessMethod, Object[] parameters, EJSDeployedSupport s) throws Exception {
        this.ivMethod = businessMethod;
        this.ivParameters = parameters;
        this.ivEJSDeployedSupport = s;
        this.ivInterceptorProxies = proxies;
        this.ivIsAroundConstruct = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("doAroundInvoke for business method: " + this.ivMethod.getName()), (Object[])new Object[0]);
        }
        try {
            Object object = this.doAroundInterceptor();
            return object;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("doAroundInvoke for business method: " + this.ivMethod.getName()));
            }
            this.ivMethod = null;
            this.ivParameters = null;
        }
    }

    private Object doAroundInterceptor() throws Exception {
        this.ivNextIndex = 0;
        this.ivNumberOfInterceptors = this.ivInterceptorProxies == null ? 0 : this.ivInterceptorProxies.length;
        this.ivParametersModified = false;
        return this.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLifeCycle(InterceptorProxy[] proxies, EJBModuleMetaDataImpl mmd) {
        this.ivMethod = null;
        this.ivParameters = null;
        this.ivInterceptorProxies = proxies;
        this.ivNumberOfInterceptors = this.ivInterceptorProxies.length;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("doLifeCycle, number of interceptors = " + this.ivNumberOfInterceptors), (Object[])new Object[0]);
        }
        if (this.ivNumberOfInterceptors > 0) {
            this.ivNextIndex = 0;
            try {
                this.proceed();
            }
            catch (Throwable t) {
                this.lifeCycleExceptionHandler(t, mmd);
            }
            finally {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"doLifeCycle");
                }
            }
        }
    }

    private void lifeCycleExceptionHandler(Throwable t, EJBModuleMetaDataImpl mmd) {
        if (t instanceof RuntimeException) {
            RuntimeException rtex = (RuntimeException)t;
            if (mmd.getApplicationExceptionRollback(rtex) != null) {
                InterceptorProxy w = this.ivInterceptorProxies[this.ivNextIndex - 1];
                String lifeCycle = w.getMethodGenericString();
                EJBException ex = ExceptionUtil.EJBException(lifeCycle + " is not allowed to throw an application exception", rtex);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"lifeCycleExceptionHandler throwing EJBException", (Object[])new Object[]{ex});
                }
                throw ex;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("lifeCycleExceptionHandler is rethrowing RuntimeException from lifecycle callback method: " + t), (Object[])new Object[]{t});
            }
            throw rtex;
        }
        if (t instanceof Error) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("lifeCycleExceptionHandler is rethrowing Error from lifecycle callback method: " + t), (Object[])new Object[]{t});
            }
            throw (Error)t;
        }
        InterceptorProxy w = this.ivInterceptorProxies[this.ivNextIndex - 1];
        String lifeCycle = w.getMethodGenericString();
        EJBException ex = ExceptionUtil.EJBException(lifeCycle + " is not allowed to throw a checked exception", t);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"lifeCycleExceptionHandler throwing EJBException", (Object[])new Object[]{ex});
        }
        throw ex;
    }

    public Object getTarget() {
        return this.ivBean;
    }

    public Method getMethod() {
        return this.ivMethod;
    }

    public Object[] getParameters() {
        if (this.ivMethod == null && !this.ivIsAroundConstruct) {
            throw new IllegalStateException("InvocationContext.getParameter can not be called by lifecycle callback methods");
        }
        return this.ivParameters;
    }

    public Object getTimer() {
        return this.ivTimer;
    }

    public void setParameters(Object[] args) {
        String debug;
        if (this.ivMethod == null && !this.ivIsAroundConstruct) {
            throw new IllegalStateException("InvocationContext.setParameter can not be called by lifecycle callback methods");
        }
        Constructor<T> con = this.getConstructor();
        Class<?>[] parmTypes = con != null ? con.getParameterTypes() : this.ivMethod.getParameterTypes();
        String string = debug = con != null ? "constructor: " + con.getName() : "business method: " + this.ivMethod.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setParameters for " + debug), (Object[])new Object[0]);
        }
        int n = parmTypes.length;
        if (args == null) {
            if (n > 0) {
                throw new IllegalArgumentException("null not valid as argument for setParameters method.");
            }
        } else {
            if (args.length != n) {
                throw new IllegalArgumentException("wrong number of parameters for method being invoked.");
            }
            for (int i = 0; i < n; ++i) {
                Class<?> parmType = parmTypes[i];
                if (!parmType.isPrimitive()) {
                    if (args[i] == null || parmType.isInstance(args[i])) continue;
                    throw new IllegalArgumentException("wrong data type for parameter " + (i + 1));
                }
                if (parmType == Integer.TYPE && !(args[i] instanceof Integer)) {
                    throw new IllegalArgumentException("parameter " + (i + 1) + " is a " + args[i].getClass().getName() + ", but it is required to be a Integer");
                }
                if (parmType == Long.TYPE && !(args[i] instanceof Long)) {
                    throw new IllegalArgumentException("parameter " + (i + 1) + " is a " + args[i].getClass().getName() + ", but it is required to be a Long");
                }
                if (parmType == Short.TYPE && !(args[i] instanceof Short)) {
                    throw new IllegalArgumentException("parameter " + (i + 1) + " is a " + args[i].getClass().getName() + ", but it is required to be a Short");
                }
                if (parmType == Boolean.TYPE && !(args[i] instanceof Boolean)) {
                    throw new IllegalArgumentException("parameter " + (i + 1) + " is a " + args[i].getClass().getName() + ", but it is required to be a Boolean");
                }
                if (parmType == Byte.TYPE && !(args[i] instanceof Byte)) {
                    throw new IllegalArgumentException("parameter " + (i + 1) + " is a " + args[i].getClass().getName() + ", but it is required to be a Byte");
                }
                if (parmType == Character.TYPE && !(args[i] instanceof Character)) {
                    throw new IllegalArgumentException("parameter " + (i + 1) + " is a " + args[i].getClass().getName() + ", but it is required to be a Character");
                }
                if (parmType == Float.TYPE && !(args[i] instanceof Float)) {
                    throw new IllegalArgumentException("parameter " + (i + 1) + " is a " + args[i].getClass().getName() + ", but it is required to be a Float");
                }
                if (parmType != Double.TYPE || args[i] instanceof Double) continue;
                throw new IllegalArgumentException("parameter " + (i + 1) + " is a " + args[i].getClass().getName() + ", but it is required to be a Double");
            }
            this.ivParameters = args;
            this.ivParametersModified = true;
        }
    }

    public Map<String, Object> getContextData() {
        return EJSContainer.getThreadData().getContextData();
    }

    public Object proceed() throws Exception {
        Object returnValue;
        block10: {
            returnValue = null;
            try {
                if (this.ivNextIndex < this.ivNumberOfInterceptors) {
                    InterceptorProxy w = this.ivInterceptorProxies[this.ivNextIndex];
                    if (w.ivRequiresInvocationContext) {
                        ++this.ivNextIndex;
                        returnValue = w.invokeInterceptor(this.ivBean, this, this.ivInterceptors);
                    } else {
                        while (w != null) {
                            ++this.ivNextIndex;
                            returnValue = w.invokeInterceptor(this.ivBean, this, this.ivInterceptors);
                            w = this.ivNextIndex < this.ivNumberOfInterceptors ? this.ivInterceptorProxies[this.ivNextIndex] : null;
                        }
                    }
                    break block10;
                }
                if (this.ivMethod != null) {
                    returnValue = this.ivContainer.invokeProceed(this.ivEJSDeployedSupport, this.ivMethod, this.ivBean, this.ivParameters, this.ivParametersModified);
                    break block10;
                }
                if (!this.ivIsAroundConstruct) break block10;
                try {
                    this.ivBean = this.ivConstructCallback.proceed(this.ivParameters, this.getContextData());
                }
                catch (Exception ex) {
                    this.ivAroundConstructException = ex;
                    throw ex;
                }
                return null;
            }
            catch (UndeclaredThrowableException ude) {
                this.throwUndeclaredExceptionCause(ude);
            }
            catch (InvocationTargetException ite) {
                this.throwUndeclaredExceptionCause(ite);
            }
        }
        return this.ivMethod == null ? null : returnValue;
    }

    private void throwUndeclaredExceptionCause(Throwable undeclaredException) throws Exception {
        Throwable cause = undeclaredException.getCause();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("proceed unwrappering " + undeclaredException.getClass().getSimpleName() + " : " + cause), (Object[])new Object[]{cause});
        }
        if (cause instanceof UndeclaredThrowableException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("proceed unwrappering " + cause.getClass().getSimpleName() + " : " + cause), (Object[])new Object[]{cause.getCause()});
            }
            cause = cause.getCause();
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw (Exception)cause;
    }

    public Constructor<T> getConstructor() {
        if (this.ivIsAroundConstruct) {
            return this.ivConstructCallback.getConstructor();
        }
        return null;
    }

    public ManagedObjectContext getManagedObjectContext() {
        return this.ivManagedObjectContext;
    }

    public void prePostConstruct(ManagedObject<T> mo) {
    }
}

