/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer;

public enum EJBType {
    SINGLETON_SESSION(2),
    STATEFUL_SESSION(4),
    STATELESS_SESSION(3),
    BEAN_MANAGED_ENTITY(5),
    CONTAINER_MANAGED_ENTITY(6),
    MESSAGE_DRIVEN(7);

    private static final EJBType[] FOR_VALUE;
    private final int ivValue;

    public static EJBType forValue(int value) {
        return FOR_VALUE[value];
    }

    private EJBType(int value) {
        this.ivValue = value;
    }

    public int value() {
        return this.ivValue;
    }

    public boolean isSession() {
        return this == SINGLETON_SESSION || this == STATEFUL_SESSION || this == STATELESS_SESSION;
    }

    public boolean isEntity() {
        return this == BEAN_MANAGED_ENTITY || this == CONTAINER_MANAGED_ENTITY;
    }

    public boolean isMessageDriven() {
        return this == MESSAGE_DRIVEN;
    }

    static {
        EJBType[] values = EJBType.values();
        int maxValue = 0;
        for (EJBType type : values) {
            maxValue = Math.max(maxValue, type.value());
        }
        FOR_VALUE = new EJBType[maxValue + 1];
        EJBType[] eJBTypeArray = values;
        int n = eJBTypeArray.length;
        for (int i = 0; i < n; ++i) {
            EJBType type;
            EJBType.FOR_VALUE[type.value()] = type = eJBTypeArray[i];
        }
    }
}

