/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.multipart;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessControlContext;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.equinox.http.servlet.internal.multipart.MultipartSupport;
import org.eclipse.equinox.http.servlet.internal.multipart.MultipartSupportPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.runtime.dto.ServletDTO;

public class MultipartSupportImpl
implements MultipartSupport {
    private final ServletDTO servletDTO;
    private final ServletFileUpload upload;

    public MultipartSupportImpl(ServletDTO servletDTO, ServletContext servletContext) {
        this.servletDTO = servletDTO;
        File baseStorage = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        if (servletDTO.multipartLocation.length() > 0) {
            File storage = new File(servletDTO.multipartLocation);
            if (!storage.isAbsolute()) {
                storage = new File(baseStorage, storage.getPath());
            }
            baseStorage = storage;
        }
        this.checkPermission(baseStorage, servletContext);
        baseStorage.mkdirs();
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setRepository(baseStorage);
        if (servletDTO.multipartFileSizeThreshold > 0) {
            factory.setSizeThreshold(servletDTO.multipartFileSizeThreshold);
        }
        this.upload = new ServletFileUpload((FileItemFactory)factory);
        if (servletDTO.multipartMaxFileSize > -1L) {
            this.upload.setFileSizeMax(servletDTO.multipartMaxFileSize);
        }
        if (servletDTO.multipartMaxRequestSize > -1L) {
            this.upload.setSizeMax(servletDTO.multipartMaxRequestSize);
        }
    }

    private void checkPermission(File baseStorage, ServletContext servletContext) {
        BundleContext bundleContext = (BundleContext)servletContext.getAttribute("osgi-bundlecontext");
        Bundle bundle = bundleContext.getBundle();
        AccessControlContext accessControlContext = (AccessControlContext)bundle.adapt(AccessControlContext.class);
        if (accessControlContext == null) {
            return;
        }
        accessControlContext.checkPermission(new FilePermission(baseStorage.getAbsolutePath(), "read,write"));
    }

    @Override
    public Map<String, Part> parseRequest(HttpServletRequest request) throws IOException, ServletException {
        if (this.upload == null) {
            throw new IllegalStateException("Servlet was not configured for multipart!");
        }
        if (!this.servletDTO.multipartEnabled) {
            throw new IllegalStateException("No multipart config on " + (Object)((Object)this.servletDTO));
        }
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            throw new ServletException("Not a multipart request!");
        }
        HashMap<String, Part> parts = new HashMap<String, Part>();
        try {
            for (Object item : this.upload.parseRequest(request)) {
                DiskFileItem diskFileItem = (DiskFileItem)item;
                parts.put(diskFileItem.getFieldName(), new MultipartSupportPart(diskFileItem));
            }
        }
        catch (FileUploadException fnfe) {
            throw new IOException(fnfe);
        }
        return parts;
    }
}

