/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.featureUtility.cli;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.featureUtility.FeatureUtility;
import com.ibm.ws.install.internal.ProgressBar;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.ActionHandler;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.boot.cmdline.ExitCode;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FindAction
implements ActionHandler {
    private List<String> argList;
    private ProgressBar progressBar;

    public ExitCode handleTask(PrintStream stdout, PrintStream stderr, Arguments args) {
        ExitCode rc = this.initialize(args);
        if (!rc.equals(ReturnCode.OK)) {
            return rc;
        }
        rc = this.execute();
        return rc;
    }

    private ExitCode initialize(Arguments args) {
        this.argList = args.getPositionalArguments();
        this.progressBar = ProgressBar.getInstance();
        HashMap<String, Double> methodMap = new HashMap<String, Double>();
        methodMap.put("initializeMap", 5.0);
        methodMap.put("fetchJsons", 20.0);
        methodMap.put("findFeatures", 75.0);
        this.progressBar.setMethodMap(methodMap);
        return ReturnCode.OK;
    }

    private ExitCode execute() {
        try {
            FeatureUtility featureUtility = new FeatureUtility.FeatureUtilityBuilder().setFeaturesToInstall(this.argList).setAdditionalJsons(new ArrayList<String>()).build();
            featureUtility.findFeatures();
            this.progressBar.finish();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.progressBar.finishWithError();
        }
        catch (InstallException e) {
            e.printStackTrace();
            this.progressBar.finishWithError();
        }
        return ReturnCode.OK;
    }
}

