/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.json;

import io.smallrye.graphql.client.typesafe.api.GraphQlClientException;
import io.smallrye.graphql.client.typesafe.impl.json.GraphQlClientValueException;
import io.smallrye.graphql.client.typesafe.impl.json.JsonReader;
import io.smallrye.graphql.client.typesafe.impl.json.Location;
import io.smallrye.graphql.client.typesafe.impl.json.Reader;
import io.smallrye.graphql.client.typesafe.impl.reflection.FieldInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import javax.json.JsonObject;
import javax.json.JsonValue;

class JsonObjectReader
extends Reader<JsonObject> {
    JsonObjectReader(TypeInfo type, Location location, JsonObject value) {
        super(type, location, value);
    }

    @Override
    Object read() {
        GraphQlClientValueException.check(this.location, this.value, !this.type.isCollection() && !this.type.isScalar());
        Object instance = this.newInstance();
        this.type.fields().forEach(field -> {
            Object fieldValue = this.buildValue(this.location, (JsonObject)this.value, (FieldInfo)field);
            field.set(instance, fieldValue);
        });
        return instance;
    }

    private Object newInstance() {
        try {
            return this.type.newInstance();
        }
        catch (Exception e) {
            throw new GraphQlClientException("can't create " + this.location, e);
        }
    }

    private Object buildValue(Location location, JsonObject value, FieldInfo field) {
        Location fieldLocation = new Location(field.getType(), location.getDescription() + "." + field.getName());
        JsonValue jsonFieldValue = (JsonValue)value.get((Object)field.getName());
        if (jsonFieldValue == null) {
            if (field.isNonNull()) {
                throw new GraphQlClientException("missing " + fieldLocation);
            }
            return null;
        }
        return JsonReader.readJson(fieldLocation, field.getType(), jsonFieldValue);
    }
}

