/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.reflection;

import io.smallrye.graphql.client.typesafe.api.GraphQlClientException;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import java.util.Objects;
import java.util.Optional;

public class MethodResolver {
    private final TypeInfo callerType;
    private String expression;

    public MethodResolver(TypeInfo callerType, String expression) {
        this.callerType = callerType;
        this.expression = expression;
    }

    public MethodInfo resolve() {
        TypeInfo ownerType;
        int lastDot = this.expression.lastIndexOf(46);
        if (lastDot >= 0) {
            ownerType = this.toClass(this.expression.substring(0, lastDot));
            this.expression = this.expression.substring(lastDot + 1);
        } else {
            ownerType = this.callerType;
        }
        MethodInfo method = this.resolveEnclosing(ownerType, this.expression).orElseThrow(() -> new GraphQlClientException("no no-arg method '" + this.expression + "' found in " + ownerType));
        if (!method.isAccessibleFrom(this.callerType)) {
            throw new GraphQlClientException(this.callerType.getTypeName() + " can't access " + method);
        }
        return method;
    }

    private Optional<MethodInfo> resolveEnclosing(TypeInfo type, String expression) {
        return type.enclosingTypes().map(t -> t.getMethod(expression, new Class[0]).orElse(null)).filter(Objects::nonNull).findFirst();
    }

    private TypeInfo toClass(String className) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return TypeInfo.of(Class.forName(className, true, loader));
        }
        catch (ClassNotFoundException e) {
            throw new GraphQlClientException("class not found for expression '" + this.expression + "'", e);
        }
    }
}

