/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.helper;

import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.execution.event.InvokeInfo;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.spi.ClassloadingService;
import io.smallrye.graphql.spi.LookupService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.eclipse.microprofile.graphql.GraphQLException;

public class ReflectionHelper {
    private final LookupService lookupService = LookupService.get();
    private final ClassloadingService classloadingService = ClassloadingService.get();
    private final Operation operation;
    private final EventEmitter eventEmitter;
    private final Class<?> operationClass;
    private final Method method;

    public ReflectionHelper(Operation operation, EventEmitter eventEmitter) {
        this.operation = operation;
        this.eventEmitter = eventEmitter;
        this.operationClass = this.classloadingService.loadClass(operation.getClassName());
        this.method = this.lookupMethod(this.operationClass, operation);
    }

    public <T> T invoke(Object ... arguments) throws Exception {
        try {
            Object operationInstance = this.lookupService.getInstance(this.operationClass);
            this.eventEmitter.fireBeforeMethodInvoke(new InvokeInfo(operationInstance, this.method, arguments));
            return (T)this.method.invoke(operationInstance, arguments);
        }
        catch (InvocationTargetException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof GraphQLException) {
                throw (GraphQLException)throwable;
            }
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw SmallRyeGraphQLServerMessages.msg.dataFetcherException(this.operation, throwable);
        }
    }

    private Method lookupMethod(Class<?> operationClass, Operation operation) {
        try {
            return operationClass.getMethod(operation.getMethodName(), this.getParameterClasses(operation));
        }
        catch (NoSuchMethodException e) {
            throw SmallRyeGraphQLServerMessages.msg.dataFetcherException(operation, e);
        }
    }

    private Class<?>[] getParameterClasses(Operation operation) {
        if (operation.hasArguments()) {
            LinkedList cl = new LinkedList();
            for (Field field : operation.getArguments()) {
                Class<?> clazz;
                if (field.hasArray()) {
                    clazz = this.classloadingService.loadClass(field.getArray().getClassName());
                    cl.add(clazz);
                    continue;
                }
                clazz = this.classloadingService.loadClass(field.getReference().getClassName());
                cl.add(clazz);
            }
            return cl.toArray(new Class[0]);
        }
        return null;
    }
}

