/*
 * Decompiled with CFR 0.152.
 */
package v2.io.swagger.converter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import v2.io.swagger.converter.ModelConverter;
import v2.io.swagger.converter.ModelConverterContext;
import v2.io.swagger.models.ComposedModel;
import v2.io.swagger.models.Model;
import v2.io.swagger.models.ModelImpl;
import v2.io.swagger.models.properties.Property;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ModelConverterContextImpl
implements ModelConverterContext {
    private final List<ModelConverter> converters;
    private final Map<String, Model> modelByName;
    private final HashMap<Type, Model> modelByType;
    private final Set<Type> processedTypes;
    private static final TraceComponent tc = Tr.register(ModelConverterContextImpl.class, (String)"SwaggerCore");
    static final long serialVersionUID = 4879241170009982566L;

    public ModelConverterContextImpl(List<ModelConverter> converters) {
        this.converters = converters;
        this.modelByName = new TreeMap<String, Model>();
        this.modelByType = new HashMap();
        this.processedTypes = new HashSet<Type>();
    }

    public ModelConverterContextImpl(ModelConverter converter) {
        this(new ArrayList<ModelConverter>());
        this.converters.add(converter);
    }

    @Override
    public Iterator<ModelConverter> getConverters() {
        return this.converters.iterator();
    }

    @Override
    public void defineModel(String name, Model model) {
        this.defineModel(name, model, null, null);
    }

    @Override
    public void defineModel(String name, Model model, Type type, String prevName) {
        Tr.debug((TraceComponent)tc, (String)"defineModel {0} {1}", (Object[])new Object[]{name, model});
        this.modelByName.put(name, model);
        if (StringUtils.isNotBlank((CharSequence)prevName)) {
            this.modelByName.remove(prevName);
        }
        if (type != null) {
            this.modelByType.put(type, model);
        }
    }

    public Map<String, Model> getDefinedModels() {
        return Collections.unmodifiableMap(this.modelByName);
    }

    @Override
    public Property resolveProperty(Type type, Annotation[] annotations) {
        Tr.debug((TraceComponent)tc, (String)"resolveProperty {0}", (Object[])new Object[]{type});
        Iterator<ModelConverter> converters = this.getConverters();
        if (converters.hasNext()) {
            ModelConverter converter = converters.next();
            return converter.resolveProperty(type, this, annotations, converters);
        }
        return null;
    }

    @Override
    public Model resolve(Type type) {
        if (this.processedTypes.contains(type)) {
            return this.modelByType.get(type);
        }
        this.processedTypes.add(type);
        Tr.debug((TraceComponent)tc, (String)"resolve {0}", (Object[])new Object[]{type});
        Iterator<ModelConverter> converters = this.getConverters();
        Model resolved = null;
        if (converters.hasNext()) {
            ModelConverter converter = converters.next();
            Tr.debug((TraceComponent)tc, (String)"trying extension {0}", (Object[])new Object[]{converter});
            resolved = converter.resolve(type, this, converters);
        }
        if (resolved != null) {
            ModelImpl impl;
            this.modelByType.put(type, resolved);
            Model resolvedImpl = resolved;
            if (resolvedImpl instanceof ComposedModel) {
                resolvedImpl = ((ComposedModel)resolved).getChild();
            }
            if (resolvedImpl instanceof ModelImpl && (impl = (ModelImpl)resolvedImpl).getName() != null) {
                this.modelByName.put(impl.getName(), resolved);
            }
        }
        return resolved;
    }
}

