/*
 * Decompiled with CFR 0.152.
 */
package v2.io.swagger.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import v2.io.swagger.models.properties.PropertyBuilder;
import v2.io.swagger.util.AllowableValues;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AllowableRangeValues
implements AllowableValues {
    private static final Pattern RANGE_PATTERN;
    private static final String POSITIVE_INFINITY_KEY = "infinity";
    private static final String NEGATIVE_INFINITY_KEY = "-infinity";
    private static final String OPEN_EXCLUSIVE_RANGE_KEY = "(";
    private static final String CLOSE_EXCLUSIVE_RANGE_KEY = ")";
    private final BigDecimal minimum;
    private final BigDecimal maximum;
    private final boolean exclusiveMinimum;
    private final boolean exclusiveMaximum;
    static final long serialVersionUID = -7435705847409499649L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private AllowableRangeValues(BigDecimal minimum, boolean exclusiveMinimum, BigDecimal maximum, boolean exclusiveMaximum) {
        this.minimum = minimum;
        this.exclusiveMinimum = exclusiveMinimum;
        this.maximum = maximum;
        this.exclusiveMaximum = exclusiveMaximum;
    }

    public static AllowableRangeValues create(String allowableValues) {
        Matcher matcher = RANGE_PATTERN.matcher(allowableValues);
        return matcher.find() ? new AllowableRangeValues(AllowableRangeValues.findRangeValue(matcher.group(2)), AllowableRangeValues.isExclusiveRange(matcher.group(1)), AllowableRangeValues.findRangeValue(matcher.group(3)), AllowableRangeValues.isExclusiveRange(matcher.group(4))) : null;
    }

    private static BigDecimal findRangeValue(String value) {
        if (POSITIVE_INFINITY_KEY.equalsIgnoreCase(value) || NEGATIVE_INFINITY_KEY.equalsIgnoreCase(value)) {
            return null;
        }
        return new BigDecimal(value);
    }

    private static boolean isExclusiveRange(String value) {
        return OPEN_EXCLUSIVE_RANGE_KEY.equals(value) || CLOSE_EXCLUSIVE_RANGE_KEY.equals(value);
    }

    public BigDecimal getMinimum() {
        return this.minimum;
    }

    public BigDecimal getMaximum() {
        return this.maximum;
    }

    public boolean isExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public boolean isExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    @Override
    public Map<PropertyBuilder.PropertyId, Object> asPropertyArguments() {
        EnumMap<PropertyBuilder.PropertyId, Object> map = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class);
        map.put(PropertyBuilder.PropertyId.MINIMUM, (Object)this.minimum);
        map.put(PropertyBuilder.PropertyId.MAXIMUM, (Object)this.maximum);
        if (this.exclusiveMinimum) {
            map.put(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM, (Object)this.exclusiveMinimum);
        }
        if (this.exclusiveMaximum) {
            map.put(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM, (Object)this.exclusiveMaximum);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"v2.io.swagger.util.AllowableRangeValues", AllowableRangeValues.class, null, null);
        RANGE_PATTERN = Pattern.compile("range(\\[|\\()([^,\\s]+)\\s*,\\s*([^\\]\\s]+)\\s*(\\]|\\))");
    }
}

