/*
 * Decompiled with CFR 0.152.
 */
package v2.io.swagger.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import v2.io.swagger.converter.ModelConverters;
import v2.io.swagger.models.Model;
import v2.io.swagger.models.Swagger;
import v2.io.swagger.models.parameters.AbstractSerializableParameter;
import v2.io.swagger.models.parameters.BodyParameter;
import v2.io.swagger.models.parameters.Parameter;
import v2.io.swagger.models.properties.FileProperty;
import v2.io.swagger.models.properties.LongProperty;
import v2.io.swagger.models.properties.Property;
import v2.io.swagger.models.properties.PropertyBuilder;
import v2.io.swagger.util.AllowableValues;
import v2.io.swagger.util.AllowableValuesUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ParameterProcessor {
    private static final TraceComponent tc = Tr.register(ParameterProcessor.class, (String)"SwaggerCore");
    static final long serialVersionUID = 914584384994256518L;

    public static Parameter applyAnnotations(Swagger swagger, Parameter parameter, Type type, List<Annotation> annotations) {
        AnnotationsHelper helper = new AnnotationsHelper(annotations, type);
        if (helper.isContext()) {
            return null;
        }
        ParamWrapper<?> param = helper.getApiParam();
        if (param.isHidden()) {
            return null;
        }
        String defaultValue = helper.getDefaultValue();
        if (parameter instanceof AbstractSerializableParameter) {
            AbstractSerializableParameter p = (AbstractSerializableParameter)parameter;
            if (param.isRequired()) {
                p.setRequired(true);
            }
            if (param.getReadOnly()) {
                p.readOnly(Boolean.valueOf(param.getReadOnly()));
            }
            if (param.getAllowEmptyValue()) {
                p.allowEmptyValue(Boolean.valueOf(param.getAllowEmptyValue()));
            }
            if (StringUtils.isNotEmpty((CharSequence)param.getName())) {
                p.setName(param.getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)param.getDescription())) {
                p.setDescription(param.getDescription());
            }
            if (StringUtils.isNotEmpty((CharSequence)param.getExample())) {
                p.setExample(param.getExample());
            }
            if (StringUtils.isNotEmpty((CharSequence)param.getAccess())) {
                p.setAccess(param.getAccess());
            }
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{param.getCollectionFormat()})) {
                p.setCollectionFormat(param.getCollectionFormat());
            }
            if (StringUtils.isNotEmpty((CharSequence)param.getDataType())) {
                if ("java.io.File".equalsIgnoreCase(param.getDataType())) {
                    p.setProperty((Property)new FileProperty());
                } else if ("long".equalsIgnoreCase(param.getDataType())) {
                    p.setProperty((Property)new LongProperty());
                } else {
                    p.setType(param.getDataType());
                }
            }
            if (helper.getMin() != null) {
                p.setMinimum(helper.getMin());
                if (helper.isMinExclusive()) {
                    p.setExclusiveMinimum(Boolean.valueOf(true));
                }
            }
            if (helper.getMax() != null) {
                p.setMaximum(helper.getMax());
                if (helper.isMaxExclusive()) {
                    p.setExclusiveMaximum(Boolean.valueOf(true));
                }
            }
            if (helper.getMinItems() != null) {
                p.setMinItems(helper.getMinItems());
            }
            if (helper.getMaxItems() != null) {
                p.setMaxItems(helper.getMaxItems());
            }
            if (helper.getMinLength() != null) {
                p.setMinLength(helper.getMinLength());
            }
            if (helper.getMaxLength() != null) {
                p.setMaxLength(helper.getMaxLength());
            }
            if (helper.getPattern() != null) {
                p.setPattern(helper.getPattern());
            }
            if (helper.isRequired() != null) {
                p.setRequired(true);
            }
            if (helper.getType() != null) {
                p.setType(helper.getType());
            }
            if (helper.getFormat() != null) {
                p.setFormat(helper.getFormat());
            }
            AllowableValues allowableValues = AllowableValuesUtils.create(param.getAllowableValues());
            if (p.getItems() != null || param.isAllowMultiple()) {
                EnumMap<PropertyBuilder.PropertyId, Object> args;
                if (p.getItems() == null) {
                    args = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class);
                    args.put(PropertyBuilder.PropertyId.DEFAULT, p.getDefaultValue());
                    p.setDefaultValue(null);
                    args.put(PropertyBuilder.PropertyId.ENUM, (Object)p.getEnum());
                    p.setEnum(null);
                    args.put(PropertyBuilder.PropertyId.MINIMUM, (Object)p.getMinimum());
                    p.setMinimum(null);
                    args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM, (Object)p.isExclusiveMinimum());
                    p.setExclusiveMinimum(null);
                    args.put(PropertyBuilder.PropertyId.MAXIMUM, (Object)p.getMaximum());
                    p.setMaximum(null);
                    args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM, (Object)p.isExclusiveMaximum());
                    args.put(PropertyBuilder.PropertyId.MIN_LENGTH, (Object)p.getMinLength());
                    p.setMinLength(null);
                    args.put(PropertyBuilder.PropertyId.MAX_LENGTH, (Object)p.getMaxLength());
                    p.setMaxLength(null);
                    args.put(PropertyBuilder.PropertyId.PATTERN, (Object)p.getPattern());
                    p.setPattern(null);
                    args.put(PropertyBuilder.PropertyId.EXAMPLE, p.getExample());
                    p.setExclusiveMaximum(null);
                    Property items = PropertyBuilder.build((String)p.getType(), (String)p.getFormat(), args);
                    p.type("array").format(null).items(items);
                }
                args = new EnumMap(PropertyBuilder.PropertyId.class);
                if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
                    args.put(PropertyBuilder.PropertyId.DEFAULT, (Object)defaultValue);
                }
                if (helper.getMin() != null) {
                    args.put(PropertyBuilder.PropertyId.MINIMUM, (Object)helper.getMin());
                    if (helper.isMinExclusive()) {
                        args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM, (Object)true);
                    }
                }
                if (helper.getMax() != null) {
                    args.put(PropertyBuilder.PropertyId.MAXIMUM, (Object)helper.getMax());
                    if (helper.isMaxExclusive()) {
                        args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM, (Object)true);
                    }
                }
                if (helper.getMinLength() != null) {
                    args.put(PropertyBuilder.PropertyId.MIN_LENGTH, (Object)helper.getMinLength());
                }
                if (helper.getMaxLength() != null) {
                    args.put(PropertyBuilder.PropertyId.MAX_LENGTH, (Object)helper.getMaxLength());
                }
                if (helper.getPattern() != null) {
                    args.put(PropertyBuilder.PropertyId.PATTERN, (Object)helper.getPattern());
                }
                if (allowableValues != null) {
                    args.putAll(allowableValues.asPropertyArguments());
                }
                PropertyBuilder.merge((Property)p.getItems(), args);
            } else {
                if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
                    p.setDefaultValue(defaultValue);
                }
                if (allowableValues != null) {
                    ParameterProcessor.processAllowedValues(allowableValues, p);
                }
            }
        } else {
            Property property;
            BodyParameter bp = new BodyParameter();
            if (helper.getApiParam() != null) {
                String value;
                String mediaType;
                Example example;
                ParamWrapper<ApiParam> apiParam;
                ParamWrapper<?> pw = helper.getApiParam();
                if (pw instanceof ApiParamWrapper) {
                    apiParam = (ApiParamWrapper)pw;
                    example = ((ApiParamWrapper)apiParam).getExamples();
                    if (example != null && example.value() != null) {
                        for (ExampleProperty ex : example.value()) {
                            mediaType = ex.mediaType();
                            value = ex.value();
                            if (mediaType.isEmpty() || value.isEmpty()) continue;
                            bp.example(mediaType.trim(), value.trim());
                        }
                    }
                } else if (pw instanceof ApiImplicitParamWrapper && (example = ((ApiImplicitParamWrapper)(apiParam = (ApiImplicitParamWrapper)pw)).getExamples()) != null && example.value() != null) {
                    for (ExampleProperty ex : example.value()) {
                        mediaType = ex.mediaType();
                        value = ex.value();
                        if (mediaType.isEmpty() || value.isEmpty()) continue;
                        bp.example(mediaType.trim(), value.trim());
                    }
                }
            }
            bp.setRequired(param.isRequired());
            bp.setName(StringUtils.isNotEmpty((CharSequence)param.getName()) ? param.getName() : "body");
            if (StringUtils.isNotEmpty((CharSequence)param.getDescription())) {
                bp.setDescription(param.getDescription());
            }
            if (StringUtils.isNotEmpty((CharSequence)param.getAccess())) {
                bp.setAccess(param.getAccess());
            }
            if ((property = ModelConverters.getInstance().readAsProperty(type)) != null) {
                EnumMap<PropertyBuilder.PropertyId, String> args = new EnumMap<PropertyBuilder.PropertyId, String>(PropertyBuilder.PropertyId.class);
                if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
                    args.put(PropertyBuilder.PropertyId.DEFAULT, defaultValue);
                }
                bp.setSchema(PropertyBuilder.toModel((Property)PropertyBuilder.merge((Property)property, args)));
                for (Map.Entry<String, Model> entry : ModelConverters.getInstance().readAll(type).entrySet()) {
                    swagger.addDefinition(entry.getKey(), entry.getValue());
                }
            }
            parameter = bp;
        }
        return parameter;
    }

    private static void processAllowedValues(AllowableValues allowableValues, AbstractSerializableParameter<?> p) {
        if (allowableValues == null) {
            return;
        }
        Map<PropertyBuilder.PropertyId, Object> args = allowableValues.asPropertyArguments();
        if (args.containsKey(PropertyBuilder.PropertyId.ENUM)) {
            p.setEnum((List)args.get(PropertyBuilder.PropertyId.ENUM));
        } else {
            if (args.containsKey(PropertyBuilder.PropertyId.MINIMUM)) {
                p.setMinimum((BigDecimal)args.get(PropertyBuilder.PropertyId.MINIMUM));
            }
            if (args.containsKey(PropertyBuilder.PropertyId.MAXIMUM)) {
                p.setMaximum((BigDecimal)args.get(PropertyBuilder.PropertyId.MAXIMUM));
            }
            if (args.containsKey(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM)) {
                p.setExclusiveMinimum((Boolean)args.get(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM) != false ? Boolean.valueOf(true) : null);
            }
            if (args.containsKey(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM)) {
                p.setExclusiveMaximum((Boolean)args.get(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM) != false ? Boolean.valueOf(true) : null);
            }
        }
    }

    private static void processJsr303Annotations(AnnotationsHelper helper, AbstractSerializableParameter<?> p) {
        if (helper == null) {
            return;
        }
        if (helper.getMin() != null) {
            p.setMinimum(helper.getMin());
        }
        if (helper.getMax() != null) {
            p.setMaximum(helper.getMax());
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class ApiImplicitParamWrapper
    implements ParamWrapper<ApiImplicitParam> {
        private final ApiImplicitParam apiParam;
        static final long serialVersionUID = -2788456275036409107L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ApiImplicitParamWrapper(ApiImplicitParam apiParam) {
            this.apiParam = apiParam;
        }

        @Override
        public String getName() {
            return this.apiParam.name();
        }

        @Override
        public String getDescription() {
            return this.apiParam.value();
        }

        @Override
        public String getDefaultValue() {
            return this.apiParam.defaultValue();
        }

        @Override
        public String getAllowableValues() {
            return this.apiParam.allowableValues();
        }

        @Override
        public boolean isRequired() {
            return this.apiParam.required();
        }

        @Override
        public String getAccess() {
            return this.apiParam.access();
        }

        @Override
        public boolean isAllowMultiple() {
            return this.apiParam.allowMultiple();
        }

        @Override
        public String getDataType() {
            return this.apiParam.dataType();
        }

        @Override
        public String getParamType() {
            return this.apiParam.paramType();
        }

        @Override
        public ApiImplicitParam getAnnotation() {
            return this.apiParam;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public String getExample() {
            return this.apiParam.example();
        }

        public Example getExamples() {
            return this.apiParam.examples();
        }

        @Override
        public String getType() {
            return this.apiParam.type();
        }

        @Override
        public String getFormat() {
            return this.apiParam.format();
        }

        @Override
        public boolean getReadOnly() {
            return this.apiParam.readOnly();
        }

        @Override
        public boolean getAllowEmptyValue() {
            return this.apiParam.allowEmptyValue();
        }

        @Override
        public String getCollectionFormat() {
            return this.apiParam.collectionFormat();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"v2.io.swagger.util.ParameterProcessor$ApiImplicitParamWrapper", ApiImplicitParamWrapper.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class ApiParamWrapper
    implements ParamWrapper<ApiParam> {
        private final ApiParam apiParam;
        static final long serialVersionUID = 1754595238156096974L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ApiParamWrapper(ApiParam apiParam) {
            this.apiParam = apiParam;
        }

        @Override
        public String getName() {
            return this.apiParam.name();
        }

        @Override
        public String getDescription() {
            return this.apiParam.value();
        }

        @Override
        public String getDefaultValue() {
            return this.apiParam.defaultValue();
        }

        @Override
        public String getAllowableValues() {
            return this.apiParam.allowableValues();
        }

        @Override
        public boolean isRequired() {
            return this.apiParam.required();
        }

        @Override
        public String getAccess() {
            return this.apiParam.access();
        }

        @Override
        public boolean isAllowMultiple() {
            return this.apiParam.allowMultiple();
        }

        @Override
        public String getDataType() {
            return null;
        }

        @Override
        public String getParamType() {
            return null;
        }

        @Override
        public ApiParam getAnnotation() {
            return this.apiParam;
        }

        @Override
        public boolean isHidden() {
            return this.apiParam.hidden();
        }

        @Override
        public String getExample() {
            return this.apiParam.example();
        }

        public Example getExamples() {
            return this.apiParam.examples();
        }

        @Override
        public String getType() {
            return this.apiParam.type();
        }

        @Override
        public String getFormat() {
            return this.apiParam.format();
        }

        @Override
        public boolean getReadOnly() {
            return this.apiParam.readOnly();
        }

        @Override
        public boolean getAllowEmptyValue() {
            return this.apiParam.allowEmptyValue();
        }

        @Override
        public String getCollectionFormat() {
            return this.apiParam.collectionFormat();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"v2.io.swagger.util.ParameterProcessor$ApiParamWrapper", ApiParamWrapper.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class AnnotationsHelper {
        private static final ApiParam DEFAULT_API_PARAM;
        private boolean context;
        private ParamWrapper<?> apiParam = new ApiParamWrapper(DEFAULT_API_PARAM);
        private final String type;
        private final String format;
        private final String defaultValue;
        private Integer minItems;
        private Integer maxItems;
        private Boolean required;
        private BigDecimal min;
        private final boolean minExclusive = false;
        private BigDecimal max;
        private final boolean maxExclusive = false;
        private Integer minLength;
        private Integer maxLength;
        private String pattern;
        private final Boolean allowEmptyValue;
        private final String collectionFormat;
        static final long serialVersionUID = -5062497580160723515L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        /*
         * WARNING - void declaration
         */
        public AnnotationsHelper(List<Annotation> annotations, Type _type) {
            String rsDefault = null;
            for (Annotation item : annotations) {
                if ("javax.ws.rs.core.Context".equals(item.annotationType().getName())) {
                    this.context = true;
                    continue;
                }
                if (item instanceof ApiParam) {
                    this.apiParam = new ApiParamWrapper((ApiParam)item);
                    continue;
                }
                if (item instanceof ApiImplicitParam) {
                    this.apiParam = new ApiImplicitParamWrapper((ApiImplicitParam)item);
                    continue;
                }
                if (!"javax.ws.rs.DefaultValue".equals(item.annotationType().getName())) continue;
                try {
                    rsDefault = (String)item.annotationType().getMethod("value", new Class[0]).invoke((Object)item, new Object[0]);
                }
                catch (Exception exception) {
                    void ex;
                    FFDCFilter.processException((Throwable)exception, (String)"v2.io.swagger.util.ParameterProcessor$AnnotationsHelper", (String)"391", (Object)this, (Object[])new Object[]{annotations, _type});
                    Tr.debug((TraceComponent)tc, (String)"Invocation of value method failed", (Object[])new Object[]{ex});
                }
            }
            this.defaultValue = StringUtils.isNotEmpty((CharSequence)this.apiParam.getDefaultValue()) ? this.apiParam.getDefaultValue() : rsDefault;
            this.type = StringUtils.isNotEmpty((CharSequence)this.apiParam.getType()) ? this.apiParam.getType() : null;
            this.format = StringUtils.isNotEmpty((CharSequence)this.apiParam.getFormat()) ? this.apiParam.getFormat() : null;
            this.allowEmptyValue = this.apiParam.isAllowMultiple() ? Boolean.valueOf(true) : null;
            this.collectionFormat = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.apiParam.getCollectionFormat()}) ? this.apiParam.getCollectionFormat() : null;
        }

        private boolean isAssignableToNumber(Class<?> clazz) {
            return Number.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz);
        }

        private static ApiParam getDefaultApiParam(@ApiParam String annotationHolder) {
            for (Method method : AnnotationsHelper.class.getDeclaredMethods()) {
                if (!"getDefaultApiParam".equals(method.getName())) continue;
                return (ApiParam)method.getParameterAnnotations()[0][0];
            }
            throw new IllegalStateException("Failed to locate default @ApiParam");
        }

        public boolean isContext() {
            return this.context;
        }

        public ParamWrapper<?> getApiParam() {
            return this.apiParam;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public Integer getMinItems() {
            return this.minItems;
        }

        public Integer getMaxItems() {
            return this.maxItems;
        }

        public Boolean isRequired() {
            return this.required;
        }

        public BigDecimal getMax() {
            return this.max;
        }

        public boolean isMaxExclusive() {
            return false;
        }

        public BigDecimal getMin() {
            return this.min;
        }

        public String getType() {
            return this.type;
        }

        public String getFormat() {
            return this.format;
        }

        public boolean isMinExclusive() {
            return false;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public String getPattern() {
            return this.pattern;
        }

        public Boolean getAllowEmptyValue() {
            return this.allowEmptyValue;
        }

        public String getCollectionFormat() {
            return this.collectionFormat;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"v2.io.swagger.util.ParameterProcessor$AnnotationsHelper", AnnotationsHelper.class, null, null);
            DEFAULT_API_PARAM = AnnotationsHelper.getDefaultApiParam(null);
        }
    }

    public static interface ParamWrapper<T extends Annotation> {
        public String getName();

        public String getDescription();

        public String getDefaultValue();

        public String getAllowableValues();

        public boolean isRequired();

        public String getAccess();

        public boolean isAllowMultiple();

        public String getDataType();

        public String getParamType();

        public T getAnnotation();

        public boolean isHidden();

        public String getExample();

        public String getType();

        public String getFormat();

        public boolean getReadOnly();

        public boolean getAllowEmptyValue();

        public String getCollectionFormat();
    }
}

