/*
 * Decompiled with CFR 0.152.
 */
package v2.io.swagger.util;

import com.fasterxml.jackson.databind.type.TypeFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import v2.io.swagger.models.properties.BaseIntegerProperty;
import v2.io.swagger.models.properties.BinaryProperty;
import v2.io.swagger.models.properties.BooleanProperty;
import v2.io.swagger.models.properties.ByteArrayProperty;
import v2.io.swagger.models.properties.DateProperty;
import v2.io.swagger.models.properties.DateTimeProperty;
import v2.io.swagger.models.properties.DecimalProperty;
import v2.io.swagger.models.properties.DoubleProperty;
import v2.io.swagger.models.properties.FileProperty;
import v2.io.swagger.models.properties.FloatProperty;
import v2.io.swagger.models.properties.IntegerProperty;
import v2.io.swagger.models.properties.LongProperty;
import v2.io.swagger.models.properties.ObjectProperty;
import v2.io.swagger.models.properties.Property;
import v2.io.swagger.models.properties.StringProperty;
import v2.io.swagger.models.properties.UUIDProperty;

public enum PrimitiveType {
    BOOLEAN((Class)Boolean.class, "boolean"){

        public BooleanProperty createProperty() {
            return new BooleanProperty();
        }
    }
    ,
    STRING((Class)String.class, "string"){

        public StringProperty createProperty() {
            return new StringProperty();
        }
    }
    ,
    BYTE((Class)Byte.class, "byte"){

        public ByteArrayProperty createProperty() {
            return new ByteArrayProperty();
        }
    }
    ,
    BINARY((Class)Byte.class, "binary"){

        public BinaryProperty createProperty() {
            return new BinaryProperty();
        }
    }
    ,
    URI((Class)URI.class){

        public StringProperty createProperty() {
            return new StringProperty(StringProperty.Format.URI);
        }
    }
    ,
    URL((Class)URL.class){

        public StringProperty createProperty() {
            return new StringProperty(StringProperty.Format.URL);
        }
    }
    ,
    UUID((Class)UUID.class){

        public UUIDProperty createProperty() {
            return new UUIDProperty();
        }
    }
    ,
    INT((Class)Integer.class, "integer"){

        public IntegerProperty createProperty() {
            return new IntegerProperty();
        }
    }
    ,
    LONG((Class)Long.class, "long"){

        public LongProperty createProperty() {
            return new LongProperty();
        }
    }
    ,
    FLOAT((Class)Float.class, "float"){

        public FloatProperty createProperty() {
            return new FloatProperty();
        }
    }
    ,
    DOUBLE((Class)Double.class, "double"){

        public DoubleProperty createProperty() {
            return new DoubleProperty();
        }
    }
    ,
    INTEGER((Class)BigInteger.class){

        public BaseIntegerProperty createProperty() {
            return new BaseIntegerProperty();
        }
    }
    ,
    DECIMAL((Class)BigDecimal.class, "number"){

        public DecimalProperty createProperty() {
            return new DecimalProperty();
        }
    }
    ,
    DATE((Class)DateStub.class, "date"){

        public DateProperty createProperty() {
            return new DateProperty();
        }
    }
    ,
    DATE_TIME((Class)Date.class, "dateTime"){

        public DateTimeProperty createProperty() {
            return new DateTimeProperty();
        }
    }
    ,
    FILE((Class)File.class, "file"){

        public FileProperty createProperty() {
            return new FileProperty();
        }
    }
    ,
    OBJECT((Class)Object.class){

        public ObjectProperty createProperty() {
            return new ObjectProperty();
        }
    };

    private static final Map<Class<?>, PrimitiveType> KEY_CLASSES;
    private static final Map<Class<?>, PrimitiveType> BASE_CLASSES;
    private static final Map<String, PrimitiveType> EXTERNAL_CLASSES;
    private static final Map<String, PrimitiveType> NAMES;
    private final Class<?> keyClass;
    private final String commonName;

    private PrimitiveType(Class<?> keyClass) {
        this(keyClass, null);
    }

    private PrimitiveType(Class<?> keyClass, String commonName) {
        this.keyClass = keyClass;
        this.commonName = commonName;
    }

    public static PrimitiveType fromType(Type type) {
        Class raw = TypeFactory.defaultInstance().constructType(type).getRawClass();
        PrimitiveType key = KEY_CLASSES.get(raw);
        if (key != null) {
            return key;
        }
        PrimitiveType external = EXTERNAL_CLASSES.get(raw.getName());
        if (external != null) {
            return external;
        }
        for (Map.Entry<Class<?>, PrimitiveType> entry : BASE_CLASSES.entrySet()) {
            if (!entry.getKey().isAssignableFrom(raw)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static PrimitiveType fromName(String name) {
        if (name == null) {
            return null;
        }
        PrimitiveType fromName = NAMES.get(name);
        if (fromName == null) {
            fromName = EXTERNAL_CLASSES.get(name);
        }
        return fromName;
    }

    public static Property createProperty(Type type) {
        PrimitiveType item = PrimitiveType.fromType(type);
        return item == null ? null : item.createProperty();
    }

    public static Property createProperty(String name) {
        PrimitiveType item = PrimitiveType.fromName(name);
        return item == null ? null : item.createProperty();
    }

    public static String getCommonName(Type type) {
        PrimitiveType item = PrimitiveType.fromType(type);
        return item == null ? null : item.getCommonName();
    }

    public Class<?> getKeyClass() {
        return this.keyClass;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public abstract Property createProperty();

    private static <K> void addKeys(Map<K, PrimitiveType> map, PrimitiveType type, K ... keys) {
        for (K key : keys) {
            map.put(key, type);
        }
    }

    static {
        HashMap keyClasses = new HashMap();
        PrimitiveType.addKeys(keyClasses, BOOLEAN, Boolean.class, Boolean.TYPE);
        PrimitiveType.addKeys(keyClasses, STRING, String.class, Character.class, Character.TYPE);
        PrimitiveType.addKeys(keyClasses, BYTE, Byte.class, Byte.TYPE);
        PrimitiveType.addKeys(keyClasses, URL, URL.class);
        PrimitiveType.addKeys(keyClasses, URI, URI.class);
        PrimitiveType.addKeys(keyClasses, UUID, UUID.class);
        PrimitiveType.addKeys(keyClasses, INT, Integer.class, Integer.TYPE, Short.class, Short.TYPE);
        PrimitiveType.addKeys(keyClasses, LONG, Long.class, Long.TYPE);
        PrimitiveType.addKeys(keyClasses, FLOAT, Float.class, Float.TYPE);
        PrimitiveType.addKeys(keyClasses, DOUBLE, Double.class, Double.TYPE);
        PrimitiveType.addKeys(keyClasses, INTEGER, BigInteger.class);
        PrimitiveType.addKeys(keyClasses, DECIMAL, BigDecimal.class);
        PrimitiveType.addKeys(keyClasses, DATE, DateStub.class);
        PrimitiveType.addKeys(keyClasses, DATE_TIME, Date.class);
        PrimitiveType.addKeys(keyClasses, FILE, File.class);
        PrimitiveType.addKeys(keyClasses, OBJECT, Object.class);
        KEY_CLASSES = Collections.unmodifiableMap(keyClasses);
        HashMap baseClasses = new HashMap();
        PrimitiveType.addKeys(baseClasses, DATE_TIME, Date.class, Calendar.class);
        BASE_CLASSES = Collections.unmodifiableMap(baseClasses);
        HashMap externalClasses = new HashMap();
        PrimitiveType.addKeys(externalClasses, DATE, "org.joda.time.LocalDate", "java.time.LocalDate");
        PrimitiveType.addKeys(externalClasses, DATE_TIME, "org.joda.time.DateTime", "org.joda.time.ReadableDateTime", "javax.xml.datatype.XMLGregorianCalendar", "java.time.LocalDateTime", "java.time.ZonedDateTime", "java.time.OffsetDateTime");
        PrimitiveType.addKeys(externalClasses, LONG, "java.time.Instant");
        EXTERNAL_CLASSES = Collections.unmodifiableMap(externalClasses);
        TreeMap names = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (PrimitiveType item : PrimitiveType.values()) {
            String name = item.getCommonName();
            if (name == null) continue;
            PrimitiveType.addKeys(names, item, name);
        }
        PrimitiveType.addKeys(names, INT, "int");
        PrimitiveType.addKeys(names, OBJECT, "object");
        NAMES = Collections.unmodifiableMap(names);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class DateStub {
        static final long serialVersionUID = 3636856651956671883L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private DateStub() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"v2.io.swagger.util.PrimitiveType$DateStub", DateStub.class, null, null);
        }
    }
}

