/*
 * Decompiled with CFR 0.152.
 */
package v2.io.swagger.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import v2.io.swagger.models.ExternalDocs;
import v2.io.swagger.models.Response;
import v2.io.swagger.models.Responses;
import v2.io.swagger.models.Scheme;
import v2.io.swagger.models.SecurityRequirement;
import v2.io.swagger.models.parameters.Parameter;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Operation {
    private Map<String, Object> vendorExtensions = new LinkedHashMap<String, Object>();
    private List<String> tags;
    private String summary;
    private String description;
    private String operationId;
    private List<Scheme> schemes;
    private List<String> consumes;
    private List<String> produces;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private Responses responses;
    private List<Map<String, List<String>>> security;
    private ExternalDocs externalDocs;
    private Boolean deprecated;
    private final Set<String> references = new HashSet<String>();
    static final long serialVersionUID = 5716393799977687528L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Operation summary(String summary) {
        this.setSummary(summary);
        return this;
    }

    public Operation description(String description) {
        this.setDescription(description);
        return this;
    }

    public Operation operationId(String operationId) {
        this.setOperationId(operationId);
        return this;
    }

    public Operation schemes(List<Scheme> schemes) {
        this.setSchemes(schemes);
        return this;
    }

    public Operation scheme(Scheme scheme) {
        this.addScheme(scheme);
        return this;
    }

    public Operation consumes(List<String> consumes) {
        this.setConsumes(consumes);
        return this;
    }

    public Operation consumes(String consumes) {
        this.addConsumes(consumes);
        return this;
    }

    public Operation produces(List<String> produces) {
        this.setProduces(produces);
        return this;
    }

    public Operation produces(String produces) {
        this.addProduces(produces);
        return this;
    }

    public Operation security(SecurityRequirement security) {
        this.addSecurity(security.getName(), security.getScopes());
        return this;
    }

    public Operation parameter(Parameter parameter) {
        this.addParameter(parameter);
        return this;
    }

    public Operation response(int key, Response response) {
        this.addResponse(String.valueOf(key), response);
        return this;
    }

    public Operation defaultResponse(Response response) {
        this.addResponse("default", response);
        return this;
    }

    public Operation tags(List<String> tags) {
        this.setTags(tags);
        return this;
    }

    public Operation tag(String tag) {
        this.addTag(tag);
        return this;
    }

    public Operation externalDocs(ExternalDocs externalDocs) {
        this.setExternalDocs(externalDocs);
        return this;
    }

    public Operation deprecated(Boolean deprecated) {
        this.setDeprecated(deprecated);
        return this;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void addTag(String tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tag);
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public List<Scheme> getSchemes() {
        return this.schemes;
    }

    public void setSchemes(List<Scheme> schemes) {
        this.schemes = schemes;
    }

    public void addScheme(Scheme scheme) {
        if (this.schemes == null) {
            this.schemes = new ArrayList<Scheme>();
        }
        if (!this.schemes.contains((Object)scheme)) {
            this.schemes.add(scheme);
        }
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void addConsumes(String consumes) {
        if (this.consumes == null) {
            this.consumes = new ArrayList<String>();
        }
        this.consumes.add(consumes);
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void addProduces(String produces) {
        if (this.produces == null) {
            this.produces = new ArrayList<String>();
        }
        this.produces.add(produces);
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        this.parameters.add(parameter);
    }

    @JsonIgnore
    public Map<String, Response> getResponses() {
        if (this.responses == null) {
            return null;
        }
        return this.responses.getResponses();
    }

    @JsonIgnore
    public void setResponses(Map<String, Response> responses) {
        if (this.responses == null) {
            this.responses = new Responses();
        }
        this.responses.setResponses(responses);
    }

    @JsonProperty(value="responses")
    public Responses getResponsesObject() {
        return this.responses;
    }

    @JsonProperty(value="responses")
    public void setResponsesObject(Responses responses) {
        this.responses = responses;
    }

    public void addResponse(String key, Response response) {
        if (this.responses == null) {
            this.responses = new Responses();
        }
        this.responses.addResponse(key, response);
    }

    public List<Map<String, List<String>>> getSecurity() {
        return this.security;
    }

    public void setSecurity(List<Map<String, List<String>>> security) {
        this.security = security;
    }

    public void addSecurity(String name, List<String> scopes) {
        if (this.security == null) {
            this.security = new ArrayList<Map<String, List<String>>>();
        }
        LinkedHashMap<String, List<String>> req = new LinkedHashMap<String, List<String>>();
        if (scopes == null) {
            scopes = new ArrayList<String>();
        }
        req.put(name, scopes);
        this.security.add(req);
    }

    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocs value) {
        this.externalDocs = value;
    }

    public Boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean value) {
        this.deprecated = value == null || value.equals(Boolean.FALSE) ? null : value;
    }

    @JsonAnyGetter
    public Map<String, Object> getVendorExtensions() {
        return this.vendorExtensions;
    }

    @JsonAnySetter
    public void setVendorExtension(String name, Object value) {
        if (name.startsWith("x-")) {
            this.vendorExtensions.put(name, value);
        }
    }

    public void setVendorExtensions(Map<String, Object> vendorExtensions) {
        if (vendorExtensions != null) {
            this.vendorExtensions = vendorExtensions;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.consumes == null ? 0 : this.consumes.hashCode());
        result = 31 * result + (this.deprecated == null ? 0 : this.deprecated.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.externalDocs == null ? 0 : this.externalDocs.hashCode());
        result = 31 * result + (this.operationId == null ? 0 : this.operationId.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.produces == null ? 0 : this.produces.hashCode());
        result = 31 * result + (this.references == null ? 0 : this.references.hashCode());
        result = 31 * result + (this.responses == null ? 0 : this.responses.hashCode());
        result = 31 * result + (this.schemes == null ? 0 : this.schemes.hashCode());
        result = 31 * result + (this.security == null ? 0 : this.security.hashCode());
        result = 31 * result + (this.summary == null ? 0 : this.summary.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (this.vendorExtensions == null ? 0 : this.vendorExtensions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Operation other = (Operation)obj;
        if (this.consumes == null ? other.consumes != null : !this.consumes.equals(other.consumes)) {
            return false;
        }
        if (this.deprecated == null ? other.deprecated != null : !this.deprecated.equals(other.deprecated)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.externalDocs == null ? other.externalDocs != null : !this.externalDocs.equals(other.externalDocs)) {
            return false;
        }
        if (this.operationId == null ? other.operationId != null : !this.operationId.equals(other.operationId)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        if (this.produces == null ? other.produces != null : !this.produces.equals(other.produces)) {
            return false;
        }
        if (this.references == null ? other.references != null : !this.references.equals(other.references)) {
            return false;
        }
        if (this.responses == null ? other.responses != null : !this.responses.equals(other.responses)) {
            return false;
        }
        if (this.schemes == null ? other.schemes != null : !this.schemes.equals(other.schemes)) {
            return false;
        }
        if (this.security == null ? other.security != null : !this.security.equals(other.security)) {
            return false;
        }
        if (this.summary == null ? other.summary != null : !this.summary.equals(other.summary)) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        return !(this.vendorExtensions == null ? other.vendorExtensions != null : !this.vendorExtensions.equals(other.vendorExtensions));
    }

    public Operation vendorExtensions(Map<String, Object> vendorExtensions) {
        this.vendorExtensions.putAll(vendorExtensions);
        return this;
    }

    public String toString() {
        return super.toString() + "[" + this.operationId + "]";
    }

    public void addReference(String ref) {
        this.references.add(ref);
    }

    public void addReferences(Set<String> refs) {
        this.references.addAll(refs);
    }

    public Set<String> retrieveReferences() {
        return this.references;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"v2.io.swagger.models.Operation", Operation.class, null, null);
    }
}

