/*
 * Decompiled with CFR 0.152.
 */
package v2.io.swagger.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import v2.io.swagger.models.properties.Property;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Response {
    private String description;
    private Property schema;
    private Map<String, Object> examples;
    private Map<String, Property> headers;
    private Map<String, Object> vendorExtensions = new LinkedHashMap<String, Object>();
    private final Set<String> references = new HashSet<String>();
    private boolean processed = false;
    static final long serialVersionUID = 5720766596782559450L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Response schema(Property property) {
        this.setSchema(property);
        return this;
    }

    public Response description(String description) {
        this.setDescription(description);
        return this;
    }

    public Response example(String type, Object example) {
        if (this.examples == null) {
            this.examples = new LinkedHashMap<String, Object>();
        }
        this.examples.put(type, example);
        return this;
    }

    public Response header(String name, Property property) {
        this.addHeader(name, property);
        return this;
    }

    public Response headers(Map<String, Property> headers) {
        this.headers = headers;
        return this;
    }

    public Response vendorExtension(String key, Object obj) {
        this.setVendorExtension(key, obj);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Property getSchema() {
        return this.schema;
    }

    public void setSchema(Property schema) {
        this.schema = schema;
    }

    public Map<String, Object> getExamples() {
        return this.examples;
    }

    public void setExamples(Map<String, Object> examples) {
        this.examples = examples;
    }

    public Map<String, Property> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Property> headers) {
        this.headers = headers;
    }

    public void addHeader(String key, Property property) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, Property>();
        }
        this.headers.put(key, property);
    }

    @JsonAnyGetter
    public Map<String, Object> getVendorExtensions() {
        return this.vendorExtensions;
    }

    @JsonAnySetter
    public void setVendorExtension(String name, Object value) {
        if (name.startsWith("x-")) {
            this.vendorExtensions.put(name, value);
        }
    }

    public void setVendorExtensions(Map<String, Object> vendorExtensions) {
        if (vendorExtensions != null) {
            this.vendorExtensions = vendorExtensions;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.examples == null ? 0 : this.examples.hashCode());
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (this.processed ? 1231 : 1237);
        result = 31 * result + (this.references == null ? 0 : this.references.hashCode());
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        result = 31 * result + (this.vendorExtensions == null ? 0 : this.vendorExtensions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Response other = (Response)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.examples == null ? other.examples != null : !this.examples.equals(other.examples)) {
            return false;
        }
        if (this.headers == null ? other.headers != null : !this.headers.equals(other.headers)) {
            return false;
        }
        if (this.processed != other.processed) {
            return false;
        }
        if (this.references == null ? other.references != null : !this.references.equals(other.references)) {
            return false;
        }
        if (this.schema == null ? other.schema != null : !this.schema.equals(other.schema)) {
            return false;
        }
        return !(this.vendorExtensions == null ? other.vendorExtensions != null : !this.vendorExtensions.equals(other.vendorExtensions));
    }

    public void addReference(String ref) {
        this.references.add(ref);
    }

    public void addReferences(Set<String> refs) {
        this.references.addAll(refs);
    }

    public Set<String> retrieveReferences() {
        return this.references;
    }

    @JsonIgnore
    public boolean isProcessed() {
        return this.processed;
    }

    public void markAsProcessed() {
        this.processed = true;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"v2.io.swagger.models.Response", Response.class, null, null);
    }
}

