/*
 * Decompiled with CFR 0.152.
 */
package v2.io.swagger.models.auth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;
import v2.io.swagger.models.auth.AbstractSecuritySchemeDefinition;
import v2.io.swagger.models.auth.Scopes;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OAuth2Definition
extends AbstractSecuritySchemeDefinition {
    private String type = "oauth2";
    private String authorizationUrl;
    private String tokenUrl;
    private String flow;
    private Scopes scopes;
    static final long serialVersionUID = 5924517404576655812L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public OAuth2Definition implicit(String authorizationUrl) {
        this.setAuthorizationUrl(authorizationUrl);
        this.setFlow("implicit");
        return this;
    }

    public OAuth2Definition password(String tokenUrl) {
        this.setTokenUrl(tokenUrl);
        this.setFlow("password");
        return this;
    }

    public OAuth2Definition application(String tokenUrl) {
        this.setTokenUrl(tokenUrl);
        this.setFlow("application");
        return this;
    }

    public OAuth2Definition accessCode(String authorizationUrl, String tokenUrl) {
        this.setTokenUrl(tokenUrl);
        this.setAuthorizationUrl(authorizationUrl);
        this.setFlow("accessCode");
        return this;
    }

    public OAuth2Definition scope(String name, String description) {
        this.addScope(name, description);
        return this;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public String getFlow() {
        return this.flow;
    }

    public void setFlow(String flow) {
        this.flow = flow;
    }

    @JsonIgnore
    public Map<String, String> getScopes() {
        if (this.scopes == null) {
            return null;
        }
        return this.scopes.getScopes();
    }

    @JsonIgnore
    public void setScopes(Map<String, String> scopes) {
        if (this.scopes == null) {
            this.scopes = new Scopes();
        }
        this.scopes.setScopes(scopes);
    }

    @JsonProperty(value="scopes")
    public Scopes getScopesObject() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    public void setScopesObject(Scopes scopes) {
        this.scopes = scopes;
    }

    public void addScope(String name, String description) {
        if (this.scopes == null) {
            this.scopes = new Scopes();
        }
        this.scopes.addScope(name, description);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.authorizationUrl == null ? 0 : this.authorizationUrl.hashCode());
        result = 31 * result + (this.flow == null ? 0 : this.flow.hashCode());
        result = 31 * result + (this.scopes == null ? 0 : this.scopes.hashCode());
        result = 31 * result + (this.tokenUrl == null ? 0 : this.tokenUrl.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuth2Definition other = (OAuth2Definition)obj;
        if (this.authorizationUrl == null ? other.authorizationUrl != null : !this.authorizationUrl.equals(other.authorizationUrl)) {
            return false;
        }
        if (this.flow == null ? other.flow != null : !this.flow.equals(other.flow)) {
            return false;
        }
        if (this.scopes == null ? other.scopes != null : !this.scopes.equals(other.scopes)) {
            return false;
        }
        if (this.tokenUrl == null ? other.tokenUrl != null : !this.tokenUrl.equals(other.tokenUrl)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"v2.io.swagger.models.auth.OAuth2Definition", OAuth2Definition.class, null, null);
    }
}

