/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.server.component;

import com.ibm.websphere.jaxrs.server.IBMRestServlet;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.api.EndpointPublisher;
import com.ibm.ws.jaxrs20.api.JaxRsFactoryBeanCustomizer;
import com.ibm.ws.jaxrs20.api.JaxRsProviderFactoryService;
import com.ibm.ws.jaxrs20.endpoint.JaxRsPublisherContext;
import com.ibm.ws.jaxrs20.endpoint.JaxRsWebEndpoint;
import com.ibm.ws.jaxrs20.metadata.EndpointInfo;
import com.ibm.ws.jaxrs20.server.JaxRsWebEndpointImpl;
import com.ibm.ws.jaxrs20.server.deprecated.JaxRsExtensionProcessor;
import com.ibm.ws.jaxrs20.server.internal.JaxRsServerConstants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppNameSpaceCollaborator;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.cxf.feature.Feature;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="WebEndpointPublisher", immediate=true, property={"service.vendor=IBM"}, configurationPolicy=ConfigurationPolicy.IGNORE)
public class JaxRsWebEndpointPublisher
implements EndpointPublisher {
    private static final TraceComponent tc = Tr.register(JaxRsWebEndpointPublisher.class, (String)"JaxRsServer", (String)"com.ibm.ws.jaxrs20.server.internal.resources.JaxRsServerMessages");
    private final AtomicServiceReference<JaxRsProviderFactoryService> jaxRsProviderFactoryServiceSR = new AtomicServiceReference("jaxRsProviderFactoryService");
    private final Set<JaxRsFactoryBeanCustomizer> beanCustomizers = new HashSet<JaxRsFactoryBeanCustomizer>();
    private final List<Feature> features = new CopyOnWriteArrayList<Feature>();
    static final long serialVersionUID = 2958756402889755171L;

    @Reference(name="jaxRsFactoryBeanCustomizer", service=JaxRsFactoryBeanCustomizer.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void registerJaxRsFactoryBeanCustomizer(JaxRsFactoryBeanCustomizer beanCustomizer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"registerJaxRsFactoryBeanCustomizer", (Object[])new Object[0]);
        }
        this.beanCustomizers.add(beanCustomizer);
    }

    protected void unregisterJaxRsFactoryBeanCustomizer(JaxRsFactoryBeanCustomizer beanCustomizer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"registerJaxRsFactoryBeanCustomizer", (Object[])new Object[0]);
        }
        this.beanCustomizers.remove(beanCustomizer);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setFeature(Feature feature) {
        this.features.add(feature);
    }

    protected void unsetFeature(Feature feature) {
        this.features.remove(feature);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.jaxRsProviderFactoryServiceSR.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.jaxRsProviderFactoryServiceSR.deactivate(cc);
    }

    @Reference(name="jaxRsProviderFactoryService", service=JaxRsProviderFactoryService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setJaxRsProviderFactoryService(ServiceReference<JaxRsProviderFactoryService> ref) {
        this.jaxRsProviderFactoryServiceSR.setReference(ref);
    }

    protected void unsetJaxRsProviderFactoryService(ServiceReference<JaxRsProviderFactoryService> ref) {
        this.jaxRsProviderFactoryServiceSR.unsetReference(ref);
    }

    /*
     * WARNING - void declaration
     */
    public void publish(EndpointInfo endpointInfo, JaxRsPublisherContext context) {
        JaxRsWebEndpointImpl jaxRsWebEndpoint;
        block13: {
            WebAppConfig webAppConfig;
            IServletContext servletContext = (IServletContext)context.getAttribute("SERVLET_CONTEXT", IServletContext.class);
            if (servletContext == null) {
                throw new IllegalStateException("Unable to publish the endpoint to web container due to null web app instance");
            }
            context.setAttribute(JaxRsServerConstants.BEAN_CUSTOMIZER, this.beanCustomizers);
            jaxRsWebEndpoint = new JaxRsWebEndpointImpl(endpointInfo, context, new ArrayList<Feature>(this.features));
            Container moduleContainer = context.getPublisherModuleContainer();
            try {
                webAppConfig = (WebAppConfig)moduleContainer.adapt(WebAppConfig.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebEndpointPublisher", (String)"127", (Object)this, (Object[])new Object[]{endpointInfo, context});
                throw new IllegalStateException((Throwable)e);
            }
            IBMRestServlet restServlet = new IBMRestServlet((JaxRsWebEndpoint)jaxRsWebEndpoint, (IWebAppNameSpaceCollaborator)context.getAttribute("collaborator"), (JaxRsProviderFactoryService)this.jaxRsProviderFactoryServiceSR.getServiceWithException());
            IServletConfig sconfig = webAppConfig.getServletInfo(endpointInfo.getServletName());
            if (sconfig == null) {
                try {
                    JaxRsExtensionProcessor processor = new JaxRsExtensionProcessor(servletContext);
                    IServletConfig info = processor.createConfig(endpointInfo.getServletName());
                    info.setServletName(endpointInfo.getServletName());
                    info.setAsyncSupported(true);
                    info.setServlet((Servlet)restServlet);
                    info.setServletClass(((Object)((Object)restServlet)).getClass());
                    webAppConfig.addServletInfo(endpointInfo.getServletName(), info);
                    if (info.getMappings() != null && info.getMappings().size() != 0) break block13;
                    info.setServletContext((ServletContext)servletContext);
                    if (endpointInfo.getServletMappingUrl() != null) {
                        info.addMapping(new String[]{endpointInfo.getServletMappingUrl()});
                        break block13;
                    }
                    info.addMapping(new String[]{endpointInfo.getAppPath()});
                }
                catch (ServletException processor) {
                    FFDCFilter.processException((Throwable)processor, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebEndpointPublisher", (String)"165", (Object)this, (Object[])new Object[]{endpointInfo, context});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        void e;
                        Tr.debug((TraceComponent)tc, (String)"Servlet Exception when create a new servlet info:", (Object[])new Object[]{e});
                    }
                    break block13;
                }
            }
            sconfig.setAsyncSupported(true);
            sconfig.setServlet((Servlet)restServlet);
            sconfig.setServletClass(((Object)((Object)restServlet)).getClass());
            if (sconfig.getServletWrapper() != null) {
                sconfig.getServletWrapper().setTarget((Servlet)restServlet);
            }
            if (sconfig.getMappings() == null || sconfig.getMappings().size() == 0) {
                sconfig.setServletContext((ServletContext)servletContext);
                sconfig.addMapping(new String[]{endpointInfo.getAppPath()});
            }
        }
        if (endpointInfo.getServletMappingUrl() != null) {
            jaxRsWebEndpoint.setEndpointInfoAddress(endpointInfo.getServletMappingUrl());
        } else if (endpointInfo.getAppPath() != null) {
            jaxRsWebEndpoint.setEndpointInfoAddress(endpointInfo.getAppPath());
        }
    }

    public String getType() {
        return "WEB";
    }
}

