/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs.cdi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxrs.cdi.JAXRSCDIService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webbeans.services.CDIService;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import javax.enterprise.inject.spi.BeanManager;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JAXRSCDIServiceImpl
implements JAXRSCDIService {
    private static final TraceComponent tc = Tr.register(JAXRSCDIServiceImpl.class, (String)"JAXRS", (String)"com.ibm.ws.jaxrs.internal.resources.JAXRSMessages");
    private final AtomicServiceReference<CDIService> cdiServiceSR = new AtomicServiceReference("cdiService");
    static final long serialVersionUID = 1990918852953315947L;

    protected void activate(ComponentContext cc) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JAXRSCDIServiceImpl activated", (Object[])new Object[0]);
        }
        this.cdiServiceSR.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JAXRSCDIServiceImpl deactivated", (Object[])new Object[0]);
        }
        this.cdiServiceSR.deactivate(cc);
    }

    public void setCdiService(ServiceReference<CDIService> reference) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JAXRSCDIServiceImpl setCdiService", (Object[])new Object[0]);
        }
        this.cdiServiceSR.setReference(reference);
    }

    public void unsetCdiService(ServiceReference<CDIService> reference) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JAXRSCDIServiceImpl unsetCdiService", (Object[])new Object[0]);
        }
        this.cdiServiceSR.unsetReference(reference);
    }

    @ManualTrace
    public boolean isCDIEnabled(Container container) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isCDIEnabled", (Object[])new Object[0]);
        }
        boolean cdiEnabled = false;
        CDIService service = this.getCdiService();
        if (service != null) {
            cdiEnabled = service.isCDIEnabled(container);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isCDIEnabled", (Object)cdiEnabled);
        }
        return cdiEnabled;
    }

    public Object getBeanManager() {
        return this._getBeanManager();
    }

    @ManualTrace
    private BeanManager _getBeanManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBeanManager", (Object[])new Object[0]);
        }
        BeanManager beanMgr = null;
        CDIService service = this.getCdiService();
        if (service != null) {
            beanMgr = service.getCurrentBeanManager();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getBeanManager", (Object)beanMgr);
        }
        return beanMgr;
    }

    private CDIService getCdiService() {
        return (CDIService)this.cdiServiceSR.getService();
    }
}

