/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.app.deploy.EJBModuleInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.MetaDataSlotService;
import com.ibm.ws.container.service.metadata.extended.ModuleMetaDataExtender;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs.cdi.JAXRSCDIService;
import com.ibm.ws.jaxrs.exception.DeploymentException;
import com.ibm.ws.jaxrs.metadata.ArchiveInfoFactory;
import com.ibm.ws.jaxrs.metadata.JAXRSServerMetaData;
import com.ibm.ws.jaxrs.metadata.JAXRSServerMetaDataBuilder;
import com.ibm.ws.jaxrs.wc.ext.JAXRSWebExtFactory;
import com.ibm.ws.jaxrs.webcontainer.router.JAXRSWebContainerManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.jaxrs.JAXRSService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class JAXRSComponentImpl
implements JAXRSService,
ModuleMetaDataExtender {
    private static final TraceComponent tc = Tr.register(JAXRSComponentImpl.class, (String)"JAXRS", (String)"com.ibm.ws.jaxrs.internal.resources.JAXRSMessages");
    private static final ComponentMetaDataAccessorImpl cmdAccessor = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
    private MetaDataSlotService metaDataSlotService;
    private final AtomicServiceReference<ArchiveInfoFactory> archiveInfoFactorySR = new AtomicServiceReference("ArchiveInfoFactory");
    private final AtomicServiceReference<JAXRSCDIService> cdiServiceSR = new AtomicServiceReference("CdiService");
    private final AtomicServiceReference<JAXRSWebContainerManager> jaxrsWebContainerManagerRef = new AtomicServiceReference("JaxrsWebContainerManager");
    private MetaDataSlot slot;
    static final long serialVersionUID = -8495955536935833672L;

    @Activate
    protected void activate(ComponentContext cc) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JAXRSComponentImpl activated", (Object[])new Object[0]);
        }
        this.jaxrsWebContainerManagerRef.activate(cc);
        this.slot = this.metaDataSlotService.reserveMetaDataSlot(ModuleMetaData.class);
        this.archiveInfoFactorySR.activate(cc);
        this.cdiServiceSR.activate(cc);
        ((JAXRSWebExtFactory)cc.locateService("JAXRSWebExtFactory")).setJAXRSService(this);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JAXRSComponentImpl deactivated", (Object[])new Object[0]);
        }
        this.jaxrsWebContainerManagerRef.deactivate(cc);
        this.archiveInfoFactorySR.deactivate(cc);
        this.cdiServiceSR.deactivate(cc);
        ((JAXRSWebExtFactory)cc.locateService("JAXRSWebExtFactory")).setJAXRSService(null);
    }

    @Reference
    protected void setMetaDataSlotService(MetaDataSlotService metaDataSlotService) {
        this.metaDataSlotService = metaDataSlotService;
    }

    @Reference(service=ArchiveInfoFactory.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setArchiveInfoFactory(ServiceReference<ArchiveInfoFactory> reference) {
        this.archiveInfoFactorySR.setReference(reference);
    }

    protected void unsetArchiveInfoFactory(ServiceReference<ArchiveInfoFactory> reference) {
        this.archiveInfoFactorySR.unsetReference(reference);
    }

    @Reference(service=JAXRSCDIService.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setCdiService(ServiceReference<JAXRSCDIService> reference) {
        this.cdiServiceSR.setReference(reference);
    }

    protected void unsetCdiService(ServiceReference<JAXRSCDIService> reference) {
        this.cdiServiceSR.unsetReference(reference);
    }

    @Reference(service=JAXRSWebContainerManager.class)
    protected void setJaxrsWebContainerManager(ServiceReference<JAXRSWebContainerManager> reference) {
        this.jaxrsWebContainerManagerRef.setReference(reference);
    }

    protected void unsetJaxrsWebContainerManager(ServiceReference<JAXRSWebContainerManager> reference) {
        this.jaxrsWebContainerManagerRef.unsetReference(reference);
    }

    @Reference
    protected void setJAXRSWebExtFactory(JAXRSWebExtFactory extFactory) {
    }

    /*
     * Unable to fully structure code
     */
    @ManualTrace
    public ExtendedModuleInfo extendModuleMetaData(ExtendedModuleInfo moduleInfo) throws MetaDataException {
        if (JAXRSComponentImpl.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)JAXRSComponentImpl.tc, (String)"extendModuleMetaData", (Object[])new Object[0]);
        }
        webRouterModuleInfo = null;
        if (moduleInfo instanceof WebModuleInfo || moduleInfo instanceof EJBModuleInfo) {
            if (JAXRSComponentImpl.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)JAXRSComponentImpl.tc, (String)("Processing module " + moduleInfo.getMetaData().getJ2EEName()), (Object[])new Object[0]);
            }
            aiFactory = (ArchiveInfoFactory)this.archiveInfoFactorySR.getService();
            builder = new JAXRSServerMetaDataBuilder(aiFactory);
            try {
                smd = new JAXRSServerMetaData();
                builder.populateJAXRSMetaData((ModuleInfo)moduleInfo, smd);
                if (moduleInfo instanceof WebModuleInfo) {
                    cdiEnabled = false;
                    cdiService = (JAXRSCDIService)this.cdiServiceSR.getService();
                    if (cdiService != null) {
                        cdiEnabled = cdiService.isCDIEnabled(moduleInfo.getContainer());
                        if (cdiEnabled) {
                            smd.setJAXRSCDIService(cdiService);
                        }
                    } else if (JAXRSComponentImpl.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)JAXRSComponentImpl.tc, (String)"JAXRSCDIService is null; most likely the CDI feature is not enabled", (Object[])new Object[0]);
                    }
                    smd.setCDIEnabled(cdiEnabled);
                    if (JAXRSComponentImpl.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)JAXRSComponentImpl.tc, (String)("CDI enabled for module? " + smd.isCDIEnabled()), (Object[])new Object[0]);
                    }
                }
                moduleInfo.getMetaData().setMetaData(this.slot, (Object)smd);
                if (!(moduleInfo instanceof EJBModuleInfo) || smd.getEjbMetadata() == null || !smd.hasMetaDataForRouter()) ** GOTO lbl48
                jaxrsWebContainerManager = (JAXRSWebContainerManager)this.jaxrsWebContainerManagerRef.getService();
                if (jaxrsWebContainerManager != null) {
                    smd.setEjbModuleName(moduleInfo.getName());
                    webRouterModuleInfo = jaxrsWebContainerManager.createWebModuleInfo(moduleInfo);
                    webRouterModuleInfo.getMetaData().setMetaData(this.slot, (Object)smd);
                }
                if (!TraceComponent.isAnyTracingEnabled() || !JAXRSComponentImpl.tc.isDebugEnabled()) ** GOTO lbl48
                Tr.debug((TraceComponent)JAXRSComponentImpl.tc, (String)"No jaxrsWebContainerManager service is located, unable to publish the EJB endpoints to web container", (Object[])new Object[0]);
            }
            catch (DeploymentException smd) {
                FFDCFilter.processException((Throwable)smd, (String)"com.ibm.ws.jaxrs.component.JAXRSComponentImpl", (String)"218", (Object)this, (Object[])new Object[]{moduleInfo});
                throw new MetaDataException((Throwable)de);
            }
            catch (Exception de) {
                FFDCFilter.processException((Throwable)de, (String)"com.ibm.ws.jaxrs.component.JAXRSComponentImpl", (String)"222", (Object)this, (Object[])new Object[]{moduleInfo});
                FFDCFilter.processException((Throwable)e, (String)(JAXRSComponentImpl.class.getName() + ".stateChanged"), (String)"%C", (Object)this);
                Tr.error((TraceComponent)JAXRSComponentImpl.tc, (String)"metaDataFail00", (Object[])new Object[]{moduleInfo.getName(), e});
                msg = Tr.formatMessage((TraceComponent)JAXRSComponentImpl.tc, (String)"metaDataFail00", (Object[])new Object[]{moduleInfo.getName(), e});
                throw new MetaDataException(msg, (Throwable)e);
            }
        } else if (JAXRSComponentImpl.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)JAXRSComponentImpl.tc, (String)("Only WAR modules or EJB modules are supported for JAX-RS; not processing this module: " + moduleInfo.getMetaData().getJ2EEName()), (Object[])new Object[0]);
        }
lbl48:
        // 7 sources

        if (JAXRSComponentImpl.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)JAXRSComponentImpl.tc, (String)"extendModuleMetaData");
        }
        return webRouterModuleInfo;
    }

    private JAXRSServerMetaData getJAXRSServerMetaData(ModuleMetaData mmd) {
        return (JAXRSServerMetaData)mmd.getMetaData(this.slot);
    }

    @Override
    public JAXRSServerMetaData getJAXRSServerModuleMetaData() {
        ComponentMetaData cmd = cmdAccessor.getComponentMetaData();
        return cmd == null ? null : this.getJAXRSServerMetaData(cmd.getModuleMetaData());
    }
}

