/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs.configuration;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxrs.globalhandler.JAXRSConvertedRequestHandler;
import com.ibm.ws.jaxrs.globalhandler.JAXRSConvertedResponseHandler;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.servlet.ServletContext;
import org.apache.wink.common.internal.lifecycle.JSR250LifecycleManager;
import org.apache.wink.common.internal.lifecycle.LifecycleManager;
import org.apache.wink.common.internal.lifecycle.LifecycleManagersRegistry;
import org.apache.wink.jcdi.server.internal.lifecycle.JCDILifecycleManager;
import org.apache.wink.server.handlers.Handler;
import org.apache.wink.server.handlers.RequestHandlersChain;
import org.apache.wink.server.handlers.ResponseHandler;
import org.apache.wink.server.handlers.ResponseHandlersChain;
import org.apache.wink.server.internal.DeploymentConfiguration;
import org.apache.wink.server.internal.handlers.ejb.EJBExceptionHandler;
import org.apache.wink.server.internal.lifecycle.EJBLifecycleManager;
import org.apache.wink.server.internal.lifecycle.metadata.EJBMetadata;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class IBMDeploymentConfiguration
extends DeploymentConfiguration {
    private static TraceComponent tc = Tr.register(IBMDeploymentConfiguration.class, (String)"JAXRS", (String)"com.ibm.ws.jaxrs.internal.resources.JAXRSMessages");
    private ResponseHandlersChain errorHandlersChain;
    private RequestHandlersChain requestHandlersChain;
    private ResponseHandlersChain responseHandlersChain;
    public boolean hasNewRequestHandler = false;
    public boolean hasNewResponseHandler = false;
    public boolean hasNewErrorHandler = false;
    private boolean ejbEnabled = false;
    static final long serialVersionUID = -4704658469033426549L;

    public IBMDeploymentConfiguration(ServletContext servletContext) {
        LifecycleManagersRegistry lifecycleManagersRegistry = new LifecycleManagersRegistry();
        this.setOfFactoryRegistry(lifecycleManagersRegistry);
        lifecycleManagersRegistry.addFactoryFactory((LifecycleManager)new JSR250LifecycleManager());
        Boolean cdiEnabled = (Boolean)servletContext.getAttribute("CDI_ENABLED");
        if (cdiEnabled != null && cdiEnabled.equals(Boolean.TRUE)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"CDI is enabled.", (Object[])new Object[0]);
            }
            JCDILifecycleManager cdiMgr = new JCDILifecycleManager();
            boolean beanMgrSet = cdiMgr.setBeanManager(servletContext.getAttribute("CDI_BEAN_MGR"));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"BeanManager successfully set on JCDILifecycleManager", (Object[])new Object[]{beanMgrSet});
            }
            lifecycleManagersRegistry.addFactoryFactory((LifecycleManager)cdiMgr);
        }
        lifecycleManagersRegistry.addFactoryFactory((LifecycleManager)new EJBLifecycleManager(servletContext));
        EJBMetadata ejbMd = (EJBMetadata)servletContext.getAttribute("WINK_EJB_METADATA_KEY");
        if (ejbMd != null) {
            this.setEjbEnabled(true);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"EJB functionality is enabled", (Object[])new Object[0]);
            }
        }
    }

    public ResponseHandlersChain getErrorHandlersChain() {
        if (this.errorHandlersChain == null) {
            this.errorHandlersChain = super.getErrorHandlersChain();
            if (this.isEjbEnabled()) {
                this.errorHandlersChain.addFirstHandler((Handler)((ResponseHandler)this.createHandler(EJBExceptionHandler.class)));
            }
        }
        return this.errorHandlersChain;
    }

    public RequestHandlersChain getRequestHandlersChain() {
        if (this.requestHandlersChain == null) {
            this.requestHandlersChain = super.getRequestHandlersChain();
            JAXRSConvertedRequestHandler requestHander = new JAXRSConvertedRequestHandler();
            this.requestHandlersChain.addHandler((Handler)requestHander);
        }
        return this.requestHandlersChain;
    }

    public ResponseHandlersChain getResponseHandlersChain() {
        if (this.responseHandlersChain == null) {
            this.responseHandlersChain = super.getResponseHandlersChain();
            JAXRSConvertedResponseHandler responseHander = new JAXRSConvertedResponseHandler();
            this.responseHandlersChain.addFirstHandler((Handler)responseHander);
        }
        return this.responseHandlersChain;
    }

    private boolean isEjbEnabled() {
        return this.ejbEnabled;
    }

    private void setEjbEnabled(boolean ejbEnabled) {
        this.ejbEnabled = ejbEnabled;
    }
}

