/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs.webcontainer;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JAXRSDefaultApplicationSubclassProxy
extends Application {
    private static TraceComponent tc = Tr.register(JAXRSDefaultApplicationSubclassProxy.class, (String)"JAXRS", (String)"com.ibm.ws.jaxrs.internal.resources.JAXRSMessages");
    private final Set<Class<?>> classes;
    private final Set<Object> singletons;
    static final long serialVersionUID = -6389274071887290482L;

    public JAXRSDefaultApplicationSubclassProxy(Application application, Set<Class<?>> classes) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"constructor({0}, {1}) entered", (Object[])new Object[]{application, classes});
        }
        if (application == null) {
            this.singletons = Collections.emptySet();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"application was null so setting singletons to empty set", (Object[])new Object[0]);
            }
            if (classes == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"application and classes were null so empty set", (Object[])new Object[0]);
                }
                this.classes = Collections.emptySet();
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"application was null but scanned classes were available", (Object[])new Object[0]);
                }
                this.classes = classes;
            }
        } else {
            Set singletons = application.getSingletons();
            if (singletons == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"singletons was null", (Object[])new Object[0]);
                }
                this.singletons = Collections.emptySet();
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"singletons was non-null", (Object[])new Object[0]);
                }
                this.singletons = singletons;
            }
            Set appClasses = application.getClasses();
            if ((appClasses == null || appClasses.isEmpty()) && (singletons == null || singletons.isEmpty())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"singletons was empty or null and application's getClasses() was null or empty", (Object[])new Object[0]);
                }
                if (classes == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"scanned classes was null so adding empty set", (Object[])new Object[0]);
                    }
                    this.classes = Collections.emptySet();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"scanned classes was not null so adding all scanned classes to application", (Object[])new Object[0]);
                    }
                    this.classes = classes;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"original application classes was a non-empty set so using that", (Object[])new Object[0]);
                }
                this.classes = appClasses;
            }
        }
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

