/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs.webcontainer;

import com.ibm.websphere.jaxrs.server.IBMRestServlet;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs.JAXRSRuntimeDelegate;
import com.ibm.ws.jaxrs.cdi.JAXRSCDIService;
import com.ibm.ws.jaxrs.metadata.JAXRSServerMetaData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.jaxrs.JAXRSService;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.apache.wink.common.internal.uri.UriEncoder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@HandlesTypes(value={Application.class, Path.class, Provider.class})
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "service.ranking:Integer=100"})
public class JAXRSServletContainerInitializer
implements ServletContainerInitializer {
    private static TraceComponent tc = Tr.register(JAXRSServletContainerInitializer.class, (String)"JAXRS", (String)"com.ibm.ws.jaxrs.internal.resources.JAXRSMessages");
    private volatile JAXRSService jaxrsService;
    static final long serialVersionUID = -8051629855841587027L;

    static boolean isInitializerActive() {
        return true;
    }

    @Reference
    protected void setJaxrsService(JAXRSService jaxrsService) {
        this.jaxrsService = jaxrsService;
    }

    protected void unsetJaxrsService(JAXRSService ref) {
        this.jaxrsService = null;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    static Set<Class<? extends Application>> getApplicationSubclasses(Set<Class<?>> classes) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getApplicationSubclasses", (Object[])new Object[0]);
        }
        if (classes == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getApplicationSubclasses");
            }
            return Collections.emptySet();
        }
        HashSet<Class<? extends Application>> appClasses = new HashSet<Class<? extends Application>>();
        try {
            Class appClass = AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){
                static final long serialVersionUID = 6863704398567456907L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Class run() throws Exception {
                    return Thread.currentThread().getContextClassLoader().loadClass(Application.class.getName());
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs.webcontainer.JAXRSServletContainerInitializer$1", 1.class, (String)"JAXRS", (String)"com.ibm.ws.jaxrs.internal.resources.JAXRSMessages");
                }
            });
            for (Class<?> c : classes) {
                if (!appClass.isAssignableFrom(c)) continue;
                appClasses.add(c);
            }
        }
        catch (PrivilegedActionException appClass) {
            FFDCFilter.processException((Throwable)appClass, (String)"com.ibm.ws.jaxrs.webcontainer.JAXRSServletContainerInitializer", (String)"120", null, (Object[])new Object[]{classes});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("getPathClasses() exit - returning empty set due to PrivilegedActionException for " + Application.class.getName() + ": " + e), (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getApplicationSubclasses", Collections.emptySet());
            }
            return Collections.emptySet();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getApplicationSubclasses", appClasses);
        }
        return appClasses;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    static Set<Class<?>> getPathClasses(Set<Class<?>> classes) {
        String methodName = "getPathClasses";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPathClasses", (Object[])new Object[]{classes});
        }
        if (classes == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPathClasses", Collections.emptySet());
            }
            return Collections.emptySet();
        }
        HashSet pathClasses = new HashSet();
        try {
            Class pathClass = AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){
                static final long serialVersionUID = 8633661475495607177L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Class run() throws Exception {
                    return Thread.currentThread().getContextClassLoader().loadClass(Path.class.getName());
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs.webcontainer.JAXRSServletContainerInitializer$2", 2.class, (String)"JAXRS", (String)"com.ibm.ws.jaxrs.internal.resources.JAXRSMessages");
                }
            });
            for (Class<?> c : classes) {
                if (c.getAnnotation(pathClass) == null) continue;
                pathClasses.add(c);
            }
        }
        catch (PrivilegedActionException pathClass) {
            FFDCFilter.processException((Throwable)pathClass, (String)"com.ibm.ws.jaxrs.webcontainer.JAXRSServletContainerInitializer", (String)"168", null, (Object[])new Object[]{classes});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("getPathClasses() exit - returning empty set due to PrivilegedActionException for " + Path.class.getName() + ": " + e), (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPathClasses", Collections.emptySet());
            }
            return Collections.emptySet();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPathClasses", pathClasses);
        }
        return pathClasses;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    static Set<Class<?>> getProviderClasses(Set<Class<?>> classes) {
        String methodName = "getProviderClasses";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getProviderClasses", (Object[])new Object[]{classes});
        }
        if (classes == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getProviderClasses", Collections.emptySet());
            }
            return Collections.emptySet();
        }
        HashSet providerClasses = new HashSet();
        try {
            Class providerClass = AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){
                static final long serialVersionUID = 4073936280253494353L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Class run() throws Exception {
                    return Thread.currentThread().getContextClassLoader().loadClass(Provider.class.getName());
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs.webcontainer.JAXRSServletContainerInitializer$3", 3.class, (String)"JAXRS", (String)"com.ibm.ws.jaxrs.internal.resources.JAXRSMessages");
                }
            });
            for (Class<?> c : classes) {
                if (c.getAnnotation(providerClass) == null) continue;
                providerClasses.add(c);
            }
        }
        catch (PrivilegedActionException providerClass) {
            FFDCFilter.processException((Throwable)providerClass, (String)"com.ibm.ws.jaxrs.webcontainer.JAXRSServletContainerInitializer", (String)"216", null, (Object[])new Object[]{classes});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("getPathClasses() exit - returning empty set due to PrivilegedActionException for " + Provider.class.getName() + ": " + e), (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getProviderClasses", Collections.emptySet());
            }
            return Collections.emptySet();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getProviderClasses", providerClasses);
        }
        return providerClasses;
    }

    @ManualTrace
    static Set<String> getApplicationClassNamesDefinedInServletContext(ServletContext servletContext) {
        Map filterRegistrations;
        String methodName = "getApplicationClassNamesDefinedInServletContext";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getApplicationClassNamesDefinedInServletContext", (Object[])new Object[]{servletContext});
        }
        if (servletContext == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getApplicationClassNamesDefinedInServletContext() exit - returning empty set since no servlet context", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getApplicationClassNamesDefinedInServletContext", Collections.emptySet());
            }
            return Collections.emptySet();
        }
        HashSet<String> appClassNames = new HashSet<String>();
        String INIT_PARAM_NAME = "javax.ws.rs.Application";
        Map registrations = servletContext.getServletRegistrations();
        if (registrations == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getServletRegistrations() returned null", (Object[])new Object[0]);
            }
        } else {
            for (String servletName : registrations.keySet()) {
                String appName;
                ServletRegistration registration = (ServletRegistration)registrations.get(servletName);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Searching {} for init-param", (Object[])new Object[]{servletName});
                }
                if ((appName = registration.getInitParameter("javax.ws.rs.Application")) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Adding {} to list of Application class names", (Object[])new Object[]{appName});
                }
                appClassNames.add(appName);
            }
        }
        if ((filterRegistrations = servletContext.getFilterRegistrations()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getFilterRegistrations() returned null", (Object[])new Object[0]);
            }
        } else {
            for (String filterName : filterRegistrations.keySet()) {
                String appName;
                FilterRegistration registration = (FilterRegistration)filterRegistrations.get(filterName);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Searching {0} for init-param", (Object[])new Object[]{filterName});
                }
                if ((appName = registration.getInitParameter("javax.ws.rs.Application")) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Adding {0} to list of Application class names", (Object[])new Object[]{appName});
                }
                appClassNames.add(appName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getApplicationClassNamesDefinedInServletContext", appClassNames);
        }
        return appClassNames;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    static Set<Class<? extends Application>> getSetOfClassesThatDoNotMatchSetOfNames(Set<Class<? extends Application>> classes, Set<String> names) {
        HashSet<Class<? extends Application>> uniqueAppClasses;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getSetOfClassesThatDoNotMatchSetOfNames", (Object[])new Object[]{classes, names});
            }
            if (classes == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getSetOfClassesThatDoNotMatchSetOfNames", Collections.emptySet());
                }
                return Collections.emptySet();
            }
            if (names == null || names.isEmpty()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getSetOfClassesThatDoNotMatchSetOfNames", classes);
                }
                return classes;
            }
            uniqueAppClasses = new HashSet<Class<? extends Application>>();
            try {
                for (Class<? extends Application> c : classes) {
                    if (names.contains(c.getName())) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"Class name {0} was in set so not adding.", (Object[])new Object[]{c.getName()});
                        continue;
                    }
                    uniqueAppClasses.add(Thread.currentThread().getContextClassLoader().loadClass(c.getName()));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                void e;
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.jaxrs.webcontainer.JAXRSServletContainerInitializer", (String)"330", null, (Object[])new Object[]{classes, names});
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)tc, (String)"Could not add class to uniqueAppClasses set due to: {0}", (Object[])new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSetOfClassesThatDoNotMatchSetOfNames", uniqueAppClasses);
        }
        return uniqueAppClasses;
    }

    @ManualTrace
    static String getURLPattern(Class<? extends Application> applicationClassClass) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getURLPattern", (Object[])new Object[]{applicationClassClass});
        }
        if (applicationClassClass == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getURLPattern", null);
            }
            return null;
        }
        ApplicationPath appPath = applicationClassClass.getAnnotation(ApplicationPath.class);
        if (appPath == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getURLPattern", null);
            }
            return null;
        }
        String value = appPath.value();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"@ApplicationPath value is {0}", (Object[])new Object[]{value});
        }
        value = UriEncoder.encodePath((String)value, (boolean)true);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"@ApplicationPath value encoded is {0}", (Object[])new Object[]{value});
        }
        if (!value.endsWith("/*")) {
            if (!value.endsWith("/")) {
                value = value + "/";
            }
            if (!value.endsWith("*")) {
                value = value + "*";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getURLPattern", (Object)value);
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    @ManualTrace
    static boolean registerApplication(Set<Class<?>> classes, ServletContext servletContext, Class<? extends Application> applicationClassClass, boolean isRouter) {
        block22: {
            block23: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"registerApplication", (Object[])new Object[]{classes, servletContext, applicationClassClass});
                }
                String servletName = null;
                servletName = applicationClassClass == null ? Application.class.getName() : applicationClassClass.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Servlet name is {0}", (Object[])new Object[]{servletName});
                }
                ServletRegistration preexistRegistration = servletContext.getServletRegistration(servletName);
                String pattern = null;
                if (!isRouter) {
                    if (preexistRegistration == null) {
                        pattern = JAXRSServletContainerInitializer.getURLPattern(applicationClassClass);
                        if (pattern == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Servlet registration did not exist already for {0} and no @ApplicationPath on the Application sub-class so skipping instantiating a JAXRS Application for it", (Object[])new Object[]{servletName});
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"registerApplication", (Object)false);
                            }
                            return false;
                        }
                    } else {
                        Collection preexistMappings = preexistRegistration.getMappings();
                        if ((preexistMappings == null || preexistMappings.size() == 0) && (pattern = JAXRSServletContainerInitializer.getURLPattern(applicationClassClass)) == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Servlet registration did exist already but no @ApplicationPath for {0} so skipping instantiating a JAXRS Application for it", (Object[])new Object[]{servletName});
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"registerApplication", (Object)false);
                            }
                            return false;
                        }
                    }
                }
                IBMRestServlet restServlet = new IBMRestServlet(applicationClassClass, classes, servletName);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Created new servlet {0}", (Object[])new Object[]{restServlet});
                    Tr.debug((TraceComponent)tc, (String)"Servlet registration before adding: {0}", (Object[])new Object[]{servletContext.getServletRegistrations()});
                    Tr.debug((TraceComponent)tc, (String)"Servlet registration values before adding: {0}", (Object[])new Object[]{servletContext.getServletRegistrations().values()});
                }
                ServletRegistration.Dynamic registration = servletContext.addServlet(servletName, (Servlet)restServlet);
                if (isRouter) {
                    String appPattern = JAXRSServletContainerInitializer.getURLPattern(applicationClassClass);
                    if (null != appPattern) {
                        registration.addMapping(new String[]{appPattern});
                    } else {
                        registration.addMapping(new String[]{"/*"});
                    }
                }
                Collection mappings = registration.getMappings();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Servlet registration created : {0}", (Object[])new Object[]{registration});
                    Tr.debug((TraceComponent)tc, (String)"Existing servlet mappings: {0} ", (Object[])new Object[]{mappings});
                }
                if (mappings != null && !mappings.isEmpty()) break block22;
                if (applicationClassClass == null) break block23;
                if (pattern != null) {
                    registration.addMapping(new String[]{pattern});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Added mapping {0} to {1}", (Object[])new Object[]{pattern, registration});
                    }
                    break block22;
                } else {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"registerApplication");
                    }
                    return false;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"registerApplication");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerApplication", (Object)true);
        }
        return true;
    }

    @ManualTrace
    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        HashSet defaultAppClasses;
        JAXRSServerMetaData metadata;
        String methodName = "onStartup";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"onStartup", (Object[])new Object[]{classes, servletContext});
        }
        boolean iamRouter = false;
        if (this.jaxrsService != null && (metadata = this.jaxrsService.getJAXRSServerModuleMetaData()) != null && metadata.hasMetaDataForRouter()) {
            classes = metadata.getEjbClasses();
            servletContext.setAttribute("ejbmodulename.router", (Object)metadata.getEjbModuleName());
            iamRouter = true;
        }
        if (servletContext == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No servlet context.  This should never happen...", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"onStartup");
            }
            return;
        }
        if (!JAXRSRuntimeDelegate.isBuiltInProvider()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Application uses its own JAX-RS provider", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"onStartup");
            }
            return;
        }
        String servletVersion = servletContext.getEffectiveMajorVersion() + "." + servletContext.getEffectiveMinorVersion();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Servlet version is " + servletVersion), (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled() && servletContext.getEffectiveMajorVersion() < 3 && (classes == null || classes.isEmpty())) {
            Tr.debug((TraceComponent)tc, (String)"The servlet version is less than 3.0, therefore no EJB or CDI metadata will be processed. If metadata is expected, ensure the servlet version is at least 3.0 in the web.xml", (Object[])new Object[0]);
        }
        if (classes == null || classes.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No JAX-RS classes were found in the application.", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"onStartup");
            }
            return;
        }
        this.saveMetadataOnServletContext(servletContext);
        if (!JAXRSServletContainerInitializer.isInitializerActive()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"{0} is disabled.", (Object[])new Object[]{JAXRSServletContainerInitializer.class.getName()});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"onStartup");
            }
            return;
        }
        Set<Class<? extends Application>> applicationClasses = JAXRSServletContainerInitializer.getApplicationSubclasses(classes);
        Set<Class<?>> providerClasses = JAXRSServletContainerInitializer.getProviderClasses(classes);
        Set<Class<?>> pathClasses = JAXRSServletContainerInitializer.getPathClasses(classes);
        if (applicationClasses.isEmpty() && pathClasses.isEmpty() && providerClasses.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"All classses were empty for some reason.", (Object[])new Object[0]);
            }
            throw new IllegalArgumentException();
        }
        if (applicationClasses.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No application sub-class so adding a servlet registration for all @Path and @Provider classes found.", (Object[])new Object[0]);
            }
            HashSet defaultAppClasses2 = new HashSet();
            defaultAppClasses2.addAll(pathClasses);
            defaultAppClasses2.addAll(providerClasses);
            JAXRSServletContainerInitializer.registerApplication(defaultAppClasses2, servletContext, null, iamRouter);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"onStartup");
            }
            return;
        }
        Set<String> appClassesNamedAsInitParams = JAXRSServletContainerInitializer.getApplicationClassNamesDefinedInServletContext(servletContext);
        Set<Class<? extends Application>> appClassesNotMentionedInInitParam = JAXRSServletContainerInitializer.getSetOfClassesThatDoNotMatchSetOfNames(applicationClasses, appClassesNamedAsInitParams);
        boolean didAddServletDefinition = false;
        if (!appClassesNotMentionedInInitParam.isEmpty()) {
            defaultAppClasses = new HashSet();
            defaultAppClasses.addAll(pathClasses);
            defaultAppClasses.addAll(providerClasses);
            for (Class<? extends Application> appClass : appClassesNotMentionedInInitParam) {
                boolean result;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Going to add servlet definition for class {0}", (Object[])new Object[]{appClass});
                }
                didAddServletDefinition = (result = JAXRSServletContainerInitializer.registerApplication(defaultAppClasses, servletContext, appClass, iamRouter)) || didAddServletDefinition;
            }
        }
        if (!didAddServletDefinition) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No application sub-class were added because no pre-existing servlet registrations existed for them so try to add a servlet registration for all @Path and @Provider classes found.", (Object[])new Object[0]);
            }
            defaultAppClasses = new HashSet();
            defaultAppClasses.addAll(pathClasses);
            defaultAppClasses.addAll(providerClasses);
            JAXRSServletContainerInitializer.registerApplication(defaultAppClasses, servletContext, null, iamRouter);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"onStartup");
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"onStartup");
        }
    }

    @ManualTrace
    protected void saveMetadataOnServletContext(ServletContext servletContext) {
        String methodName = "saveMetadataOnServletContext";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"saveMetadataOnServletContext", (Object[])new Object[]{servletContext});
        }
        if (this.jaxrsService != null) {
            JAXRSServerMetaData metadata = this.jaxrsService.getJAXRSServerModuleMetaData();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JAXRSServerMetadata retrieved from the module slot {0}", (Object[])new Object[]{metadata});
            }
            if (metadata != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Adding EJBMetadata and CDI information to the servlet context.", (Object[])new Object[0]);
                }
                servletContext.setAttribute("WINK_EJB_METADATA_KEY", (Object)metadata.getEjbMetadata());
                boolean cdiEnabled = metadata.isCDIEnabled();
                servletContext.setAttribute("CDI_ENABLED", (Object)cdiEnabled);
                if (cdiEnabled) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"CDI is enabled so will try to find and set the BeanManager on the ServletContext", (Object[])new Object[0]);
                    }
                    JAXRSCDIService service = metadata.getCDIService();
                    Object beanManager = service.getBeanManager();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Got BeanManager " + beanManager), (Object[])new Object[0]);
                    }
                    servletContext.setAttribute("CDI_BEAN_MGR", beanManager);
                }
                servletContext.setAttribute("collaborator", (Object)metadata.getCollaborator());
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JAXRSServerMetadata was null. No processing of EJB or CDI metadata.", (Object[])new Object[0]);
                if (servletContext.getEffectiveMajorVersion() < 3 && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The servlet version is less than 3. If EJB or JCDI metadata is expected, ensure the servlet version is at least 3.0 in the web.xml.", (Object[])new Object[0]);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JAXRSService was null so did not grab the metadata; an initialization error might have occurred.", (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"saveMetadataOnServletContext");
        }
    }
}

