/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.client.injection;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.common.InjectionTarget;
import com.ibm.ws.javaee.dd.common.wsclient.ServiceRef;
import com.ibm.ws.jaxws.client.injection.WebServiceRefBinding;
import com.ibm.ws.jaxws.client.injection.WebServiceRefSimulator;
import com.ibm.ws.jaxws.metadata.EndpointInfo;
import com.ibm.ws.jaxws.metadata.JaxWsModuleInfo;
import com.ibm.ws.jaxws.metadata.JaxWsModuleMetaData;
import com.ibm.ws.jaxws.metadata.PortComponentRefInfo;
import com.ibm.ws.jaxws.metadata.WebServiceRefInfo;
import com.ibm.ws.jaxws.metadata.builder.WebServiceRefInfoBuilder;
import com.ibm.ws.jaxws.support.JaxWsMetaDataManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceRef;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebServiceRefBindingBuilder {
    private static final TraceComponent tc = Tr.register(WebServiceRefBindingBuilder.class, (String)"JaxWsClientContainer", (String)"com.ibm.ws.jaxws.clientcontainer.internal.resources.JaxWsClientContainerMessages");
    static final long serialVersionUID = 6732096068334697156L;

    /*
     * WARNING - void declaration
     */
    static List<InjectionBinding<WebServiceRef>> buildJaxWsWebServiceRefBindings(List<ServiceRef> jaxwsServiceRefs, ComponentNameSpaceConfiguration cnsConfig) throws InjectionException {
        if (jaxwsServiceRefs.size() == 0) {
            return Collections.emptyList();
        }
        ClassLoader classLoader = cnsConfig.getClassLoader();
        ArrayList<InjectionBinding<WebServiceRef>> bindingList = new ArrayList<InjectionBinding<WebServiceRef>>(jaxwsServiceRefs.size());
        try {
            for (ServiceRef serviceRef : jaxwsServiceRefs) {
                List injectionTargets;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Building WebServiceRefInfo for service-ref: " + serviceRef.getName()), (Object[])new Object[0]);
                }
                WebServiceRefInfo wsrInfo = WebServiceRefInfoBuilder.buildWebServiceRefInfo(serviceRef, classLoader);
                wsrInfo.setClientMetaData(JaxWsMetaDataManager.getJaxWsClientMetaData(cnsConfig.getModuleMetaData()));
                Class srvInterfaceClass = wsrInfo.getAnnotationValue().value();
                Class srvRefTypeClass = wsrInfo.getAnnotationValue().type();
                if (wsrInfo.getWsdlLocation() == null || wsrInfo.getWsdlLocation().isEmpty()) {
                    JaxWsModuleMetaData jaxwsModuleMetaData;
                    Container moduleContainer;
                    NonPersistentCache overlayCache;
                    JaxWsModuleInfo jaxWsModuleInfo;
                    String pcLinkValue = null;
                    String srvRefTypeClassName = wsrInfo.getServiceRefTypeClassName();
                    for (Map.Entry<String, PortComponentRefInfo> entry : wsrInfo.getPortComponentRefInfoMap().entrySet()) {
                        String seiName = entry.getKey();
                        PortComponentRefInfo pcRefInfo = entry.getValue();
                        if (!seiName.equals(srvRefTypeClassName)) continue;
                        pcLinkValue = pcRefInfo.getPortComponentLink();
                        break;
                    }
                    if (pcLinkValue != null && (jaxWsModuleInfo = (JaxWsModuleInfo)(overlayCache = (NonPersistentCache)(moduleContainer = (jaxwsModuleMetaData = JaxWsMetaDataManager.getJaxWsModuleMetaData(cnsConfig.getModuleMetaData())).getModuleContainer()).adapt(NonPersistentCache.class)).getFromCache(JaxWsModuleInfo.class)) != null) {
                        for (EndpointInfo endpointInfo : jaxWsModuleInfo.getEndpointInfos()) {
                            if (!pcLinkValue.equals(endpointInfo.getPortComponentName())) continue;
                            String wsdlLocation = endpointInfo.getWsdlLocation();
                            if (wsdlLocation == null || wsdlLocation.isEmpty()) break;
                            wsrInfo.setWsdlLocation(wsdlLocation);
                            break;
                        }
                    }
                }
                WebServiceRefBinding binding = new WebServiceRefBinding(wsrInfo, cnsConfig);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Created WebServiceRefBinding: " + binding.toString()), (Object[])new Object[0]);
                }
                if ((injectionTargets = serviceRef.getInjectionTargets()) != null && !injectionTargets.isEmpty()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Adding injection targets specified in service-ref element", (Object[])new Object[0]);
                    }
                    Class injectionType = srvInterfaceClass;
                    if (srvRefTypeClass != null && !srvRefTypeClass.getName().equals(Object.class.getName())) {
                        injectionType = srvRefTypeClass;
                    }
                    for (InjectionTarget target : injectionTargets) {
                        if (target.getInjectionTargetClassName() == null || target.getInjectionTargetName() == null) continue;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Adding injection target from XML, type= " + injectionType.getName() + ", target class= " + target.getInjectionTargetClassName() + ", target member= " + target.getInjectionTargetName()), (Object[])new Object[0]);
                        }
                        binding.addInjectionTarget(injectionType, target.getInjectionTargetName(), target.getInjectionTargetClassName());
                    }
                }
                bindingList.add(binding);
            }
        }
        catch (InjectionException injectionException) {
            void e;
            FFDCFilter.processException((Throwable)injectionException, (String)"com.ibm.ws.jaxws.client.injection.WebServiceRefBindingBuilder", (String)"153", null, (Object[])new Object[]{jaxwsServiceRefs, cnsConfig});
            throw e;
        }
        catch (Throwable e) {
            void t;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxws.client.injection.WebServiceRefBindingBuilder", (String)"155", null, (Object[])new Object[]{jaxwsServiceRefs, cnsConfig});
            throw new InjectionException((Throwable)t);
        }
        return bindingList;
    }

    static InjectionBinding<WebServiceRef> createWebServiceRefBindingFromResource(Resource resource, ComponentNameSpaceConfiguration cnsConfig, Class<?> serviceClass, String jndiName) throws InjectionException {
        WebServiceRefBinding binding = null;
        WebServiceRef wsRef = WebServiceRefBindingBuilder.createWebServiceRefFromResource(resource, serviceClass, jndiName);
        WebServiceRefInfo wsrInfo = WebServiceRefInfoBuilder.buildWebServiceRefInfo(wsRef, cnsConfig.getClassLoader());
        wsrInfo.setClientMetaData(JaxWsMetaDataManager.getJaxWsClientMetaData(cnsConfig.getModuleMetaData()));
        wsrInfo.setServiceInterfaceClassName(serviceClass.getName());
        binding = new WebServiceRefBinding(wsRef, cnsConfig);
        binding.setWebServiceRefInfo(wsrInfo);
        binding.setResourceType(true);
        return binding;
    }

    static WebServiceRef createWebServiceRefFromResource(Resource resource, Class<?> typeClass, String jndiName) throws InjectionException {
        return new WebServiceRefSimulator(resource.mappedName(), jndiName, typeClass, Service.class, null, "");
    }
}

