/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.metadata.builder;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashSet;
import java.util.Set;
import javax.xml.ws.WebServiceException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class WsdlBindingTypeValidationHandler
extends DefaultHandler {
    private static final TraceComponent tc = Tr.register(WsdlBindingTypeValidationHandler.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
    private final String bindingType;
    private final String wsdlLocation;
    private final String portComponentName;
    private final Set<String> portTypePrefixes = new HashSet<String>(2);
    private boolean processingTargetPortTypeBinding = false;
    private Result result = Result.NOT_FOUND;
    static final long serialVersionUID = -7021304169754105933L;

    public WsdlBindingTypeValidationHandler(String bindingType, String wsdlLocation, String portComponentName) {
        this.bindingType = bindingType;
        this.wsdlLocation = wsdlLocation;
        this.portComponentName = portComponentName;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.result.equals((Object)Result.PASS)) {
            if ("definitions".equals(localName) && this.isWsdl11Uri(uri)) {
                String tnsValue = attributes.getValue("targetNamespace");
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("targetNamespace") || !attributes.getValue(i).equals(tnsValue) || !attributes.getQName(i).startsWith("xmlns:")) continue;
                    this.portTypePrefixes.add(attributes.getQName(i).substring("xmlns:".length()));
                }
            } else if ("binding".equals(localName) && this.isWsdl11Uri(uri)) {
                String portTypeValue = attributes.getValue("type");
                for (String portTypePrefix : this.portTypePrefixes) {
                    if (!portTypeValue.equals(portTypePrefix + ":" + this.portComponentName)) continue;
                    this.processingTargetPortTypeBinding = true;
                    break;
                }
            } else if ("binding".equals(localName) && (this.isSoap11Uri(uri) || this.isSoap12Uri(uri)) && this.processingTargetPortTypeBinding) {
                String transportValue = attributes.getValue("transport");
                this.result = (this.bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http") || this.bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true")) && this.isSoap11Uri(uri) && this.isHttpTransport(transportValue) ? Result.PASS : ((this.bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || this.bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) && this.isSoap12Uri(uri) && this.isHttpTransport(transportValue) ? Result.PASS : Result.ERROR);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("binding".equals(localName) && this.isWsdl11Uri(uri)) {
            this.processingTargetPortTypeBinding = false;
        }
    }

    @Override
    public void endDocument() {
        if (this.result.equals((Object)Result.ERROR)) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"error.endpointinfo.validation.bindingtype.and.wsdl.mismatch", (Object[])new Object[]{this.bindingType, this.portComponentName, this.wsdlLocation});
            throw new WebServiceException(msg);
        }
    }

    private boolean isWsdl11Uri(String uri) {
        return "http://schemas.xmlsoap.org/wsdl/".equals(uri);
    }

    private boolean isSoap11Uri(String uri) {
        return "http://schemas.xmlsoap.org/wsdl/soap/".equals(uri);
    }

    private boolean isSoap12Uri(String uri) {
        return "http://schemas.xmlsoap.org/wsdl/soap12/".equals(uri);
    }

    private boolean isHttpTransport(String uri) {
        return "http://schemas.xmlsoap.org/soap/http".equals(uri);
    }

    private static enum Result {
        NOT_FOUND,
        PASS,
        ERROR;

    }
}

