/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.support;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxws.metadata.JaxWsClientMetaData;
import com.ibm.ws.jaxws.metadata.JaxWsModuleMetaData;
import com.ibm.ws.jaxws.metadata.JaxWsServerMetaData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxWsMetaDataManager {
    private static final TraceComponent tc = Tr.register(JaxWsMetaDataManager.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
    static MetaDataSlot jaxwsApplicationSlot = null;
    static MetaDataSlot jaxwsModuleSlot = null;
    static MetaDataSlot jaxwsComponentSlot = null;
    static final long serialVersionUID = -1621377924213302214L;

    public static void setJaxWsModuleMetaData(ModuleMetaData mmd, JaxWsModuleMetaData moduleMetaData) {
        if (mmd != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting ModuleMetaData on ModuleMetaData instance: " + mmd), (Object[])new Object[0]);
            }
            mmd.setMetaData(jaxwsModuleSlot, (Object)moduleMetaData);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Could not set ModuleMetaData because ModuleMetaData is null", (Object[])new Object[0]);
        }
    }

    public static JaxWsModuleMetaData getJaxWsModuleMetaData(ModuleMetaData mmd) {
        if (mmd != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Getting JaxWs module metadata from module metadata instance: " + mmd), (Object[])new Object[0]);
            }
            return (JaxWsModuleMetaData)mmd.getMetaData(jaxwsModuleSlot);
        }
        return null;
    }

    public static JaxWsModuleMetaData getJaxWsModuleMetaData() {
        return JaxWsMetaDataManager.getJaxWsModuleMetaData(JaxWsMetaDataManager.getModuleMetaData());
    }

    public static JaxWsClientMetaData getJaxWsClientMetaData(ModuleMetaData mmd) {
        JaxWsClientMetaData clientMetaData = null;
        if (mmd != null) {
            JaxWsModuleMetaData moduleMetaData;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Getting client metadata from module metadata instance: " + mmd), (Object[])new Object[0]);
            }
            if ((moduleMetaData = (JaxWsModuleMetaData)mmd.getMetaData(jaxwsModuleSlot)) != null) {
                clientMetaData = moduleMetaData.getClientMetaData();
            }
        }
        return clientMetaData;
    }

    public static JaxWsServerMetaData getJaxWsServerMetaData(ModuleMetaData mmd) {
        JaxWsServerMetaData serverMetaData = null;
        if (mmd != null) {
            JaxWsModuleMetaData moduleMetaData;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Getting client metadata from module metadata instance: " + mmd), (Object[])new Object[0]);
            }
            if ((moduleMetaData = (JaxWsModuleMetaData)mmd.getMetaData(jaxwsModuleSlot)) != null) {
                serverMetaData = moduleMetaData.getServerMetaData();
            }
        }
        return serverMetaData;
    }

    public static JaxWsClientMetaData getJaxWsClientMetaData() {
        ModuleMetaData mmd = JaxWsMetaDataManager.getModuleMetaData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("mmd: " + mmd), (Object[])new Object[0]);
        }
        return JaxWsMetaDataManager.getJaxWsClientMetaData(mmd);
    }

    public static ModuleMetaData getModuleMetaData() {
        ComponentMetaData cmd = JaxWsMetaDataManager.getComponentMetaData();
        ModuleMetaData mmd = null;
        if (cmd != null) {
            mmd = cmd.getModuleMetaData();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ModuleMetaData object is " + (mmd != null ? mmd.toString() : "null!")), (Object[])new Object[0]);
        }
        return mmd;
    }

    public static ComponentMetaData getComponentMetaData() {
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        return cmd;
    }
}

