/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility.tasks;

import com.ibm.ws.jbatch.utility.http.HttpUtils;
import com.ibm.ws.jbatch.utility.http.Response;
import com.ibm.ws.jbatch.utility.rest.BatchRestClient;
import com.ibm.ws.jbatch.utility.tasks.BaseBatchRestTask;
import com.ibm.ws.jbatch.utility.utils.ArgumentRequiredException;
import com.ibm.ws.jbatch.utility.utils.ConsoleWrapper;
import com.ibm.ws.jbatch.utility.utils.ObjectUtils;
import com.ibm.ws.jbatch.utility.utils.StringUtils;
import com.ibm.ws.jbatch.utility.utils.TaskIO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;

public class GetJobLogTask
extends BaseBatchRestTask<GetJobLogTask> {
    public GetJobLogTask(String scriptName) {
        super("getJobLog", scriptName);
    }

    @Override
    public int handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws Exception {
        this.setTaskIO(new TaskIO(stdin, stdout, stderr));
        this.setTaskArgs(args);
        this.verifyRequiredArgs();
        BatchRestClient batchRestClient = this.buildBatchRestClient();
        Response response = this.getJobInstanceId() != null ? batchRestClient.getJobLogsForJobInstance(this.getJobInstanceId(), this.getType()) : batchRestClient.getJobLogsForJobExecution(this.getJobExecutionId(), this.getType());
        File outputFile = ObjectUtils.firstNonNull(this.getOutputFile(), this.parseFileFromDisposition(response.getHeader("Content-Disposition")));
        OutputStream outputStream = outputFile != null ? new FileOutputStream(outputFile) : this.getTaskIO().getStdout();
        response.copyToStream(outputStream);
        if (outputFile != null) {
            outputStream.close();
            this.issueJobLogToFileMessage(outputFile);
        }
        return 0;
    }

    protected File getOutputFile() {
        return this.getTaskArgs().getFileValue("--outputFile");
    }

    protected Long getJobExecutionId() {
        return this.getTaskArgs().getLongValue("--jobExecutionId", null);
    }

    protected Long getJobInstanceId() {
        return this.getTaskArgs().getLongValue("--jobInstanceId", null);
    }

    protected String getType() {
        return this.getTaskArgs().verifyStringValue("--type", Arrays.asList("text", "zip"), "text");
    }

    protected void verifyRequiredArgs() throws IOException {
        if (this.getJobInstanceId() == null && this.getJobExecutionId() == null) {
            throw new ArgumentRequiredException("--jobInstanceId or --jobExecutionId");
        }
    }

    protected File parseFileFromDisposition(String contentDisposition) {
        String filename = HttpUtils.parseHeaderParameter(contentDisposition, "filename");
        if (StringUtils.isEmpty(filename)) {
            return null;
        }
        return new File(StringUtils.dequote(filename));
    }

    protected void issueJobLogToFileMessage(File outputFile) throws IOException {
        this.getTaskIO().info(this.getMessage("joblog.to.file", outputFile.getCanonicalPath()));
    }
}

