/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.CommonFunction;
import com.ibm.ejs.j2c.ConnectionManager;
import com.ibm.ejs.j2c.ConnectionManagerServiceImpl;
import com.ibm.ejs.j2c.MCWrapper;
import com.ibm.ejs.j2c.PoolManager;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.cm.mbean.ConnectionManagerMBean;
import java.util.Arrays;
import java.util.Hashtable;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.StandardMBean;
import javax.resource.ResourceException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;

public class PoolManagerMBeanImpl
extends StandardMBean
implements ConnectionManagerMBean {
    private static final TraceComponent tc = Tr.register(PoolManagerMBeanImpl.class, (String)"WAS.j2c", (String)"com.ibm.ws.j2c.resources.J2CAMessages");
    private static final TraceComponent ConnLeakLogic = Tr.register(ConnectionManager.class, (String)"ConnLeakLogic", (String)"com.ibm.ws.j2c.resources.J2CAMessages");
    private transient PoolManager _pm = null;
    private transient Version jdbcRuntimeVersion;
    private transient ObjectName obn = null;
    private transient ServiceRegistration<?> reg = null;
    private final String nl = CommonFunction.nl;

    public PoolManagerMBeanImpl(PoolManager pm, Version jdbcRuntimeVersion) throws MalformedObjectNameException {
        super(ConnectionManagerMBean.class, false);
        this._pm = pm;
        this.jdbcRuntimeVersion = jdbcRuntimeVersion;
        StringBuilder obnSb = new StringBuilder("WebSphere:type=" + ConnectionManagerMBean.class.getCanonicalName());
        if (this._pm.gConfigProps.getJNDIName() != null) {
            obnSb.append(",jndiName=");
            obnSb.append(this.toObnString(this._pm.gConfigProps.getJNDIName()));
        }
        if (this._pm.gConfigProps.getXpathId() != null) {
            obnSb.append(",name=");
            obnSb.append(this.toObnString(this._pm.gConfigProps.getXpathId()));
        }
        if (this._pm.gConfigProps.appName != null) {
            obnSb.append(",application=");
            obnSb.append(this.toObnString(this._pm.gConfigProps.appName));
        }
        if (this._pm.gConfigProps.modName != null) {
            obnSb.append(",module=");
            obnSb.append(this.toObnString(this._pm.gConfigProps.modName));
        }
        if (this._pm.gConfigProps.compName != null) {
            obnSb.append(",component=");
            obnSb.append(this.toObnString(this._pm.gConfigProps.compName));
        }
        try {
            this.obn = new ObjectName(obnSb.toString());
        }
        catch (MalformedObjectNameException e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"79", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Unable to create ObjectName with the string: " + obnSb.toString()), (Object[])new Object[]{e});
            }
            throw e;
        }
    }

    public void register(BundleContext bndCtx) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("jmx.objectname", this.obn.toString());
        this.reg = ConnectionManagerServiceImpl.priv.registerService(bndCtx, ConnectionManagerMBean.class.getName(), (Object)this, props);
    }

    public void unregister() {
        this.reg.unregister();
        this.reg = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"invoke", (Object[])new Object[]{params, signature});
        }
        Object o = null;
        if ("showPoolContents".equalsIgnoreCase(actionName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Displaying the connection pool", (Object[])new Object[0]);
            }
            o = this.showPoolContents();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Connection pool contents", (Object[])new Object[]{o});
            }
        } else if ("purgePoolContents".equalsIgnoreCase(actionName)) {
            if (params == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Normal purge of the connection pool", (Object[])new Object[0]);
                }
                this.purgePoolContents("normal");
            } else {
                if (params.length != 1 || !(params[0] instanceof String)) throw new MBeanException(new IllegalArgumentException(Arrays.toString(params)), Tr.formatMessage((TraceComponent)tc, (String)"INVALID_MBEAN_INVOKE_PARAM_J2CA8060", (Object[])new Object[]{Arrays.toString(params), actionName}));
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Purging the connection pool using option", (Object[])new Object[]{(String)params[0]});
                }
                this.purgePoolContents((String)params[0]);
            }
        } else if ("getJndiName".equalsIgnoreCase(actionName)) {
            o = this.getJndiName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JNDI Name", (Object[])new Object[]{o});
            }
        } else if ("getMaxSize".equalsIgnoreCase(actionName)) {
            o = this.getMaxSize();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Max size", (Object[])new Object[]{o});
            }
        } else if ("getSize".equalsIgnoreCase(actionName)) {
            o = this.getSize();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Size", (Object[])new Object[]{o});
            }
        } else {
            if (!"getAvailable".equalsIgnoreCase(actionName)) throw new MBeanException(new IllegalArgumentException(actionName), Tr.formatMessage((TraceComponent)tc, (String)"INVALID_MBEAN_INVOKE_ACTION_J2CA8061", (Object[])new Object[]{actionName, "ConnectionManager"}));
            o = this.getAvailable();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Available size", (Object[])new Object[]{o});
            }
        }
        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) return o;
        Tr.exit((Object)this, (TraceComponent)tc, (String)"invoke");
        return o;
    }

    @Override
    protected String getClassName(MBeanInfo info) {
        return ConnectionManagerMBean.class.getCanonicalName();
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "MBean for a Connection Manager";
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        String cname = this.getClassName(null);
        String text = "MBean for a Connection Manager";
        String purgeParamDesc = "Use 'immediate' to purge the pool contents immediately. Any other string value will purge the pool contents normally.";
        if (this.atLeastJDBCVersion(new Version(4, 1, 0))) {
            purgeParamDesc = "Use 'abort' to abort all connections in the pool using Connection.abort(). " + purgeParamDesc;
        }
        MBeanParameterInfo p0 = new MBeanParameterInfo("arg0", String.class.getCanonicalName(), purgeParamDesc);
        MBeanParameterInfo[] purgeParams = new MBeanParameterInfo[]{p0};
        MBeanOperationInfo op0 = new MBeanOperationInfo("purgePoolContents", "Purges the contents of the Connection Manager.", purgeParams, Void.class.getCanonicalName(), 1);
        MBeanOperationInfo op1 = new MBeanOperationInfo("showPoolContents", "Displays the current contents of the Connection Manager in a human readable format.", null, String.class.getCanonicalName(), 0);
        MBeanOperationInfo[] ops = new MBeanOperationInfo[]{op0, op1};
        MBeanInfo nmbi = new MBeanInfo(cname, text, null, null, ops, null, null);
        return nmbi;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException {
        if (attribute.equals("size")) {
            return Long.valueOf(this.getSize()).toString();
        }
        if (attribute.equals("Size")) {
            return this.getSize();
        }
        if (attribute.equalsIgnoreCase("maxSize")) {
            return this.getMaxSize();
        }
        if (attribute.equalsIgnoreCase("available")) {
            return this.getAvailable();
        }
        if (attribute.equalsIgnoreCase("jndiName")) {
            return this.getJndiName();
        }
        throw new AttributeNotFoundException(attribute);
    }

    public String toString() {
        return new StringBuffer("ConnectionManagerMBean@").append(Integer.toHexString(this.hashCode())).append(' ').append(this.obn.toString()).toString();
    }

    @Override
    public String getJndiName() {
        if (this._pm.gConfigProps == null || this._pm.gConfigProps.getJNDIName() == null) {
            return "none";
        }
        return this._pm.gConfigProps.getJNDIName();
    }

    @Override
    public long getMaxSize() {
        return this._pm.maxConnections;
    }

    @Override
    public long getSize() {
        return this._pm.totalConnectionCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAvailable() {
        long numFreeConnections = 0L;
        this._pm.mcToMCWMapWrite.lock();
        try {
            int mcToMCWSize = this._pm.mcToMCWMap.size();
            if (mcToMCWSize > 0) {
                Object[] tempObject = this._pm.mcToMCWMap.values().toArray();
                MCWrapper mcw = null;
                for (int ti = 0; ti < mcToMCWSize; ++ti) {
                    mcw = (MCWrapper)tempObject[ti];
                    if (mcw.getPoolState() != 1) continue;
                    ++numFreeConnections;
                }
            }
        }
        finally {
            this._pm.mcToMCWMapWrite.unlock();
        }
        return numFreeConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toStringExternal() {
        StringBuffer buf = new StringBuffer();
        StringBuffer unsharedBuf = new StringBuffer();
        StringBuffer sharedBuf = new StringBuffer();
        StringBuffer freeBuf = new StringBuffer();
        buf.append("PoolManager@");
        buf.append(Integer.toHexString(this.hashCode()));
        buf.append(this.nl);
        buf.append("name=");
        buf.append(this.obn.toString());
        buf.append(this.nl);
        buf.append("jndiName=");
        buf.append(this.getJndiName());
        buf.append(this.nl);
        buf.append("maxPoolSize=");
        buf.append(this.getMaxSize());
        buf.append(this.nl);
        buf.append("size=");
        buf.append(this.getSize());
        buf.append(this.nl);
        int numUnsharedConnections = 0;
        int numSharedConnections = 0;
        int numFreeConnections = 0;
        this._pm.mcToMCWMapWrite.lock();
        try {
            int mcToMCWSize = this._pm.mcToMCWMap.size();
            if (mcToMCWSize > 0) {
                Object[] tempObject = this._pm.mcToMCWMap.values().toArray();
                MCWrapper mcw = null;
                block8: for (int ti = 0; ti < mcToMCWSize; ++ti) {
                    mcw = (MCWrapper)tempObject[ti];
                    switch (mcw.getPoolState()) {
                        case 1: {
                            ++numFreeConnections;
                            freeBuf.append(" ManagedConnection@");
                            freeBuf.append(Integer.toHexString(mcw.hashCode()));
                            freeBuf.append('=');
                            freeBuf.append(this.translateStateString(mcw.getStateString()));
                            freeBuf.append(this.nl);
                            continue block8;
                        }
                        case 2: {
                            ++numSharedConnections;
                            sharedBuf.append(" ManagedConnection@");
                            sharedBuf.append(Integer.toHexString(mcw.hashCode()));
                            sharedBuf.append('=');
                            sharedBuf.append(this.translateStateString(mcw.getStateString()));
                            if (mcw.isDestroyState() || mcw.isStale() || mcw.hasFatalErrorNotificationOccurred(this._pm.freePool[0].getFatalErrorNotificationTime()) || this._pm.agedTimeout != -1 && mcw.hasAgedTimedOut(this._pm.agedTimeoutMillis)) {
                                sharedBuf.append("ToBePurged");
                            }
                            sharedBuf.append(" thread=");
                            sharedBuf.append(mcw.getThreadID());
                            sharedBuf.append(" transaction=");
                            sharedBuf.append(mcw.getTranWrapperId());
                            sharedBuf.append(" connectionHandles=");
                            sharedBuf.append(mcw.mcwHandleList.size());
                            sharedBuf.append(this.nl);
                            continue block8;
                        }
                        case 3: {
                            ++numUnsharedConnections;
                            unsharedBuf.append(" ManagedConnection@");
                            unsharedBuf.append(Integer.toHexString(mcw.hashCode()));
                            unsharedBuf.append('=');
                            unsharedBuf.append(this.translateStateString(mcw.getStateString()));
                            if (mcw.isStale() || mcw.hasFatalErrorNotificationOccurred(this._pm.freePool[0].getFatalErrorNotificationTime()) || this._pm.agedTimeout != -1 && mcw.hasAgedTimedOut(this._pm.agedTimeoutMillis)) {
                                unsharedBuf.append("ToBePurged");
                            }
                            unsharedBuf.append(" thread=");
                            unsharedBuf.append(mcw.getThreadID());
                            unsharedBuf.append(this.nl);
                            continue block8;
                        }
                    }
                }
            }
        }
        finally {
            this._pm.mcToMCWMapWrite.unlock();
        }
        buf.append("waiting=" + this._pm.waiterCount);
        buf.append(this.nl);
        buf.append("unshared=");
        buf.append(numUnsharedConnections);
        buf.append(this.nl);
        if (numUnsharedConnections > 0) {
            buf.append(unsharedBuf);
        }
        buf.append("shared=");
        buf.append(numSharedConnections);
        buf.append(this.nl);
        if (numSharedConnections > 0) {
            buf.append(sharedBuf);
        }
        buf.append("available=");
        buf.append(numFreeConnections);
        buf.append(this.nl);
        if (numFreeConnections > 0) {
            buf.append(freeBuf);
        }
        return buf.toString();
    }

    private String translateStateString(String stateStr) {
        if (stateStr.equalsIgnoreCase("state_new")) {
            return "new";
        }
        if (stateStr.equalsIgnoreCase("state_active_free")) {
            return "Reusable";
        }
        if (stateStr.equalsIgnoreCase("state_active_inuse")) {
            return "ActiveInUse";
        }
        if (stateStr.equalsIgnoreCase("STATE_TRAN_WRAPPER_INUSE")) {
            return "ActiveInTransaction";
        }
        if (stateStr.equalsIgnoreCase("STATE_INACTIVE")) {
            return "Reusable";
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"MCWrapper.getStateString() returned an unknown state", (Object[])new Object[0]);
        }
        return "Unknown";
    }

    private String toObnString(String s) {
        return s.replace(':', '.').replace('=', '.').replace(',', '.').replace('\"', '.');
    }

    private boolean atLeastJDBCVersion(Version v) {
        return this.jdbcRuntimeVersion != null && this.jdbcRuntimeVersion.compareTo(v) >= 0;
    }

    @Override
    public void purgePoolContents(String doImmediately) throws MBeanException {
        try {
            this._pm.purgePoolContents(doImmediately);
        }
        catch (ResourceException e) {
            throw new MBeanException((Exception)((Object)e));
        }
    }

    @Override
    public String showPoolContents() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.toStringExternal());
        if (TraceComponent.isAnyTracingEnabled() && ConnLeakLogic.isEntryEnabled()) {
            buf.append(this.nl);
            buf.append("Extended ConnLeakLogic information");
            buf.append(this.nl);
            buf.append(this._pm.toString());
        }
        return buf.toString();
    }
}

