/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc.v43;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.jdbc.v43.WSJdbc43DataSource;
import java.sql.Connection;
import java.sql.ConnectionBuilder;
import java.sql.SQLException;
import java.sql.ShardingKey;

public class WSJdbc43ConnectionBuilder
implements ConnectionBuilder {
    private static final TraceComponent tc = Tr.register(WSJdbc43ConnectionBuilder.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private final WSJdbc43DataSource ds;
    String password;
    Object shardingKey;
    Object superShardingKey;
    String user;

    public WSJdbc43ConnectionBuilder(WSJdbc43DataSource ds) {
        this.ds = ds;
    }

    @Override
    public Connection build() throws SQLException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"build", (Object[])new Object[]{this.ds, this.user, this.password == null ? null : "******", this.shardingKey, this.superShardingKey});
        }
        return this.ds.getConnection(this);
    }

    @Override
    public ConnectionBuilder password(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"password", (Object[])new Object[]{value == null ? null : "***"});
        }
        this.password = value;
        return this;
    }

    @Override
    public ConnectionBuilder shardingKey(ShardingKey value) {
        if (value != null && this.ds.isBackedByDriver()) {
            throw new UnsupportedOperationException("java.sql.Driver.createConnectionBuilder().shardingKey(value)");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"shardingKey", (Object[])new Object[]{value});
        }
        this.shardingKey = value;
        return this;
    }

    @Override
    public ConnectionBuilder superShardingKey(ShardingKey value) {
        if (value != null && this.ds.isBackedByDriver()) {
            throw new UnsupportedOperationException("java.sql.Driver.createConnectionBuilder().superShardingKey(value)");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"superShardingKey", (Object[])new Object[]{value});
        }
        this.superShardingKey = value;
        return this;
    }

    @Override
    public ConnectionBuilder user(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"user", (Object[])new Object[]{value});
        }
        this.user = value;
        return this;
    }
}

