/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jdbc.DataSourceService;
import com.ibm.ws.resource.ResourceRefInfo;
import com.ibm.ws.rsadapter.jdbc.WSJdbcWrapper;
import com.ibm.wsspi.resource.ResourceInfo;
import java.io.Serializable;
import java.util.Collection;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class SerializedDataSourceWrapper
implements Serializable {
    private static final long serialVersionUID = -7663502167082261791L;
    private static final TraceComponent tc = Tr.register(SerializedDataSourceWrapper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private final String filter;
    private final Serializable resourceRefInfo;

    SerializedDataSourceWrapper(String filter, ResourceRefInfo resourceRefInfo) {
        this.filter = filter;
        this.resourceRefInfo = (Serializable)resourceRefInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object readResolve() throws Exception {
        Object dataSource;
        boolean trace;
        block9: {
            trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"readResolve", (Object[])new Object[]{this.filter, this.resourceRefInfo});
            }
            BundleContext bundleContext = WSJdbcWrapper.priv.getBundleContext(FrameworkUtil.getBundle(DataSourceService.class));
            ServiceReference dssvcRef = null;
            try {
                Collection srs = WSJdbcWrapper.priv.getServiceReferences(bundleContext, DataSourceService.class, this.filter);
                if (srs.isEmpty()) {
                    throw new IllegalStateException(this.filter);
                }
                dssvcRef = (ServiceReference)srs.iterator().next();
                DataSourceService dssvc = (DataSourceService)((Object)WSJdbcWrapper.priv.getService(bundleContext, dssvcRef));
                dataSource = dssvc.createResource((ResourceInfo)((ResourceRefInfo)this.resourceRefInfo));
                if (dssvcRef == null) break block9;
            }
            catch (Exception x) {
                try {
                    if (trace && tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"readResolve", (Object)x);
                    }
                    throw x;
                }
                catch (Throwable throwable) {
                    if (dssvcRef != null) {
                        bundleContext.ungetService(dssvcRef);
                    }
                    throw throwable;
                }
            }
            bundleContext.ungetService(dssvcRef);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"readResolve", (Object)dataSource);
        }
        return dataSource;
    }
}

