/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jdbc.osgi.JDBCRuntimeVersion;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.jdbc.WSJdbcWrapper;
import com.ibm.wsspi.uow.UOWManager;
import com.ibm.wsspi.uow.UOWManagerFactory;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class WSJdbcStatement
extends WSJdbcObject
implements Statement {
    private static final TraceComponent tc = Tr.register(WSJdbcStatement.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    static final Set<String> VENDOR_PROPERTY_SETTERS = new HashSet<String>();
    protected Statement stmtImpl;
    protected int currentFetchSize;
    int requestedFetchSize;
    protected boolean haveStatementPropertiesChanged;
    protected int holdability;
    protected boolean poolabilityHint;
    protected boolean hasBatchParameters;
    private Integer queryTimeoutBeforeSync;
    private boolean queryTimeoutSetByUser;
    protected boolean closeOnCompletion = false;

    public WSJdbcStatement() {
    }

    public WSJdbcStatement(Statement stmtImplObject, WSJdbcConnection connWrapper, int theHoldability) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{AdapterUtil.toString(stmtImplObject), connWrapper, AdapterUtil.getCursorHoldabilityString(theHoldability)});
        }
        this.stmtImpl = stmtImplObject;
        this.init(connWrapper);
        this.mcf = this.parentWrapper.mcf;
        this.holdability = theHoldability;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"addBatch", (Object[])new Object[]{sql});
        }
        try {
            this.stmtImpl.addBatch(sql);
        }
        catch (SQLException ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"addBatch", (Object[])new Object[]{ex});
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void cancel() throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"cancel", (Object[])new Object[0]);
        }
        try {
            this.stmtImpl.cancel();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.cancel", (String)"94", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"cancel", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"cancel", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"cancel");
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"clearBatch", (Object[])new Object[0]);
        }
        try {
            this.stmtImpl.clearBatch();
            this.hasBatchParameters = false;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.clearBatch", (String)"116", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.stmtImpl.clearWarnings();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.clearWarnings", (String)"136", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    protected final void closeAndRemoveResultSet() {
        this.closeAndRemoveResultSet(false);
    }

    protected final void closeAndRemoveResultSet(boolean closeWrapperOnly) {
        try {
            this.childWrapper.close(closeWrapperOnly);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.closeAndRemoveResultSet", (String)"275", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"ERR_CLOSING_OBJECT", (Object[])new Object[]{this.childWrapper, ex});
        }
        this.childWrapper = null;
    }

    protected final void closeAndRemoveResultSets() {
        this.closeAndRemoveResultSets(false);
    }

    protected final void closeAndRemoveResultSets(boolean closeWrapperOnly) {
        for (int i = this.childWrappers.size() - 1; i > -1; --i) {
            try {
                ((WSJdbcObject)this.childWrappers.get(i)).close(closeWrapperOnly);
                continue;
            }
            catch (SQLException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.closeAndRemoveResultSets", (String)"277", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"ERR_CLOSING_OBJECT", (Object[])new Object[]{ex});
            }
        }
    }

    @Override
    protected SQLException closeWrapper(boolean closeWrapperOnly) {
        block4: {
            try {
                this.parentWrapper.childWrappers.remove(this);
            }
            catch (RuntimeException runtimeX) {
                if (this.parentWrapper.state == WSJdbcWrapper.State.CLOSED) break block4;
                throw runtimeX;
            }
        }
        try {
            this.stmtImpl.close();
        }
        catch (SQLException closeX) {
            FFDCFilter.processException((Throwable)closeX, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.closeWrapper", (String)"314", (Object)this);
            this.stmtImpl = null;
            return WSJdbcUtil.mapException(this, closeX);
        }
        this.stmtImpl = null;
        return null;
    }

    protected WSJdbcResultSet createResultSetWrapper(ResultSet rsetImplObject) {
        return rsetImplObject == null ? null : this.mcf.jdbcRuntime.newResultSet(rsetImplObject, this);
    }

    protected final void enforceStatementProperties() throws SQLException {
        if (this.requestedFetchSize != this.currentFetchSize) {
            this.stmtImpl.setFetchSize(this.requestedFetchSize);
            this.currentFetchSize = this.requestedFetchSize;
        }
        if (((DSConfig)this.dsConfig.get()).syncQueryTimeoutWithTransactionTimeout && !this.queryTimeoutSetByUser) {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (((WSJdbcConnection)this.parentWrapper).managedConn.isGlobalTransactionActive()) {
                UOWManager uowmgr = UOWManagerFactory.getUOWManager();
                long expireTime = uowmgr.getUOWExpiration();
                if (expireTime != 0L) {
                    long remainingTime = expireTime - System.currentTimeMillis();
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Milliseconds remaining in transaction timeout: " + remainingTime), (Object[])new Object[0]);
                    }
                    if (remainingTime <= 0L) {
                        throw new SQLTimeoutException("Transaction timeout " + -remainingTime + " ms ago.", "25000");
                    }
                    remainingTime = (remainingTime + 999L) / 1000L;
                    if (this.queryTimeoutBeforeSync == null) {
                        this.queryTimeoutBeforeSync = this.stmtImpl.getQueryTimeout();
                    }
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Setting query timeout to " + remainingTime), (Object[])new Object[0]);
                    }
                    this.stmtImpl.setQueryTimeout((int)remainingTime);
                    this.haveStatementPropertiesChanged = true;
                } else if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Transaction has no timeout set", (Object[])new Object[0]);
                }
            } else if (this.queryTimeoutBeforeSync != null) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Restoring query timeout to " + this.queryTimeoutBeforeSync), (Object[])new Object[0]);
                }
                this.stmtImpl.setQueryTimeout(this.queryTimeoutBeforeSync);
                this.queryTimeoutBeforeSync = null;
            }
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean result;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"execute", (Object[])new Object[]{sql});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            result = this.stmtImpl.execute(sql);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"execute", (Object)ex);
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"execute", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"execute", (Object)(result ? "QUERY" : "UPDATE"));
        }
        return result;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] results;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"executeBatch", (Object[])new Object[0]);
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            results = this.stmtImpl.executeBatch();
            this.hasBatchParameters = false;
        }
        catch (BatchUpdateException batchX) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Check for Connection Error", (Object[])new Object[]{AdapterUtil.getStackTraceWithState(batchX)});
            }
            try {
                WSJdbcConnection connWrapper = (WSJdbcConnection)this.parentWrapper;
                if (this.mcf.getHelper().isConnectionError(batchX)) {
                    if (tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)"Encountered a Stale Connection: ", (Object[])new Object[]{connWrapper});
                    }
                    connWrapper.fireConnectionErrorEvent(batchX, true);
                }
            }
            catch (NullPointerException nullX) {
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"executeBatch", (Object)"Exception");
                }
                throw this.runtimeXIfNotClosed(nullX);
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeBatch", (Object)"Exception");
            }
            throw batchX;
        }
        catch (SQLException sqlX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeBatch", (Object)sqlX);
            }
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeBatch", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"executeBatch", (Object)Arrays.toString(results));
        }
        return results;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"executeQuery", (Object[])new Object[]{sql});
        }
        WSJdbcResultSet rsetWrapper = null;
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            rsetWrapper = this.createResultSetWrapper(this.stmtImpl.executeQuery(sql));
            this.childWrapper = rsetWrapper;
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeQuery", (Object)ex);
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeQuery", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        rsetWrapper.sql = sql;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"executeQuery", (Object)this.childWrapper);
        }
        return rsetWrapper;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        int numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object[])new Object[]{sql});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.stmtImpl.executeUpdate(sql);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object)ex);
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }

    @Override
    public final Connection getConnection() throws SQLException {
        Connection conn = (Connection)((Object)this.parentWrapper);
        if (this.state == WSJdbcWrapper.State.CLOSED || conn == null) {
            throw this.createClosedException("Statement");
        }
        return conn;
    }

    @Override
    protected final WSJdbcObject getConnectionWrapper() {
        return this.parentWrapper;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this.stmtImpl.getFetchDirection();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getFetchDirection", (String)"551", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public final int getFetchSize() throws SQLException {
        if (this.state == WSJdbcWrapper.State.CLOSED) {
            throw this.createClosedException("Statement");
        }
        return this.requestedFetchSize;
    }

    @Override
    protected final Wrapper getJDBCImplObject() {
        return this.stmtImpl;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            return this.stmtImpl.getMaxFieldSize();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getMaxFieldSize", (String)"591", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            return this.stmtImpl.getMaxRows();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getMaxRows", (String)"611", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        boolean hasMoreResults;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getMoreResults", (Object[])new Object[0]);
        }
        boolean deferCloseOnCompletion = this.closeOnCompletion;
        this.closeOnCompletion = false;
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet(true);
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets(true);
            }
            hasMoreResults = this.stmtImpl.getMoreResults();
            if (deferCloseOnCompletion && !hasMoreResults && this.mcf.getHelper().getUpdateCount(this) == -1L) {
                this.close();
            }
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getMoreResults", (String)"655", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getMoreResults", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getMoreResults", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        finally {
            this.closeOnCompletion = deferCloseOnCompletion;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getMoreResults", (Object)(hasMoreResults ? Boolean.TRUE : Boolean.FALSE));
        }
        return hasMoreResults;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            return this.stmtImpl.getQueryTimeout();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getQueryTimeout", (String)"675", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        WSJdbcResultSet rsetWrapper;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getResultSet", (Object[])new Object[0]);
        }
        try {
            ResultSet rsetImpl = this.stmtImpl.getResultSet();
            if (rsetImpl == null) {
                rsetWrapper = null;
            } else if (this.childWrapper == null && (this.childWrappers == null || this.childWrappers.isEmpty())) {
                rsetWrapper = this.createResultSetWrapper(rsetImpl);
                this.childWrapper = rsetWrapper;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Set the result set to child wrapper", (Object[])new Object[0]);
                }
            } else {
                if (this.childWrappers == null) {
                    this.childWrappers = new ArrayList(5);
                }
                rsetWrapper = this.createResultSetWrapper(rsetImpl);
                this.childWrappers.add(rsetWrapper);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Add the result set to child wrappers list.", (Object[])new Object[0]);
                }
            }
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getResultSet", (String)"717", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getResultSet", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getResultSet", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getResultSet", (Object)rsetWrapper);
        }
        return rsetWrapper;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.stmtImpl.getResultSetConcurrency();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getResultSetConcurrency", (String)"737", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            return this.stmtImpl.getResultSetType();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getResultSetType", (String)"757", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    protected TraceComponent getTracer() {
        return tc;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        int updateCount;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getUpdateCount", (Object[])new Object[0]);
        }
        try {
            updateCount = this.stmtImpl.getUpdateCount();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getUpdateCount", (String)"800", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getUpdateCount", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getUpdateCount", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getUpdateCount", (Object)updateCount);
        }
        return updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.stmtImpl.getWarnings();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getWarnings", (String)"820", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    protected void introspectWrapperSpecificInfo(FFDCLogger info) {
        info.append("Underlying Statement: " + AdapterUtil.toString(this.stmtImpl), this.stmtImpl);
        info.append("Statement properties have changed? " + this.haveStatementPropertiesChanged);
        info.append("Poolability hint: " + (this.poolabilityHint ? "POOLABLE" : "NOT POOLABLE"));
    }

    @Override
    public final boolean isPoolable() throws SQLException {
        if (this.state == WSJdbcWrapper.State.CLOSED) {
            throw this.createClosedException("Statement");
        }
        return this.poolabilityHint;
    }

    @Override
    protected final RuntimeException runtimeXIfNotClosed(RuntimeException runtimeX) throws SQLException {
        if (this.state == WSJdbcWrapper.State.CLOSED) {
            throw this.createClosedException("Statement");
        }
        return runtimeX;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setCursorName", (Object[])new Object[]{name});
        }
        try {
            this.stmtImpl.setCursorName(name);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.setCursorName", (String)"840", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        this.haveStatementPropertiesChanged = true;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setEscapeProcessing", (Object[])new Object[]{enable});
        }
        try {
            this.stmtImpl.setEscapeProcessing(enable);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.setEscapeProcessing", (String)"860", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setFetchDirection", (Object[])new Object[]{AdapterUtil.getFetchDirectionString(direction)});
        }
        try {
            this.stmtImpl.setFetchDirection(direction);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.setFetchDirection", (String)"880", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        this.haveStatementPropertiesChanged = true;
    }

    @Override
    public final void setFetchSize(int rows) throws SQLException {
        if (this.state == WSJdbcWrapper.State.CLOSED || rows < 0) {
            if (this.state == WSJdbcWrapper.State.CLOSED) {
                throw this.createClosedException("Statement");
            }
            if (rows < 0) {
                throw new SQLDataException(AdapterUtil.getNLSMessage("NO_NEGATIVE_FETCH_SIZES"), "22003", null);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("requested fetchSize --> " + rows), (Object[])new Object[0]);
        }
        this.requestedFetchSize = rows;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setMaxFieldSize", (Object[])new Object[]{max});
        }
        try {
            this.stmtImpl.setMaxFieldSize(max);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.setMaxFieldSize", (String)"920", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        this.haveStatementPropertiesChanged = true;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setMaxRows", (Object[])new Object[]{max});
        }
        try {
            this.stmtImpl.setMaxRows(max);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.setMaxRows", (String)"940", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        this.haveStatementPropertiesChanged = true;
    }

    @Override
    public void setPoolable(boolean isPoolable) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"setPoolable", (Object[])new Object[]{isPoolable});
        }
        if (this.state == WSJdbcWrapper.State.CLOSED) {
            SQLException closedX = this.createClosedException("Statement");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"setPoolable", (Object)closedX);
            }
            throw closedX;
        }
        try {
            if (this.mcf.jdbcDriverSpecVersion >= 40) {
                this.stmtImpl.setPoolable(isPoolable);
            }
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setPoolable"), (String)"1733", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"setPoolable", (Object)sqlX);
            }
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setPoolable"), (String)"1708", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"setPoolable", (Object)runX);
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setPoolable"), (String)"1715", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"setPoolable", (Object)err);
            }
            throw err;
        }
        this.poolabilityHint = isPoolable;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"setPoolable");
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setQueryTimeout", (Object[])new Object[]{seconds});
        }
        try {
            this.stmtImpl.setQueryTimeout(seconds);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.setQueryTimeout", (String)"960", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        this.queryTimeoutSetByUser = true;
        this.haveStatementPropertiesChanged = true;
    }

    void closeResultSetsIfNecessary() {
        if (this.holdability == 2) {
            this.closeChildWrappers();
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getMoreResults", (Object[])new Object[]{AdapterUtil.getResultSetCloseString(current)});
        }
        boolean hasMoreResults = false;
        boolean deferCloseOnCompletion = this.closeOnCompletion;
        this.closeOnCompletion = false;
        try {
            switch (current) {
                case 3: {
                    if (this.childWrapper != null) {
                        this.closeAndRemoveResultSet(true);
                    }
                    if (this.childWrappers == null || this.childWrappers.isEmpty()) break;
                    this.closeAndRemoveResultSets(true);
                    break;
                }
                case 1: {
                    if (this.childWrappers == null || this.childWrappers.isEmpty()) {
                        if (this.childWrapper == null) break;
                        this.closeAndRemoveResultSet(true);
                        break;
                    }
                    ((WSJdbcResultSet)this.childWrappers.get(this.childWrappers.size() - 1)).close(true);
                    break;
                }
            }
            hasMoreResults = this.stmtImpl.getMoreResults(current);
            if (deferCloseOnCompletion && !hasMoreResults && 2 != current && this.mcf.getHelper().getUpdateCount(this) == -1L) {
                this.close();
            }
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getMoreResults(int)", (String)"1280", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getMoreResults", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getMoreResults", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        finally {
            this.closeOnCompletion = deferCloseOnCompletion;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getMoreResults", (Object)(hasMoreResults ? Boolean.TRUE : Boolean.FALSE));
        }
        return hasMoreResults;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getGeneratedKeys", (Object[])new Object[0]);
        }
        ResultSet rsetImpl = null;
        WSJdbcResultSet rsetWrapper = null;
        try {
            rsetImpl = this.stmtImpl.getGeneratedKeys();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getGeneratedKeys", (String)"1138", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getGeneratedKeys", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getGeneratedKeys", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (this.childWrapper == null && (this.childWrappers == null || this.childWrappers.isEmpty())) {
            rsetWrapper = this.createResultSetWrapper(rsetImpl);
            this.childWrapper = rsetWrapper;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Set the result set to child wrapper", (Object[])new Object[0]);
            }
        } else {
            if (this.childWrappers == null) {
                this.childWrappers = new ArrayList(5);
            }
            rsetWrapper = this.createResultSetWrapper(rsetImpl);
            this.childWrappers.add(rsetWrapper);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Add the result set to child wrappers list.", (Object[])new Object[0]);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getGeneratedKeys", (Object)rsetWrapper);
        }
        return rsetWrapper;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object[])new Object[]{sql, AdapterUtil.getAutoGeneratedKeyString(autoGeneratedKeys)});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.stmtImpl.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object)ex);
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object[])new Object[]{sql, Arrays.toString(columnIndexes)});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.stmtImpl.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object)ex);
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        int numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object[])new Object[]{sql, Arrays.toString(columnNames)});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.stmtImpl.executeUpdate(sql, columnNames);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object)ex);
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean result;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"execute", (Object[])new Object[]{sql, AdapterUtil.getAutoGeneratedKeyString(autoGeneratedKeys)});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            result = this.stmtImpl.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"execute", (Object)ex);
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"execute", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"execute", (Object)(result ? "QUERY" : "UPDATE"));
        }
        return result;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean result;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"execute", (Object[])new Object[]{sql, Arrays.toString(columnIndexes)});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            result = this.stmtImpl.execute(sql, columnIndexes);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"execute", (Object)ex);
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"execute", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"execute", (Object)(result ? "QUERY" : "UPDATE"));
        }
        return result;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean result;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"execute", (Object[])new Object[]{sql, Arrays.toString(columnNames)});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            result = this.stmtImpl.execute(sql, columnNames);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"execute", (Object)ex);
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"execute", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"execute", (Object)(result ? "QUERY" : "UPDATE"));
        }
        return result;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this.stmtImpl.getResultSetHoldability();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getResultSetHoldability", (String)"1770", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        if (this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            throw new SQLFeatureNotSupportedException();
        }
        if (this.isClosed()) {
            SQLException sqle = this.createClosedException("Statement");
            FFDCFilter.processException((Throwable)sqle, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement41.closeOnCompletion", (String)"45", (Object)this);
            throw sqle;
        }
        if (this.closeOnCompletion) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"closeOnCompletion enabled", (Object[])new Object[0]);
        }
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        if (this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            throw new SQLFeatureNotSupportedException();
        }
        if (this.isClosed()) {
            SQLException sqle = this.createClosedException("Statement");
            FFDCFilter.processException((Throwable)sqle, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement41.isCloseOnCompletion", (String)"62", (Object)this);
            throw sqle;
        }
        return this.closeOnCompletion;
    }

    public long getCompatibleUpdateCount() throws SQLException {
        return this.stmtImpl.getUpdateCount();
    }

    static {
        VENDOR_PROPERTY_SETTERS.add("setLongDataCacheSize");
        VENDOR_PROPERTY_SETTERS.add("setResponseBuffering");
        VENDOR_PROPERTY_SETTERS.add("setLobPrefetchSize");
        VENDOR_PROPERTY_SETTERS.add("defineColumnType");
        VENDOR_PROPERTY_SETTERS.add("defineColumnTypeBytes");
        VENDOR_PROPERTY_SETTERS.add("defineColumnTypeChars");
        VENDOR_PROPERTY_SETTERS.add("setExecuteBatch");
        VENDOR_PROPERTY_SETTERS.add("setRowPrefetch");
    }
}

