/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jdbc.internal.PropertyService;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

public class WSJdbcTracer
implements InvocationHandler {
    static final Set<String> METHODS_TO_SKIP = new HashSet<String>();
    public static final Set<Class<?>> TRACEABLE_TYPES;
    TraceComponent tracer;
    PrintWriter writer;
    Object impl;
    String traceID;
    String sql;

    public WSJdbcTracer(TraceComponent tracer, PrintWriter writer, Object impl, Class<?> ifc, String sql, boolean introspect) {
        this.tracer = tracer;
        this.writer = writer;
        this.impl = impl;
        this.sql = sql;
        this.traceID = ifc.getSimpleName() + Integer.toHexString(System.identityHashCode(impl));
        if (introspect) {
            this.traceConfig();
        }
    }

    public static final Object getImpl(Object obj) {
        InvocationHandler handler;
        return Proxy.isProxyClass(obj.getClass()) && (handler = Proxy.getInvocationHandler(obj)) instanceof WSJdbcTracer ? ((WSJdbcTracer)handler).impl : obj;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        StringBuilder buffer;
        String methName = method.getName();
        if (METHODS_TO_SKIP.contains(methName)) {
            try {
                return method.invoke(this.impl, args);
            }
            catch (InvocationTargetException x) {
                throw x.getCause();
            }
        }
        Object traceableResult = null;
        if (TraceComponent.isAnyTracingEnabled() && this.tracer.isDebugEnabled()) {
            boolean hasPassword = methName.equals("getPooledConnection") || methName.equals("getXAConnection") || methName.equals("connect");
            buffer = new StringBuilder(120);
            buffer.append("==> ").append(this.traceID).append('.').append(methName).append('(');
            if (this.tracer.getLevel() <= 1 && args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (methName.equals("connect") && i == 0) {
                        buffer.append(PropertyService.filterURL(this.toString(args[i])));
                        continue;
                    }
                    if (i != 0) {
                        buffer.append(", ");
                    }
                    buffer.append(hasPassword && i == 1 ? "***" : this.toString(args[i]));
                }
            }
            buffer.append(");");
            if (this.sql != null && methName.startsWith("execute")) {
                buffer.append(" // ").append(this.sql);
            }
            this.writer.println(new String(buffer));
        }
        try {
            result = method.invoke(this.impl, args);
        }
        catch (InvocationTargetException x) {
            if (TraceComponent.isAnyTracingEnabled() && this.tracer.isDebugEnabled()) {
                buffer = new StringBuilder(800);
                buffer.append("<== ").append(this.toString(x.getCause()));
                this.writer.println(new String(buffer));
            }
            throw x.getCause();
        }
        boolean isUnwrap = methName.equals("unwrap");
        if (result != null && (isUnwrap || TRACEABLE_TYPES.contains(method.getReturnType()))) {
            final Class returnType = isUnwrap ? (Class)args[0] : method.getReturnType();
            String query = methName.startsWith("prepare") && PreparedStatement.class.isAssignableFrom(returnType) && args.length >= 1 && args[0] instanceof String ? (String)args[0] : null;
            final WSJdbcTracer newTracer = new WSJdbcTracer(this.tracer, this.writer, result, returnType, query, false);
            traceableResult = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return Proxy.newProxyInstance(returnType.getClassLoader(), new Class[]{returnType}, (InvocationHandler)newTracer);
                }
            });
        }
        if (TraceComponent.isAnyTracingEnabled() && this.tracer.isDebugEnabled()) {
            buffer = new StringBuilder(40);
            buffer.append("<== ");
            if (Void.TYPE.equals(method.getReturnType())) {
                buffer.append(methName);
            } else if (traceableResult != null) {
                buffer.append(method.getReturnType().getSimpleName()).append(Integer.toHexString(System.identityHashCode(result)));
            } else if (this.tracer.getLevel() <= 1) {
                buffer.append(this.toString(result));
            }
            this.writer.println(new String(buffer));
        }
        return traceableResult == null ? result : traceableResult;
    }

    private String toString(Object obj) {
        if (obj instanceof String) {
            byte[] bytes;
            String str = (String)obj;
            StringBuilder sb = new StringBuilder(str.length()).append('\"');
            try {
                bytes = str.getBytes("UTF-16BE");
            }
            catch (UnsupportedEncodingException x) {
                return new String(sb.append(str).append('\"'));
            }
            for (int i = 0; i < bytes.length; i += 2) {
                if (bytes[i] == 0 && (bytes[i + 1] & 0x80) == 0) {
                    sb.append((char)bytes[i + 1]);
                    continue;
                }
                sb.append("\\u").append(Integer.toHexString(bytes[i] >> 4 & 0xF)).append(Integer.toHexString(bytes[i] & 0xF)).append(Integer.toHexString(bytes[i + 1] >> 4 & 0xF)).append(Integer.toHexString(bytes[i + 1] & 0xF));
            }
            return new String(sb.append('\"'));
        }
        if (obj instanceof Long) {
            return obj.toString() + 'l';
        }
        if (obj instanceof Float) {
            return obj.toString() + 'f';
        }
        if (obj instanceof Byte) {
            return "(byte)" + obj.toString();
        }
        if (obj instanceof Short) {
            return "(short)" + obj.toString();
        }
        if (obj instanceof Date) {
            return "new java.sql.Date(" + ((Date)obj).getTime() + "l)";
        }
        if (obj instanceof Time) {
            return "new java.sql.Time(" + ((Time)obj).getTime() + "l)";
        }
        if (obj instanceof Timestamp) {
            return "new java.sql.Timestamp(" + ((Timestamp)obj).getTime() + "l)";
        }
        if (obj instanceof URL) {
            return "new java.net.URL(\"" + obj.toString() + "\")";
        }
        if (obj instanceof BigDecimal) {
            return "new java.math.BigDecimal(\"" + obj.toString() + "\")";
        }
        if (obj instanceof Throwable) {
            StringWriter out = new StringWriter();
            ((Throwable)obj).printStackTrace(new PrintWriter(out));
            return out.toString();
        }
        if (obj != null && obj.getClass().isArray()) {
            int length = Array.getLength(obj);
            StringBuilder buffer = new StringBuilder(120);
            buffer.append(obj.getClass().getComponentType().getSimpleName());
            buffer.append('[').append(length).append("] {");
            if (length < 20) {
                for (int i = 0; i < length; ++i) {
                    buffer.append(i == 0 ? " " : ", ").append(Array.get(obj, i));
                }
            } else {
                buffer.append(" ...");
            }
            buffer.append(" }");
            return new String(buffer);
        }
        return obj == null ? null : obj.toString();
    }

    private void traceConfig() {
        this.writer.println(new StringBuilder(180).append(this.impl.getClass().getName()).append(' ').append(this.traceID).append(" = new ").append(this.impl.getClass().getName()).append("();").toString());
        try {
            PropertyDescriptor[] props = Introspector.getBeanInfo(this.impl.getClass()).getPropertyDescriptors();
            for (int i = 0; i < props.length; ++i) {
                Method writeMeth;
                Method readMeth = props[i].getReadMethod();
                if (readMeth == null || (writeMeth = props[i].getWriteMethod()) == null) continue;
                StringBuilder buffer = new StringBuilder(60);
                buffer.append(this.traceID).append('.').append(writeMeth.getName()).append('(');
                if (!"password".equals(props[i].getName())) {
                    try {
                        buffer.append(this.toString(readMeth.invoke(this.impl, (Object[])null)));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                buffer.append(");");
                this.writer.println(new String(buffer));
            }
        }
        catch (IntrospectionException introspectX) {
            this.writer.println("Unable to read the configuration for " + this.traceID);
            introspectX.printStackTrace(this.writer);
        }
    }

    static {
        METHODS_TO_SKIP.add("equals");
        METHODS_TO_SKIP.add("hashCode");
        METHODS_TO_SKIP.add("toString");
        TRACEABLE_TYPES = new HashSet();
        TRACEABLE_TYPES.add(CallableStatement.class);
        TRACEABLE_TYPES.add(Connection.class);
        TRACEABLE_TYPES.add(ConnectionPoolDataSource.class);
        TRACEABLE_TYPES.add(DatabaseMetaData.class);
        TRACEABLE_TYPES.add(DataSource.class);
        TRACEABLE_TYPES.add(PooledConnection.class);
        TRACEABLE_TYPES.add(PreparedStatement.class);
        TRACEABLE_TYPES.add(ResultSet.class);
        TRACEABLE_TYPES.add(Statement.class);
        TRACEABLE_TYPES.add(XAConnection.class);
        TRACEABLE_TYPES.add(XADataSource.class);
        TRACEABLE_TYPES.add(XAResource.class);
    }
}

