/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.persistence.pdq;

import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenerator;
import com.ibm.ws.persistence.pdqstatic.meta.PDQMetaXMLHandler;
import com.ibm.ws.persistence.pdqstatic.meta.PDQMetas;
import java.util.HashMap;
import java.util.List;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;

public class WsJpaDBGen {
    private static final Localizer _loc = Localizer.forPackage(WsJpaDBGen.class);
    static String _puName = null;
    static String _collection = null;
    static String _url = null;
    static String _user = null;
    static String _pw = null;
    static boolean _singlePackage = false;
    static String _packageName = null;
    static String _outputDir = null;

    public static void main(String[] args) throws Exception {
        WsJpaDBGen.generate(args);
    }

    public static boolean generate(String[] args) throws Exception {
        return WsJpaDBGen.generate(args, null);
    }

    public static boolean generate(String[] args, ClassLoader loader) throws Exception {
        WsJpaDBGen.validateInput(args);
        System.err.println(_loc.get("wsdbgen-start") + " " + _puName + "...");
        boolean noErr = WsJpaDBGen.generateSQL(loader);
        System.err.println(_loc.get("wsdbgen-finish"));
        return noErr;
    }

    private static void validateInput(String[] args) {
        int i = 0;
        HashMap<String, String> parms = new HashMap<String, String>();
        do {
            String name;
            if (args.length == 0) {
                WsJpaDBGen.printUsageAndExit();
            }
            if (!args[i].startsWith("-")) {
                WsJpaDBGen.printUsageAndExit();
            }
            if ((name = args[i++].substring(1)).equals("help")) {
                WsJpaDBGen.printUsageAndExit();
            }
            if (args.length % 2 != 0) {
                WsJpaDBGen.printUsageAndExit();
            }
            if (args[i].startsWith("-")) {
                WsJpaDBGen.printUsageAndExit();
            }
            String value = args[i++];
            parms.put(name, value);
        } while (i != args.length);
        _collection = (String)parms.get("collection");
        if (_collection == null) {
            _collection = "NULLID";
        }
        _url = (String)parms.get("url");
        _user = (String)parms.get("user");
        _pw = (String)parms.get("pw");
        _packageName = (String)parms.get("package");
        if (_packageName != null) {
            _singlePackage = true;
        }
        if ((_puName = (String)parms.get("pu")) == null) {
            System.out.println(_loc.get("wsdbgen-puname-req"));
            WsJpaDBGen.printUsageAndExit();
        }
        _outputDir = (String)parms.get("outputDir");
    }

    private static boolean generateSQL(ClassLoader loader) throws Exception {
        StaticSQLGenerator sqlGen = new StaticSQLGenerator(_puName, _collection, _url, _user, _pw, _singlePackage, _packageName);
        sqlGen.generateSQL();
        PDQMetas metas = sqlGen.getPDQMetas();
        Log _logs = sqlGen.getLog();
        try {
            String xmlFileName = PDQMetaXMLHandler.generatePDQMetaXML(metas, _puName, loader, _outputDir);
            if (_logs.isTraceEnabled()) {
                _logs.trace((Object)_loc.get("total-sql", new Object[]{metas.getCount(), xmlFileName}));
            }
        }
        catch (Exception e) {
            if (_logs.isTraceEnabled()) {
                _logs.trace((Object)_loc.get("total-sql", new Object[]{metas.getCount(), "null"}));
            }
            throw e;
        }
        if (_logs.isTraceEnabled()) {
            List<String> errs = sqlGen.checkMisplacedSQL();
            if (errs.size() > 0) {
                for (String err : errs) {
                    _logs.trace((Object)err);
                }
            }
            return false;
        }
        return true;
    }

    private static void printUsageAndExit() {
        String nl = "\n";
        String tb = "\t";
        System.out.println(_loc.get("wsdbgen-syntax", (Object)"wsdb2gen -pu <puName>", (Object)"wsdbgen -pu <puName>"));
        System.out.println(nl + _loc.get("wsdbgen-desc1", (Object)"puName", (Object)"persistence.xml"));
        System.out.println(_loc.get("wsdbgen-desc2", (Object)"puName", (Object)"persistence.xml"));
        System.out.println(nl + _loc.get("wsdbgen-puname", (Object)"puName", (Object)"persistence.xml"));
        System.out.println(nl + _loc.get("wsdbgen-options"));
        System.out.println(nl + "-collection " + _loc.get("collection-option-value"));
        System.out.println(tb + _loc.get("collection-option-desc"));
        System.out.println(nl + "-url " + _loc.get("url-option-value"));
        System.out.println(tb + _loc.get("url-option-desc1"));
        System.out.println(tb + _loc.get("url-option-desc2"));
        System.out.println(tb + _loc.get("url-option-desc3"));
        System.out.println(tb + _loc.get("url-option-desc4"));
        System.out.println(nl + "-user " + _loc.get("user-option-value"));
        System.out.println(tb + _loc.get("user-option-desc1"));
        System.out.println(tb + _loc.get("user-option-desc2"));
        System.out.println(nl + "-pw " + _loc.get("pw-option-value"));
        System.out.println(tb + _loc.get("pw-option-desc1"));
        System.out.println(tb + _loc.get("pw-option-desc2"));
        System.out.println(nl + "-package " + _loc.get("package-option-value"));
        System.out.println(tb + _loc.get("package-option-desc1"));
        System.out.println(tb + _loc.get("package-option-desc2"));
        System.out.println(tb + _loc.get("package-option-desc3"));
        System.out.println(nl + "-help ");
        System.out.println(tb + _loc.get("help-option-desc1"));
        System.exit(1);
    }

    public static void run(String[] args, ClassLoader loader) throws Exception {
        WsJpaDBGen.generate(args, loader);
    }
}

