/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence;

import com.ibm.websphere.persistence.WsJpaEntityManagerFactory;
import com.ibm.ws.persistence.EntityManagerFactoryImpl;
import com.ibm.ws.persistence.QueryImpl;
import com.ibm.ws.persistence.ReadOnlyQueryImpl;
import com.ibm.ws.persistence.WsJpaEntityManager;
import com.ibm.ws.persistence.WsJpaQuery;
import com.ibm.ws.persistence.fastpath.FastPathManager;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import com.ibm.ws.persistence.kernel.WsJpaBrokerImpl;
import com.ibm.ws.persistence.objectcache.ObjectCacheManager;
import com.ibm.ws.persistence.objectcache.ReadOnlyQueryResultsCache;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.QueryMetaData;

public class EntityManagerImpl
extends org.apache.openjpa.persistence.EntityManagerImpl
implements com.ibm.websphere.persistence.WsJpaEntityManager,
WsJpaEntityManager {
    private transient MetaDataRepository _mdr;
    private transient ReadOnlyQueryResultsCache _qc;
    private transient EntityManagerFactory _pool;
    private transient FastPathManager _fpm;

    public EntityManagerImpl() {
    }

    public EntityManagerImpl(EntityManagerFactoryImpl factory, Broker broker) {
        super((org.apache.openjpa.persistence.EntityManagerFactoryImpl)factory, broker);
        WsJpaJDBCConfiguration wconf;
        ObjectCacheManager ocm;
        OpenJPAConfiguration conf = this.getConfiguration();
        this._mdr = conf.getMetaDataRepositoryInstance();
        if (conf instanceof WsJpaJDBCConfiguration && (ocm = (wconf = (WsJpaJDBCConfiguration)conf).getObjectCacheManagerInstance(broker.getBrokerFactory())) != null) {
            this._qc = ocm.getQueryCache();
        }
        if (broker instanceof WsJpaBrokerImpl) {
            this._fpm = ((WsJpaBrokerImpl)broker).getFastPathManager();
            if (this._fpm != null) {
                this._fpm.setFetchPlan(this.getFetchPlan());
            }
        }
        this.getBroker().putUserObject((Object)EntityManagerFactoryImpl.POOLED_EMF_KEY, (Object)this.getEntityManagerFactory());
    }

    @Override
    public WsJpaQuery createNamedQuery(String name) {
        QueryMetaData qmd;
        if (this._qc != null && this._qc.isCachable(qmd = this._mdr.getQueryMetaData(null, name, null, true))) {
            return new ReadOnlyQueryImpl(name, this, this._qc, qmd);
        }
        return (WsJpaQuery)super.createNamedQuery(name);
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        QueryMetaData qmd;
        if (this._qc != null && this._qc.isCachable(qmd = this._mdr.getQueryMetaData(resultClass, name, null, true))) {
            return new ReadOnlyQueryImpl(name, this, this._qc, qmd).setResultClass(resultClass);
        }
        return super.createNamedQuery(name, resultClass);
    }

    @Override
    public WsJpaQuery createQuery(String query) {
        return this.createQuery("javax.persistence.JPQL", query);
    }

    @Override
    public WsJpaQuery createQuery(String language, String query) {
        return (WsJpaQuery)super.createQuery(language, query);
    }

    @Override
    public WsJpaQuery createQuery(Query query) {
        if (query == null) {
            return this.createQuery((String)null);
        }
        this.assertNotCloseInvoked();
        if (query instanceof QueryImpl) {
            org.apache.openjpa.kernel.Query q = ((QueryImpl)query).getDelegate();
            return this.newQueryImpl(this.getBroker().newQuery(q.getLanguage(), (Object)q), null);
        }
        return null;
    }

    @Override
    public WsJpaQuery createNativeQuery(String query, String mappingName) {
        return (WsJpaQuery)super.createNativeQuery(query, mappingName);
    }

    @Override
    public WsJpaQuery createNativeQuery(String query) {
        this.validateSQL(query);
        return this.createQuery("openjpa.SQL", query);
    }

    @Override
    public WsJpaQuery createNativeQuery(String query, Class cls) {
        WsJpaQuery q = this.createNativeQuery(query);
        q.setResultClass(cls);
        return q;
    }

    protected <X> QueryImpl<X> newQueryImpl(org.apache.openjpa.kernel.Query kernelQuery, QueryMetaData qmd) {
        return new QueryImpl(this, this._ret, kernelQuery, qmd, this._fpm);
    }

    @Override
    public WsJpaEntityManagerFactory getEntityManagerFactory() {
        return (WsJpaEntityManagerFactory)super.getEntityManagerFactory();
    }

    WsJpaQuery createNamedQuery(String name, boolean cacheable) {
        if (!cacheable) {
            return (WsJpaQuery)super.createNamedQuery(name);
        }
        return this.createNamedQuery(name);
    }

    <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass, boolean cachable) {
        if (!cachable) {
            return super.createNamedQuery(name, resultClass);
        }
        return this.createNamedQuery(name, resultClass);
    }

    public void setPooledFactory(EntityManagerFactory pool) {
        this._pool = pool;
        this.getBroker().putUserObject((Object)EntityManagerFactoryImpl.POOLED_EMF_KEY, (Object)this._pool);
    }

    public EntityManagerFactory getPooledFactory() {
        return this._pool;
    }
}

