/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence;

import com.ibm.ws.persistence.WsJpaQuery;
import com.ibm.ws.persistence.fastpath.FastPathManager;
import java.util.List;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.util.RuntimeExceptionTranslator;

public class QueryImpl<X>
extends org.apache.openjpa.persistence.QueryImpl<X>
implements WsJpaQuery<X> {
    private static final long serialVersionUID = -3659209484873473609L;
    private static final Localizer _loc = Localizer.forPackage(org.apache.openjpa.persistence.QueryImpl.class);
    private FastPathManager _fpm;

    public QueryImpl(EntityManagerImpl em, RuntimeExceptionTranslator ret, Query query, QueryMetaData qmd, FastPathManager fpm) {
        super(em, ret, query, qmd);
        this._fpm = fpm;
    }

    public OpenJPAQuery<X> setHint(String key, Object value) {
        if (key == null || !key.startsWith("openjpa.") && !key.startsWith("wsjpa.") && !key.startsWith("javax.persistence.")) {
            return this;
        }
        if (key.startsWith("openjpa.") || key.startsWith("javax.persistence.")) {
            return super.setHint(key, value);
        }
        String k = key.substring("wsjpa.".length());
        try {
            if (k.equals("MaxResultSets")) {
                if (value instanceof String) {
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!(value instanceof Integer) || (Integer)value < 0) {
                    throw new ArgumentException(_loc.get("bad-query-hint-value", (Object)key, value), null, null, false);
                }
            } else {
                throw new ArgumentException(_loc.get("bad-query-hint", (Object)key), null, null, false);
            }
            this.setMaxResults((Integer)value);
            return this;
        }
        catch (RuntimeException e) {
            throw PersistenceExceptions.toPersistenceException((Throwable)e);
        }
    }

    public List getResultList() {
        if (this._fpm != null && this._qmd != null && this._fpm.isFastPathEligibleAndNotCurrentlyGenerating(this._qmd)) {
            return this._fpm.queryGetResultList(this, this._qmd);
        }
        return super.getResultList();
    }
}

