/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence;

import com.ibm.ws.persistence.EntityManagerFactoryImpl;
import com.ibm.ws.persistence.WsJpaLogFactory;
import com.ibm.ws.persistence.jdbc.kernel.ConstraintUpdateManager;
import com.ibm.ws.persistence.jdbc.kernel.WsJpaJDBCBrokerFactory;
import com.ibm.ws.persistence.jdbc.sql.DB2Dictionary;
import com.ibm.ws.persistence.jdbc.sql.OracleDictionary;
import com.ibm.ws.persistence.jdbc.sql.SQLFactoryImpl;
import com.ibm.ws.persistence.jdbc.sql.SQLServerDictionary;
import com.ibm.ws.persistence.kernel.WsJpaBrokerImpl;
import com.ibm.ws.persistence.kernel.WsJpaFinalizingBrokerImpl;
import com.ibm.ws.persistence.util.WsJpaProxyManagerImpl;
import java.util.Map;
import org.apache.openjpa.conf.BrokerFactoryValue;
import org.apache.openjpa.conf.BrokerValue;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.IntValue;
import org.apache.openjpa.lib.conf.ObjectValue;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.persistence.EntityManagerFactoryValue;
import org.apache.openjpa.persistence.PersistenceProductDerivation;
import org.apache.openjpa.persistence.PersistenceProviderImpl;

public class WsJpaProductDerivation
extends PersistenceProductDerivation {
    public WsJpaProductDerivation() {
        this._providerImplName = PersistenceProviderImpl.class.getName();
    }

    public boolean beforeConfigurationLoad(Configuration c) {
        boolean rval = super.beforeConfigurationLoad(c);
        this.setProductInfo(c);
        if (rval) {
            if (!(c instanceof OpenJPAConfiguration)) {
                rval = false;
            } else {
                OpenJPAConfiguration conf = (OpenJPAConfiguration)c;
                conf.getCompatibilityInstance().setStrictIdentityValues(true);
                conf.setFetchBatchSize(-1);
                PluginValue logValue = (PluginValue)c.getValue("Log");
                logValue.setAlias("wsjpa", WsJpaLogFactory.class.getName());
                logValue.setDefault("wsjpa");
                logValue.setString("wsjpa");
                IntValue runtimeUnenhancedClassesValue = (IntValue)c.getValue("RuntimeUnenhancedClasses");
                runtimeUnenhancedClassesValue.setDefault("warn");
                runtimeUnenhancedClassesValue.setString("warn");
                BrokerValue broker = (BrokerValue)c.getValue("BrokerImpl");
                broker.setAlias("wsjpa-finalizing", WsJpaFinalizingBrokerImpl.class.getName());
                broker.setAlias("wsjpa-non-finalizing", WsJpaBrokerImpl.class.getName());
                broker.setDefault("wsjpa-non-finalizing");
                broker.setString("wsjpa-non-finalizing");
                ObjectValue proxyManagerValue = (ObjectValue)c.getValue("ProxyManager");
                proxyManagerValue.setAlias("wsjpa", WsJpaProxyManagerImpl.class.getName());
                proxyManagerValue.setDefault("wsjpa");
                if (conf instanceof JDBCConfiguration) {
                    JDBCConfiguration jdbcConf = (JDBCConfiguration)conf;
                    jdbcConf.setUpdateManager(ConstraintUpdateManager.class.getCanonicalName());
                    jdbcConf.setSQLFactory(SQLFactoryImpl.class.getCanonicalName());
                    PluginValue dbdictionaryPlugin = ((JDBCConfigurationImpl)jdbcConf).dbdictionaryPlugin;
                    dbdictionaryPlugin.setAlias("db2", DB2Dictionary.class.getCanonicalName());
                    dbdictionaryPlugin.setAlias("oracle", OracleDictionary.class.getCanonicalName());
                    dbdictionaryPlugin.setAlias("sqlserver", SQLServerDictionary.class.getCanonicalName());
                    PluginValue driverDataSourcePlugin = ((JDBCConfigurationImpl)jdbcConf).driverDataSourcePlugin;
                    driverDataSourcePlugin.setDefault("simple");
                    driverDataSourcePlugin.setString("simple");
                }
                conf.setDynamicEnhancementAgent(false);
            }
            EntityManagerFactoryValue emf = (EntityManagerFactoryValue)c.getValue("EntityManagerFactory");
            if (emf != null) {
                emf.setDefault(EntityManagerFactoryImpl.class.getName());
                emf.setClassName(EntityManagerFactoryImpl.class.getName());
            } else {
                rval = false;
            }
        }
        return rval;
    }

    public int getType() {
        return 100;
    }

    private void setProductInfo(Configuration c) {
        c.setProductName("WSJPA");
    }

    public String getConfigurationPrefix() {
        return "wsjpa";
    }

    public void putBrokerFactoryAliases(Map m) {
        m.put("wsjpajdbc", WsJpaJDBCBrokerFactory.class.getName());
    }

    public boolean beforeConfigurationConstruct(ConfigurationProvider cp) {
        if (BrokerFactoryValue.get((ConfigurationProvider)cp) == null) {
            BrokerFactoryValue.set((ConfigurationProvider)cp, (String)"wsjpajdbc");
            return true;
        }
        return false;
    }
}

