/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.fastpath;

import com.ibm.ws.persistence.fastpath.FastPath;
import com.ibm.ws.persistence.kernel.WsJpaBrokerImpl;
import com.ibm.ws.persistence.kernel.WsJpaStateManagerImpl;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.util.OpenJPAId;
import org.apache.openjpa.util.ProxyManager;

public abstract class AbstractFastPath
implements FastPath {
    protected final String _sql;
    protected final ClassMapping _cm;
    protected final JDBCConfiguration _conf;
    protected final DBDictionary _dict;
    protected final boolean _checkCacheForLazyFields = false;
    protected final ProxyManager _proxyMgr;
    protected final PersistenceCapable _thisPc;
    protected final PersistenceCapable[] _relatedPCs;
    protected final ClassMapping[] _relatedMetas;

    public AbstractFastPath(String sql, ClassMapping cm, JDBCConfiguration conf) {
        this._sql = sql;
        this._cm = cm;
        this._conf = conf;
        this._dict = conf.getDBDictionaryInstance();
        this._proxyMgr = conf.getProxyManagerInstance();
        this._thisPc = PCRegistry.newInstance((Class)cm.getDescribedType(), null, (boolean)false);
        FieldMapping[] fms = cm.getFieldMappings();
        this._relatedPCs = new PersistenceCapable[fms.length];
        this._relatedMetas = new ClassMapping[fms.length];
        for (FieldMapping fm : fms) {
            switch (fm.getAssociationType()) {
                case 2: {
                    this._relatedMetas[fm.getIndex()] = (ClassMapping)fm.getElement().getDeclaredTypeMetaData();
                    this._relatedPCs[fm.getIndex()] = PCRegistry.newInstance((Class)fm.getElement().getDeclaredType(), null, (boolean)false);
                    break;
                }
                case 1: 
                case 3: {
                    this._relatedMetas[fm.getIndex()] = fm.getDeclaredTypeMapping();
                    this._relatedPCs[fm.getIndex()] = PCRegistry.newInstance((Class)fm.getRelationType(), null, (boolean)false);
                    break;
                }
                case 4: {
                    throw new UnsupportedOperationException("unable to support MTM " + fm);
                }
            }
            ClassMapping embed = fm.getEmbeddedMapping();
            if (embed == null || !embed.isEmbeddable()) continue;
            this._relatedMetas[fm.getIndex()] = fm.getDeclaredTypeMapping();
            this._relatedPCs[fm.getIndex()] = PCRegistry.newInstance((Class)embed.getDescribedType(), null, (boolean)false);
        }
    }

    protected OpenJPAStateManager initializeNewStateManager(OpenJPAId oid, Broker broker, ClassMapping type) {
        WsJpaBrokerImpl bi = (WsJpaBrokerImpl)broker;
        StateManagerImpl sm = bi.newStateManagerImpl(oid, (ClassMetaData)type);
        sm.setObjectId((Object)oid);
        sm.initialize(type.getDescribedType(), broker.isActive() ? PCState.PCLEAN : PCState.PNONTRANS);
        return sm;
    }

    protected final OpenJPAStateManager initializeNewEmbeddedStateManager(Broker broker, OpenJPAStateManager owner, ClassMapping embedType) {
        WsJpaBrokerImpl bi = (WsJpaBrokerImpl)broker;
        BrokerImpl.StateManagerId id = BrokerImpl.StateManagerId.newInstance((Broker)broker);
        StateManagerImpl sm = bi.newStateManagerImpl(id, (ClassMetaData)embedType);
        sm.setObjectId((Object)id);
        sm.initialize(embedType.getDescribedType(), broker.isActive() ? PCState.ECLEAN : PCState.ENONTRANS);
        return sm;
    }

    protected void registerEntityInContext(PersistenceCapable pc, Object oid, Object version, WsJpaBrokerImpl broker) {
        WsJpaStateManagerImpl sm = (WsJpaStateManagerImpl)pc.pcGetStateManager();
        sm.setStateManagerVersionFields(version);
        sm.setDfgLoaded();
    }

    @Override
    public String getSql() {
        return this._sql;
    }

    public class ProxyKey {
        private final StateManagerImpl _sm;
        private final Integer _proxyFieldIndex;

        public ProxyKey(StateManagerImpl smi, Integer proxyFieldIndex) {
            this._sm = smi;
            this._proxyFieldIndex = proxyFieldIndex;
        }

        public StateManagerImpl getStateManager() {
            return this._sm;
        }

        public Integer getProxyFieldIndex() {
            return this._proxyFieldIndex;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._proxyFieldIndex == null ? 0 : this._proxyFieldIndex.hashCode());
            result = 31 * result + (this._sm == null ? 0 : this._sm.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProxyKey other = (ProxyKey)obj;
            if (this._proxyFieldIndex == null ? other._proxyFieldIndex != null : !this._proxyFieldIndex.equals(other._proxyFieldIndex)) {
                return false;
            }
            return !(this._sm == null ? other._sm != null : !this._sm.equals(other._sm));
        }
    }
}

