/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.fastpath;

import com.ibm.ws.persistence.QueryImpl;
import com.ibm.ws.persistence.fastpath.FastPath;
import com.ibm.ws.persistence.fastpath.FastPathManager;
import com.ibm.ws.persistence.fastpath.FindFastPath;
import com.ibm.ws.persistence.fastpath.LoadFastPath;
import com.ibm.ws.persistence.fastpath.QueryFastPath;
import com.ibm.ws.persistence.fastpath.compiler.FastpathCompiler;
import com.ibm.ws.persistence.fastpath.filters.FilterManager;
import com.ibm.ws.persistence.fastpath.javagen.JavaSourceGenerator;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.sql.ParameterMetaData;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.util.UnsupportedException;

public class FastPathBuilder {
    private static final Localizer _loc = Localizer.forPackage(FastPathBuilder.class);
    private final Log _log;
    private final JavaSourceGenerator _srcGenerator;
    private final FastpathCompiler _compiler;
    private final WsJpaJDBCConfiguration _conf;
    private final List<Class<?>> _classes;
    static String testLoc = System.getProperty("FastPathBuilder.loc", "C:\\temp\\fastpath\\");
    static boolean debug = Boolean.valueOf(System.getProperty("FastPathBuilder.debug", "false"));

    FastPathBuilder(Log log, WsJpaJDBCConfiguration conf) {
        this._log = log;
        this._conf = conf;
        this._srcGenerator = new JavaSourceGenerator(this._conf.getMappingRepositoryInstance(), conf);
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        this._classes = new ArrayList();
        for (ClassMetaData cmd : conf.getMetaDataRepositoryInstance().getMetaDatas()) {
            this._classes.add(cmd.getDescribedType());
            for (FieldMetaData fmd : cmd.getFields()) {
                if (fmd.getTypeCode() != 32) continue;
                this._classes.add(fmd.getDeclaredType());
            }
        }
        this._compiler = new FastpathCompiler(loader, this._log, this._classes);
    }

    LoadFastPath buildLoadPath(ResultSetMetaData rsmd, FieldMapping fm, String sql, FetchPlan fetchPlan, ParameterMetaData pmd) throws Exception {
        StringWriter writer = new StringWriter();
        String fqClassName = this._srcGenerator.generateLoadFastPath(fm, rsmd, new PrintWriter(writer), fetchPlan, sql, pmd);
        String src = ((Object)writer).toString();
        ClassMapping owner = (ClassMapping)fm.getRepository().getMetaData(fm.getRelationType(), null, true);
        Class[] ctorParamTypes = new Class[]{String.class, ClassMapping.class, FieldMapping.class, JDBCConfiguration.class};
        Object[] ctorParamValues = new Object[]{sql, owner, fm, this._conf};
        return (LoadFastPath)this.buildPath(src, fqClassName, sql, ctorParamTypes, ctorParamValues);
    }

    FindFastPath buildFindPath(ResultSetMetaData rsmd, ClassMapping cmd, String sql, FetchPlan fetchPlan, ParameterMetaData pmd) throws Exception {
        StringWriter writer = new StringWriter();
        String fqClassName = this._srcGenerator.generateFindFastPath(cmd, rsmd, new PrintWriter(writer), fetchPlan, sql, pmd);
        String src = ((Object)writer).toString();
        Class[] ctorParamTypes = new Class[]{String.class, ClassMapping.class, JDBCConfiguration.class};
        Object[] ctorParamValues = new Object[]{sql, cmd, this._conf};
        return (FindFastPath)this.buildPath(src, fqClassName, sql, ctorParamTypes, ctorParamValues);
    }

    QueryFastPath buildQueryPath(FastPathManager fpm, ResultSetMetaData rsmd, QueryImpl<?> query, QueryMetaData qmd, String sql, ParameterMetaData pmd) throws Exception {
        StringWriter writer = new StringWriter();
        String fqClassName = this._srcGenerator.generateQueryFastPath(fpm, rsmd, query, qmd, new PrintWriter(writer), query.getFetchPlan(), sql, pmd);
        String src = ((Object)writer).toString();
        ClassMapping[] cms = this._srcGenerator.findQueryEagers(rsmd, query.getDelegate().getCandidateType(), query.getFetchPlan());
        FilterManager filterMgr = this._conf.getFastPathManagerFactoryInstance().getFilterManager();
        if (filterMgr.filter(cms, new QueryMetaData[]{qmd}, true).size() > 0) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("Query [" + qmd + "] is being excluded due to these mappings [" + this.formatCMArray(cms) + "]"));
            }
            throw new UnsupportedException("Unable to fastpath query [ " + qmd + " ].");
        }
        Class<PersistenceCapable>[] classes = this._srcGenerator.getPCTypes(cms);
        Class[] ctorParamTypes = new Class[]{String.class, JDBCConfiguration.class, Class[].class, ClassMapping[].class};
        Object[] ctorParamValues = new Object[]{sql, this._conf, classes, cms};
        return (QueryFastPath)this.buildPath(src, fqClassName, sql, ctorParamTypes, ctorParamValues);
    }

    private String formatCMArray(ClassMapping[] cms) {
        StringBuilder sb = new StringBuilder();
        if (cms != null) {
            for (int i = 0; i < cms.length; ++i) {
                sb.append(cms[i].toString());
                if (i >= cms.length - 1) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    private synchronized FastPath buildPath(String srcFile, String fqClassName, String sql, Class<?>[] ctorParamTypes, Object[] ctorParamsValues) throws Exception {
        FastPath fp;
        String packageName = fqClassName.substring(0, fqClassName.lastIndexOf("."));
        String clsName = fqClassName.substring(fqClassName.lastIndexOf(".") + 1);
        if (debug) {
            this.dump(clsName, srcFile);
        }
        if ((fp = this.compileAndLoadFastPath(packageName, clsName, srcFile, sql, ctorParamTypes, ctorParamsValues)) != null && this._log.isInfoEnabled()) {
            this._log.info((Object)_loc.get("fastpath-success", (Object)fp));
        }
        return fp;
    }

    private FastPath compileAndLoadFastPath(String packageName, String clsName, String src, String sql, Class<?>[] ctorParamTypes, Object[] ctorParamsValues) throws Exception {
        Class<FastPath> cls = this._compiler.compileAndLoad(packageName, clsName, src);
        Constructor<FastPath> ctor = cls.getConstructor(ctorParamTypes);
        return ctor.newInstance(ctorParamsValues);
    }

    private void dump(String clsName, String src) {
        File f = new File(testLoc + clsName + ".java");
        try {
            File parent = f.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            FileWriter fstream = new FileWriter(f);
            BufferedWriter out = new BufferedWriter(fstream);
            out.append(src);
            out.flush();
            out.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        System.err.println("Debug -- dumped " + f);
    }
}

