/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.fastpath;

import com.ibm.ws.persistence.QueryImpl;
import com.ibm.ws.persistence.fastpath.FastPath;
import com.ibm.ws.persistence.fastpath.FastPathBuilder;
import com.ibm.ws.persistence.fastpath.FindFastPath;
import com.ibm.ws.persistence.fastpath.LoadFastPath;
import com.ibm.ws.persistence.fastpath.PrepareStatementListener;
import com.ibm.ws.persistence.fastpath.QueryFastPath;
import com.ibm.ws.persistence.fastpath.util.FastPathStatistics;
import com.ibm.ws.persistence.fastpath.util.FastPathStatisticsImpl;
import com.ibm.ws.persistence.fastpath.util.PrimaryKeyFieldManager;
import com.ibm.ws.persistence.fastpath.util.TransferStateManager;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import com.ibm.ws.persistence.jdbc.kernel.WsJpaJDBCStoreManager;
import com.ibm.ws.persistence.kernel.WsJpaBrokerImpl;
import com.ibm.ws.persistence.kernel.WsJpaStateManagerImpl;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.event.TransactionEvent;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.kernel.DelegatingStoreManager;
import org.apache.openjpa.kernel.FindCallbacks;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.OrderedMap;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.PersistenceException;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.OpenJPAId;
import org.apache.openjpa.util.UnsupportedException;

public class FastPathManager
implements PrepareStatementListener {
    private static final Localizer _loc = Localizer.forPackage(FastPathManager.class);
    private final Set<Object> _rejects;
    private final Map<ClassMapping, FindFastPath> _findPaths;
    private final Map<FieldMapping, LoadFastPath> _loadPath;
    private final Map<QueryMetaData, QueryFastPath> _queryPaths;
    private final FastPathBuilder _builder;
    private FetchPlan _fetchPlan;
    private final WsJpaBrokerImpl _broker;
    private final WsJpaJDBCStoreManager _store;
    private final WsJpaJDBCConfiguration _conf;
    private final Log _log;
    private final MappingRepository _repo;
    private final TransferStateManager _tsm = new TransferStateManager();
    private final PrimaryKeyFieldManager _pkfm = new PrimaryKeyFieldManager();
    private final Map<Class<?>, ClassMapping> _mappingCache;
    private final FastPathStatisticsImpl _stats;
    private boolean _generating = false;
    private int _sqlCount = 0;
    private boolean _flushing = false;
    private ClassMapping _processingClassMapping;
    private FieldMapping _processingFieldMapping;
    private QueryMetaData _processingQueryMetaData;
    private QueryImpl<?> _processingQuery;

    FastPathManager(WsJpaBrokerImpl broker, Map<ClassMapping, FindFastPath> findPath, Map<FieldMapping, LoadFastPath> loadPath, Map<QueryMetaData, QueryFastPath> queryPaths, FastPathBuilder builder, FastPathStatistics stats, Set<Object> rejects) {
        this._broker = broker;
        DelegatingStoreManager sm = this._broker.getStoreManager();
        while (!(sm.getDelegate() instanceof WsJpaJDBCStoreManager)) {
            sm = (DelegatingStoreManager)sm.getDelegate();
        }
        this._store = (WsJpaJDBCStoreManager)this._broker.getStoreManager().getDelegate();
        this._findPaths = findPath;
        this._loadPath = loadPath;
        this._queryPaths = queryPaths;
        this._rejects = rejects;
        this._conf = (WsJpaJDBCConfiguration)broker.getConfiguration();
        this._repo = this._conf.getMappingRepositoryInstance();
        this._log = this._conf.getLog("FP");
        this._mappingCache = new HashMap();
        for (ClassMapping cm : this._repo.getMappings()) {
            Class cls = cm.getDescribedType();
            if (cm == null) continue;
            this._mappingCache.put(cls, cm);
        }
        this._builder = builder;
        this._stats = (FastPathStatisticsImpl)stats;
    }

    public void setFetchPlan(FetchPlan fp) {
        this._fetchPlan = fp;
    }

    /*
     * Exception decompiling
     */
    public Object find(OpenJPAId oid, boolean validate, FindCallbacks call) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean load(WsJpaStateManagerImpl sm, FieldMapping fm) {
        return this.load(sm, fm, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(WsJpaStateManagerImpl sm, FieldMapping fm, boolean delayed) {
        LoadFastPath lfp = this._loadPath.get(fm);
        if (lfp != null) {
            Connection conn = this._store.getConnection();
            try {
                boolean bl;
                PreparedStatement stmt = this.getStatement(lfp, conn);
                try {
                    boolean res = lfp.loadField(sm.getPersistenceCapable(), this._broker, stmt, this._tsm, this._pkfm);
                    this._stats.loadHit(fm);
                    bl = res;
                }
                catch (Throwable throwable) {
                    try {
                        stmt.close();
                        throw throwable;
                    }
                    catch (Throwable e) {
                        if (this._log.isTraceEnabled()) {
                            this._log.trace((Object)("Removing " + lfp.getClass().getName() + " from list of valid paths due to execution exception."), e);
                            e.printStackTrace();
                        }
                        this._loadPath.remove(fm);
                        this._rejects.add(fm);
                        if (this._broker.isActive()) {
                            this._broker.setRollbackOnly(e);
                        }
                        throw new PersistenceException(_loc.get("fastpath-removing", new Object[]{lfp.getClass().getName()}).getMessage().toString(), new Throwable[]{e}, (Object)sm, true);
                    }
                }
                stmt.close();
                return bl;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        this._generating = true;
        this._processingFieldMapping = fm;
        try {
            this._store.setPrepareStatementListener(this);
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("Starting generation of load fastpath for " + fm + "."));
            }
            if (delayed) {
                sm.loadDelayedField(fm.getIndex());
            } else {
                sm.beforeAccessField(fm.getIndex());
            }
        }
        finally {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("End generation of load fastpath for " + fm + "."));
            }
            if (this._sqlCount != 1) {
                this._loadPath.remove(fm);
                this._rejects.add(fm);
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("Found " + this._sqlCount + " SQL statements while generating load fastpath for [" + fm + "]. Excluding."));
                }
            }
            this._sqlCount = 0;
            this._store.setPrepareStatementListener(null);
            this._generating = false;
            this._processingFieldMapping = null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> queryGetResultList(QueryImpl<?> query, QueryMetaData qmd) {
        QueryFastPath qfp = this._queryPaths.get(qmd);
        if (qfp != null) {
            Connection conn = this._store.getConnection();
            PreparedStatement stmt = null;
            Object[] params = null;
            try {
                stmt = this.getStatement(qfp, conn);
                if (query.hasPositionalParameters()) {
                    params = query.getPositionalParameters();
                } else {
                    Map paramValues = query.getNamedParameters();
                    OrderedMap nps = query.getParamTypes();
                    Object[] keys = nps.keySet().toArray();
                    params = new Object[keys.length];
                    int i = 0;
                    for (Object key : keys) {
                        params[i++] = paramValues.get(key);
                    }
                }
                List<?> res = qfp.getResultList(this._broker, stmt, this._tsm, this._pkfm, params);
                this._stats.queryHit(qmd);
                List<?> list = res;
                return list;
            }
            catch (Throwable e) {
                this._queryPaths.remove(qmd);
                this._rejects.add(qmd);
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("Removing " + qfp.getClass().getName() + " from list of valid paths due to execution exception."), e);
                    e.printStackTrace();
                }
                if (this._broker.isActive()) {
                    this._broker.setRollbackOnly(e);
                }
                throw new PersistenceException(_loc.get("fastpath-removing", new Object[]{qfp.getClass().getName()}).getMessage().toString(), new Throwable[]{e}, query, true);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        this._generating = true;
        this._processingQueryMetaData = qmd;
        this._processingQuery = query;
        this._sqlCount = 0;
        try {
            this._store.setPrepareStatementListener(this);
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("Starting generation of query fastpath for " + qmd + "."));
            }
            List list = query.getResultList();
            return list;
        }
        finally {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("End generation of query fastpath for " + qmd + "."));
            }
            this._store.setPrepareStatementListener(null);
            if (this._sqlCount != 1) {
                this._queryPaths.remove(this._processingQueryMetaData);
                this._rejects.add(this._processingQueryMetaData);
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("Found " + this._sqlCount + "SQL statements while generating query fastpath for [" + qmd + "]. Excluding."));
                }
            }
            this._sqlCount = 0;
            this._generating = false;
            this._processingQueryMetaData = null;
            this._processingQuery = null;
        }
    }

    public boolean isFastPathEligible(Class<?> cls) {
        ClassMapping cm = this._mappingCache.get(cls);
        return cm != null && !this._rejects.contains(cm);
    }

    public boolean isFastPathEligibleAndNotCurrentlyGenerating(Class<?> cls) {
        return !this._generating && this.isFastPathEligible(cls);
    }

    public boolean isFastPathEligibleAndNotCurrentlyGenerating(FieldMapping fm) {
        Class cls = fm.getRelationType();
        return !this._generating && cls != null && !this._rejects.contains(fm);
    }

    public boolean isFastPathEligibleAndNotCurrentlyGenerating(QueryMetaData qmd) {
        return !this._generating && !this._rejects.contains(qmd);
    }

    public FastPathStatistics getStatistics() {
        return this._stats;
    }

    private PreparedStatement getStatement(FastPath fp, Connection conn) {
        PreparedStatement res = null;
        try {
            res = conn.prepareStatement(fp.getSql());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    @Override
    public void prepareStatement(String sql, PreparedStatement stmt) throws SQLException {
        ParameterMetaData pmd;
        ResultSetMetaData rsmd;
        block10: {
            rsmd = null;
            pmd = null;
            try {
                rsmd = stmt.getMetaData();
                pmd = stmt.getParameterMetaData();
            }
            catch (Throwable t) {
                if (!this._log.isTraceEnabled()) break block10;
                this._log.trace((Object)("Exception caught when attempted to obtain metadata from PreparedStatement:" + t.getMessage()));
                if (rsmd == null) {
                    this._log.trace((Object)("JDBC driver does not support PreparedStatement.getMetaData() before statement is executed; fastpath will be disabled for statement: " + sql));
                }
                this._log.trace((Object)("JDBC driver does not support PreparedStatement.getParameterMetaData(); fastpath will be disabled for statement: " + sql));
            }
        }
        if (!this._generating) {
            throw new InternalException();
        }
        if (this._flushing) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("In-flight flush operation detected for statement: " + sql));
            }
            return;
        }
        ++this._sqlCount;
        if (this._processingClassMapping != null) {
            this.handlePrepareStatementForFind(sql, rsmd, pmd);
        } else if (this._processingFieldMapping != null) {
            this.handlePrepareStatementForLoad(sql, rsmd, pmd);
        } else {
            this.handlePrepareStatementForQuery(sql, rsmd, pmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePrepareStatementForFind(String sql, ResultSetMetaData rsmd, ParameterMetaData pmd) {
        block9: {
            try {
                FastPathBuilder fastPathBuilder = this._builder;
                synchronized (fastPathBuilder) {
                    FindFastPath ffp = this._findPaths.get(this._processingClassMapping);
                    if (ffp != null) {
                        return;
                    }
                    ffp = this._builder.buildFindPath(rsmd, this._processingClassMapping, sql, this._fetchPlan, pmd);
                    if (ffp != null) {
                        this._findPaths.put(this._processingClassMapping, ffp);
                        return;
                    }
                }
            }
            catch (UnsupportedException uoe) {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("Unable to create a find path for " + this._processingClassMapping + " Due to [" + uoe.getMessage() + "]"));
                }
            }
            catch (Throwable t) {
                if (!this._log.isTraceEnabled()) break block9;
                this._log.trace((Object)("Caught an exception while creating a find path for " + this._processingClassMapping), t);
                t.printStackTrace();
            }
        }
        this._rejects.add(this._processingClassMapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePrepareStatementForLoad(String sql, ResultSetMetaData rsmd, ParameterMetaData pmd) {
        block9: {
            try {
                FastPathBuilder fastPathBuilder = this._builder;
                synchronized (fastPathBuilder) {
                    LoadFastPath lfp = this._loadPath.get(this._processingFieldMapping);
                    if (lfp != null) {
                        return;
                    }
                    lfp = this._builder.buildLoadPath(rsmd, this._processingFieldMapping, sql, this._fetchPlan, pmd);
                    if (lfp != null) {
                        this._loadPath.put(this._processingFieldMapping, lfp);
                        return;
                    }
                }
            }
            catch (UnsupportedException uoe) {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("Unable to create a load path for " + this._processingQueryMetaData + " Due to [" + uoe.getMessage() + "]"));
                }
            }
            catch (Throwable t) {
                if (!this._log.isTraceEnabled()) break block9;
                this._log.trace((Object)("Caught an exception while creating a load path for " + this._processingFieldMapping), t);
                t.printStackTrace();
            }
        }
        this._rejects.add(this._processingFieldMapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePrepareStatementForQuery(String sql, ResultSetMetaData rsmd, ParameterMetaData pmd) {
        block9: {
            try {
                FastPathBuilder fastPathBuilder = this._builder;
                synchronized (fastPathBuilder) {
                    QueryFastPath qfp = this._queryPaths.get(this._processingQueryMetaData);
                    if (qfp != null) {
                        return;
                    }
                    qfp = this._builder.buildQueryPath(this, rsmd, this._processingQuery, this._processingQueryMetaData, sql, pmd);
                    if (qfp != null) {
                        this._queryPaths.put(this._processingQueryMetaData, qfp);
                        return;
                    }
                }
            }
            catch (UnsupportedException uoe) {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("Unable to create a query path for " + this._processingQueryMetaData + " Due to [" + uoe.getMessage() + "]"));
                }
            }
            catch (Throwable t) {
                if (!this._log.isTraceEnabled()) break block9;
                this._log.trace((Object)("Caught an unexpected while creating a query path for " + this._processingQueryMetaData), t);
            }
        }
        this._rejects.add(this._processingQueryMetaData);
    }

    public void beforeFlush(TransactionEvent event) {
        this._flushing = true;
    }

    public void afterFlush(TransactionEvent event) {
        this._flushing = false;
    }
}

