/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.fastpath;

import com.ibm.ws.persistence.fastpath.ExclusionHelper;
import com.ibm.ws.persistence.fastpath.FastPathBuilder;
import com.ibm.ws.persistence.fastpath.FastPathManager;
import com.ibm.ws.persistence.fastpath.FastPathManagerFactory;
import com.ibm.ws.persistence.fastpath.FindFastPath;
import com.ibm.ws.persistence.fastpath.LoadFastPath;
import com.ibm.ws.persistence.fastpath.QueryFastPath;
import com.ibm.ws.persistence.fastpath.filters.FilterManager;
import com.ibm.ws.persistence.fastpath.util.FastPathStatistics;
import com.ibm.ws.persistence.fastpath.util.FastPathStatisticsImpl;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfigurationImpl;
import com.ibm.ws.persistence.kernel.WsJpaBrokerImpl;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.QueryMetaData;

public class FastPathManagerFactoryImpl
implements FastPathManagerFactory {
    private static final Localizer _loc = Localizer.forPackage(FastPathManagerFactoryImpl.class);
    private WsJpaJDBCConfiguration _conf;
    private MappingRepository _repo;
    private Log _log;
    private boolean _collectStats = false;
    private Map<ClassMapping, FindFastPath> _findPaths = new ConcurrentHashMap<ClassMapping, FindFastPath>();
    private Map<FieldMapping, LoadFastPath> _loadPaths = new ConcurrentHashMap<FieldMapping, LoadFastPath>();
    private Map<QueryMetaData, QueryFastPath> _queryPaths = new ConcurrentHashMap<QueryMetaData, QueryFastPath>();
    private Set<Object> _rejects = null;
    private FastPathBuilder _builder;
    private String _exclude;
    private String _include;
    private Set<String> _excludeSet;
    private Set<String> _includeSet;
    private FilterManager _filterMgr;
    private FastPathStatistics _stats;

    @Override
    public void initialize(OpenJPAConfiguration conf) {
        this._conf = (WsJpaJDBCConfiguration)conf;
        this._repo = this._conf.getMappingRepositoryInstance();
        this._log = conf.getLog("FP");
        this._log.trace((Object)"FastPathManagerFactoryImpl.initialize");
        if (!this.validateConfiguration()) {
            return;
        }
        this._builder = new FastPathBuilder(this._log, this._conf);
        this._filterMgr = new FilterManager(this._conf);
        this._rejects = this._filterMgr.filter(this._repo.getMappings(), this._repo.getQueryMetaDatas());
        this._stats = new FastPathStatisticsImpl(this._collectStats);
    }

    private boolean validateConfiguration() {
        boolean fail = false;
        DataCacheManager dcm = this._conf.getDataCacheManagerInstance();
        if (dcm != null && dcm.getSystemDataCache() != null) {
            fail = true;
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)_loc.get("fastpath-invalid-configuration", (Object)"openjpa.DataCache"));
            }
        }
        if (dcm != null && dcm.getSystemQueryCache() != null) {
            fail = true;
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)_loc.get("fastpath-invalid-configuration-datacache", (Object)"openjpa.QueryCache"));
            }
        }
        if (!this._repo.getPreload()) {
            fail = true;
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)_loc.get("fastpath-invalid-configuration-preload"));
            }
        }
        if (fail) {
            if (this._log.isTraceEnabled()) {
                DataCache cache = dcm != null ? dcm.getSystemDataCache() : null;
                this._log.trace((Object)("Ignoring FastPath configuration as an invalid configuration was detected. [ preload = " + this._repo.getPreload() + ", dcm =  " + dcm + ", systemCache = " + cache));
            }
            ((WsJpaJDBCConfigurationImpl)this._conf).fastPathManagerPlugin.set(null);
            return false;
        }
        return true;
    }

    @Override
    public FastPathManager createFastManagerInstance(WsJpaBrokerImpl broker) {
        return new FastPathManager(broker, this._findPaths, this._loadPaths, this._queryPaths, this._builder, this._stats, this._rejects);
    }

    @Override
    public FilterManager getFilterManager() {
        return this._filterMgr;
    }

    private boolean isFastPathEligible(ClassMapping cm) {
        FastPathManagerFactory fpmf = this._conf.getFastPathManagerFactoryInstance();
        if (ExclusionHelper.exclude(fpmf.getIncludeSet(), fpmf.getExcludeSet(), cm.getDescribedTypeString())) {
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)_loc.get("fastpath-excluding-find", (Object)cm.getDescribedTypeString()));
            }
            return false;
        }
        block4: for (FieldMapping fm : cm.getFieldMappings()) {
            if (!fm.isInDefaultFetchGroup()) continue;
            switch (fm.getAssociationType()) {
                case 1: 
                case 2: 
                case 3: {
                    continue block4;
                }
                case 4: {
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("Type " + cm + " isn't fastpath eligible" + fm + " is an eager rel " + fm.getAssociationType()));
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isFastPathEligible(FieldMapping fm) {
        switch (fm.getDeclaredTypeCode()) {
            case 11: 
            case 13: {
                return false;
            }
        }
        return true;
    }

    public void setCollectStats(boolean b) {
        this._collectStats = b;
    }

    public boolean getCollectStats() {
        return this._collectStats;
    }

    @Override
    public FastPathStatistics getStats() {
        return this._stats;
    }

    public void setExclude(String s) {
        this._exclude = s;
    }

    public String getExclude() {
        return this._exclude;
    }

    @Override
    public Set<String> getExcludeSet() {
        if (this._excludeSet == null && this._exclude != null) {
            this._excludeSet = ExclusionHelper.getSelectionSet(this._exclude);
        }
        return this._excludeSet;
    }

    public void setInclude(String s) {
        this._include = s;
    }

    @Override
    public Set<String> getIncludeSet() {
        if (this._includeSet == null && this._include != null) {
            this._includeSet = ExclusionHelper.getSelectionSet(this._include);
        }
        return this._includeSet;
    }
}

