/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.fastpath.compiler;

import com.ibm.ws.persistence.fastpath.FastPath;
import com.ibm.ws.persistence.fastpath.compiler.FastpathClassLoader;
import com.ibm.ws.persistence.fastpath.compiler.FastpathJavaFileObject;
import com.ibm.ws.persistence.fastpath.compiler.FastpathMemoryFileManager;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Persistence;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import javax.transaction.Synchronization;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;

public class FastpathCompiler {
    private JavaCompiler compiler = null;
    private FastpathClassLoader _cl = null;
    private Log _log;
    private final List<Class<?>> _applicationClasses;

    public FastpathCompiler(ClassLoader parent, Log log, List<Class<?>> applicationClasses) {
        this._log = log;
        this._cl = new FastpathClassLoader(parent);
        this.compiler = ToolProvider.getSystemJavaCompiler();
        this._applicationClasses = applicationClasses;
    }

    public FastpathClassLoader getClassLoader() {
        return this._cl;
    }

    public Class<FastPath> compileAndLoad(String packageName, String className, String code) throws Exception {
        if (this.compiler == null) {
            throw new RuntimeException("Could not locate the Java compiler tool");
        }
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ArrayList<FastpathJavaFileObject> sfs = new ArrayList<FastpathJavaFileObject>();
        sfs.add(new FastpathJavaFileObject(className, code));
        ArrayList<String> options = new ArrayList<String>();
        this._log.trace((Object)("Compiling " + className + " ..."));
        FastpathMemoryFileManager fpmfm = new FastpathMemoryFileManager(this._cl);
        Collection<File> files = this.buildCompilationClasspath(this._applicationClasses);
        fpmfm.setLocation(StandardLocation.CLASS_PATH, files);
        final JavaCompiler.CompilationTask task = this.compiler.getTask(null, fpmfm, diagnostics, options, null, sfs);
        Boolean success = System.getSecurityManager() == null ? task.call() : AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return task.call();
            }
        });
        this._log.trace((Object)("task return code: " + success + ". classloader: " + this._cl));
        if (!success.booleanValue()) {
            this._log.trace((Object)"--Diagnostics--");
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                this._log.trace((Object)("Code    :" + diagnostic.getCode()));
                this._log.trace((Object)("Kind    :" + (Object)((Object)diagnostic.getKind())));
                this._log.trace((Object)("Position:" + diagnostic.getPosition()));
                this._log.trace((Object)("Start   :" + diagnostic.getStartPosition()));
                this._log.trace((Object)("End     :" + diagnostic.getEndPosition()));
                this._log.trace((Object)("Source  :" + diagnostic.getSource()));
                this._log.trace((Object)("Message :" + diagnostic.getMessage(null)));
                this._log.trace((Object)"=======================================");
            }
            throw new RuntimeException("Compilation failed.");
        }
        return fpmfm.getClass(packageName + "." + className);
    }

    private Collection<File> buildCompilationClasspath(List<Class<?>> applicationClasses) {
        File transLoc;
        this._log.trace((Object)"Building compilation classpath");
        HashSet<File> files = new HashSet<File>();
        File jpaLoc = this.getClasspathLocation(FastpathCompiler.class);
        if (jpaLoc != null) {
            this._log.trace((Object)("OpenJPA classes found: " + jpaLoc));
            files.add(jpaLoc);
        }
        files.add(this.getClasspathLocation(JDBCConfiguration.class));
        files.add(this.getClasspathLocation(OpenJPAConfiguration.class));
        files.add(this.getClasspathLocation(Configuration.class));
        File persLoc = this.getClasspathLocation(Persistence.class);
        if (persLoc != null) {
            this._log.trace((Object)("Persistence classes found: " + persLoc));
            files.add(persLoc);
        }
        if ((transLoc = this.getClasspathLocation(Synchronization.class)) != null) {
            this._log.trace((Object)("Transaction classes found: " + transLoc));
            files.add(transLoc);
        }
        if (applicationClasses == null) {
            return files;
        }
        for (Class<?> cls : applicationClasses) {
            File appLoc = this.getClasspathLocation(cls);
            if (appLoc == null || files.contains(appLoc)) continue;
            files.add(appLoc);
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("compiler classpath: " + ((Object)files).toString()));
        }
        return files;
    }

    private File getClasspathLocation(Class<?> cls) {
        CodeSource cs = (System.getSecurityManager() == null ? cls.getProtectionDomain() : (ProtectionDomain)AccessController.doPrivileged(J2DoPrivHelper.getProtectionDomainAction(cls))).getCodeSource();
        if (cs != null) {
            URL loc = cs.getLocation();
            if (loc != null) {
                try {
                    return new File(loc.toURI());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            this._log.trace((Object)("Could not get code source location for " + cls));
        } else {
            this._log.trace((Object)("Could not get code source for " + cls));
        }
        return null;
    }
}

