/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.fastpath.compiler;

import com.ibm.ws.persistence.fastpath.compiler.FastpathClassLoader;
import com.ibm.ws.persistence.fastpath.compiler.FastpathMemoryFileObject;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class FastpathMemoryFileManager
extends ForwardingJavaFileManager<StandardJavaFileManager> {
    private HashMap<String, FastpathMemoryFileObject> _classes = new HashMap();
    private FastpathClassLoader _cl = null;

    public FastpathMemoryFileManager(FastpathClassLoader cl) {
        super(ToolProvider.getSystemJavaCompiler().getStandardFileManager(null, null, null));
        this._cl = cl;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (StandardLocation.CLASS_OUTPUT == location && JavaFileObject.Kind.CLASS == kind) {
            FastpathMemoryFileObject fpmfo = new FastpathMemoryFileObject(className);
            this._classes.put(className, fpmfo);
            return fpmfo;
        }
        throw new RuntimeException("Output location is not valid");
    }

    public byte[] getClassBytes(String className) {
        if (this._classes.containsKey(className)) {
            return this._classes.get(className).getBytes();
        }
        return null;
    }

    public Class<?> getClass(String className) {
        byte[] bytes = this.getClassBytes(className);
        return this._cl.getClassFromBytes(className, bytes);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        ClassLoader cl = this._cl;
        if (cl == null) {
            cl = super.getClassLoader(location);
        }
        return cl;
    }

    protected void setLocation(final JavaFileManager.Location location, final Iterable<? extends File> path) throws IOException {
        try {
            if (System.getSecurityManager() == null) {
                ((StandardJavaFileManager)this.fileManager).setLocation(location, path);
            } else {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws IOException {
                        ((StandardJavaFileManager)FastpathMemoryFileManager.this.fileManager).setLocation(location, path);
                        return Boolean.TRUE;
                    }
                });
            }
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
    }
}

