/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.fastpath.filters;

import com.ibm.ws.persistence.fastpath.filters.AbstractFilter;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.security.AccessController;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.persistence.jdbc.Strategy;

class AnnotationFilter
extends AbstractFilter {
    AnnotationFilter(WsJpaJDBCConfiguration conf) {
        super(conf);
    }

    @Override
    public boolean filter(ClassMapping cm) {
        if (cm.getMappingInfo().getSecondaryTableIdentifiers().length > 0) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("Excluding [" + cm + "] from FastPath generation due to @SecondaryTable."));
            }
            return true;
        }
        for (FieldMapping fm : cm.getFieldMappings()) {
            if (!this.filter(fm, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean filter(FieldMapping fm) {
        return this.filter(fm, false);
    }

    private boolean filter(FieldMapping fm, boolean dfg) {
        AnnotatedElement el;
        if (fm.isInDefaultFetchGroup() != dfg) {
            return false;
        }
        String factory = fm.getFactory();
        if (factory != null) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("Excluding " + fm + " [" + dfg + "] from FastPath generation to a @Factory. [" + factory + "]"));
            }
            return true;
        }
        String externalizer = fm.getExternalizer();
        if (externalizer != null) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("Excluding " + fm + " [" + dfg + "] from FastPath generation due to @Externalizer. [" + externalizer + "]"));
            }
            return true;
        }
        String externalValues = fm.getExternalValues();
        if (externalValues != null) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("Excluding " + fm + " [" + dfg + "] from FastPath generation due to a @ExternalValues. [" + externalValues + "]"));
            }
            return true;
        }
        boolean lrs = fm.isLRS();
        if (lrs) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("Excluding " + fm + " [" + dfg + "] from FastPath generation due to a @LRS. [" + lrs + "]"));
            }
            return true;
        }
        Member member = fm.getBackingMember();
        if (member != null && ((Boolean)AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction((AnnotatedElement)(el = (AnnotatedElement)((Object)fm.getBackingMember())), Strategy.class))).booleanValue()) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("Excluding " + fm + " [" + dfg + "] from FastPath generation due to a @Strategy"));
            }
            return true;
        }
        if (fm.isSerialized() || fm.isStream() || this.isUnsupportedColumnType(fm)) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("Excluding " + fm + " [" + dfg + "] from FastPath generation due to a XML Lob, serialized, " + "or stream backed field."));
            }
            return true;
        }
        return false;
    }

    private boolean isUnsupportedColumnType(FieldMapping fm) {
        Column[] cols;
        if (fm.getValueMapping() != null && (cols = fm.getValueMapping().getColumns()) != null && cols.length == 1) {
            Column col = cols[0];
            return col.getType() == 2005 || col.getType() == 2004 || col.isXML();
        }
        return false;
    }
}

