/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.fastpath.filters;

import com.ibm.ws.persistence.fastpath.ExclusionHelper;
import com.ibm.ws.persistence.fastpath.FastPathManagerFactory;
import com.ibm.ws.persistence.fastpath.filters.AbstractFilter;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import java.util.Collections;
import java.util.Set;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.meta.QueryMetaData;

class ConfigurationExclustionFilter
extends AbstractFilter {
    private final Set<String> _includes;
    private final Set<String> _excludes;

    ConfigurationExclustionFilter(WsJpaJDBCConfiguration conf) {
        super(conf);
        FastPathManagerFactory fpmf = this._conf.getFastPathManagerFactoryInstance();
        if (fpmf == null) {
            this._includes = Collections.emptySet();
            this._excludes = Collections.emptySet();
        } else {
            this._includes = fpmf.getIncludeSet();
            this._excludes = fpmf.getExcludeSet();
        }
    }

    @Override
    public boolean filter(ClassMapping cm) {
        if (ExclusionHelper.exclude(this._includes, this._excludes, cm.getDescribedTypeString())) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("The find operation for type " + cm.getDescribedTypeString() + " was excluded by the configuration."));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean filter(FieldMapping fm) {
        if (ExclusionHelper.exclude(this._includes, this._excludes, fm.toString())) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("The load operation for type " + fm + " was excluded by the configuration."));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean filter(QueryMetaData qmd) {
        if (ExclusionHelper.exclude(this._includes, this._excludes, qmd.getName())) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("The named query " + qmd.getName() + " was excluded by the configuration."));
            }
            return true;
        }
        return false;
    }
}

