/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.fastpath.filters;

import com.ibm.ws.persistence.fastpath.filters.AbstractFilter;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;

class EmbeddableFilter
extends AbstractFilter {
    EmbeddableFilter(WsJpaJDBCConfiguration conf) {
        super(conf);
    }

    @Override
    public boolean filter(ClassMapping cm) {
        if (cm.isEmbeddable()) {
            return true;
        }
        for (FieldMapping fm : cm.getFieldMappings()) {
            if (!this.filter(fm, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean filter(FieldMapping fm) {
        return this.filter(fm, false);
    }

    private boolean filter(FieldMapping fm, boolean dfg) {
        if (!fm.isEmbeddedPC()) {
            return false;
        }
        if (fm.isInDefaultFetchGroup() == dfg) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("Skipping FastPath for " + fm + ", it is an embeddedPC. dfg = " + dfg));
            }
            return true;
        }
        return false;
    }
}

