/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.fastpath.filters;

import com.ibm.ws.persistence.fastpath.filters.AnnotationFilter;
import com.ibm.ws.persistence.fastpath.filters.ConfigurationExclustionFilter;
import com.ibm.ws.persistence.fastpath.filters.EmbeddableFilter;
import com.ibm.ws.persistence.fastpath.filters.FastPathFilter;
import com.ibm.ws.persistence.fastpath.filters.InheritanceFilter;
import com.ibm.ws.persistence.fastpath.filters.LifecycleCallbackFilter;
import com.ibm.ws.persistence.fastpath.filters.RelationshipFilter;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.meta.QueryMetaData;

public class FilterManager {
    List<FastPathFilter> _filters = new ArrayList<FastPathFilter>();

    public FilterManager(WsJpaJDBCConfiguration conf) {
        this._filters.add(new AnnotationFilter(conf));
        this._filters.add(new InheritanceFilter(conf));
        this._filters.add(new RelationshipFilter(conf));
        this._filters.add(new ConfigurationExclustionFilter(conf));
        this._filters.add(new EmbeddableFilter(conf));
        this._filters.add(new LifecycleCallbackFilter(conf));
    }

    public Set<Object> filter(ClassMapping[] cms, QueryMetaData[] qmds) {
        return this.filter(cms, qmds, false);
    }

    public Set<Object> filter(ClassMapping[] cms, QueryMetaData[] qmds, boolean eagerOnly) {
        Set<Object> rejects = Collections.newSetFromMap(new ConcurrentHashMap());
        for (ClassMapping classMapping : cms) {
            if (!this.filter(classMapping)) continue;
            rejects.add(classMapping);
        }
        if (!eagerOnly) {
            for (ClassMapping classMapping : cms) {
                for (FieldMapping fm : classMapping.getFieldMappings()) {
                    ClassMapping decType;
                    if (fm.isInDefaultFetchGroup() || fm.isVersion() || fm.isPrimaryKey() || ((decType = fm.getDeclaredTypeMapping()) == null || !rejects.contains(fm.getDeclaredTypeMapping())) && !this.filter(fm)) continue;
                    rejects.add(fm);
                }
            }
        }
        for (ClassMapping classMapping : qmds) {
            if (!this.filter((QueryMetaData)classMapping)) continue;
            rejects.add(classMapping);
        }
        return rejects;
    }

    private boolean filter(ClassMapping cm) {
        for (FastPathFilter filter : this._filters) {
            if (!filter.filter(cm)) continue;
            return true;
        }
        return false;
    }

    private boolean filter(FieldMapping fm) {
        for (FastPathFilter filter : this._filters) {
            if (!filter.filter(fm)) continue;
            return true;
        }
        return false;
    }

    private boolean filter(QueryMetaData qmd) {
        for (FastPathFilter filter : this._filters) {
            if (!filter.filter(qmd)) continue;
            return true;
        }
        return false;
    }
}

