/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.fastpath.filters;

import com.ibm.ws.persistence.fastpath.filters.AbstractFilter;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;

class InheritanceFilter
extends AbstractFilter {
    InheritanceFilter(WsJpaJDBCConfiguration conf) {
        super(conf);
    }

    @Override
    public boolean filter(ClassMapping root) {
        ClassMapping cm = root;
        ClassMapping prev = null;
        do {
            String inheritance;
            if ((inheritance = cm.getMappingInfo().getHierarchyStrategy()) != null && !inheritance.equals("flat")) {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("InheritanceFilter : Type " + cm + " isn't fastpath eligible, getHierarchyStrategy=" + inheritance));
                }
                return true;
            }
            prev = cm;
        } while ((cm = root.getPCSuperclassMapping()) != null && cm != prev);
        return false;
    }

    @Override
    public boolean filter(FieldMapping fm) {
        ClassMapping declared = fm.getDeclaredTypeMapping();
        if (declared == null) {
            return false;
        }
        return this.filter(declared);
    }
}

