/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.fastpath.filters;

import com.ibm.ws.persistence.fastpath.filters.AbstractFilter;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;

class LifecycleCallbackFilter
extends AbstractFilter {
    LifecycleCallbackFilter(WsJpaJDBCConfiguration conf) {
        super(conf);
    }

    @Override
    public boolean filter(ClassMapping cm) {
        if (this.hasPostLoadCallback(cm)) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("Skipping FastPath for " + cm + ", it has a postload callback."));
            }
            return true;
        }
        for (FieldMapping fm : cm.getFieldMappings()) {
            if (!this.filter(fm, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean filter(FieldMapping fm) {
        return this.filter(fm, false);
    }

    private boolean filter(FieldMapping fm, boolean dfg) {
        if (fm.isInDefaultFetchGroup() != dfg) {
            return false;
        }
        switch (fm.getAssociationType()) {
            case 1: 
            case 2: 
            case 3: {
                if (fm.getElementMapping() == null || !this.hasPostLoadCallback(fm.getElementMapping().getDeclaredTypeMapping())) break;
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("Skipping FastPath for " + fm + ", target type has a postload callback. dfg = " + dfg));
                }
                return true;
            }
        }
        return false;
    }

    private boolean hasPostLoadCallback(ClassMapping cm) {
        if (cm != null) {
            return cm.getLifecycleMetaData().getCallbacks(2).length > 0;
        }
        return false;
    }
}

