/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.fastpath.filters;

import com.ibm.ws.persistence.fastpath.filters.AbstractFilter;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import java.util.HashSet;
import java.util.Set;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.schema.Table;

class RelationshipFilter
extends AbstractFilter {
    RelationshipFilter(WsJpaJDBCConfiguration conf) {
        super(conf);
    }

    @Override
    public boolean filter(ClassMapping cm) {
        HashSet<Table> tbls = new HashSet<Table>();
        for (FieldMapping fm : cm.getFieldMappings()) {
            if (this.filter(fm, true)) {
                return true;
            }
            if (!this.hasEagersToSameTable(tbls, fm)) continue;
            return true;
        }
        return false;
    }

    private boolean hasEagersToSameTable(Set<Table> tbls, FieldMapping fm) {
        if (!fm.isInDefaultFetchGroup()) {
            return false;
        }
        switch (fm.getAssociationType()) {
            case 2: {
                Table tbl;
                if (fm.getElementMapping() == null || fm.getElementMapping().getTypeMapping() == null || (tbl = fm.getElementMapping().getTypeMapping().getTable()) == null) break;
                if (tbls.contains(fm.getElementMapping().getTypeMapping().getTable())) {
                    return true;
                }
                tbls.add(tbl);
                break;
            }
            case 1: 
            case 3: {
                if (tbls.contains(fm.getTable())) {
                    return true;
                }
                tbls.add(fm.getTable());
            }
        }
        return false;
    }

    @Override
    public boolean filter(FieldMapping fm) {
        return this.filter(fm, false);
    }

    private boolean filter(FieldMapping fm, boolean dfg) {
        boolean inDfg = fm.isInDefaultFetchGroup();
        if (inDfg != dfg) {
            return false;
        }
        switch (fm.getAssociationType()) {
            case 2: {
                if (fm.getTypeCode() == 11 || fm.getTypeCode() == 13) {
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("Type " + fm.getDeclaringMapping() + " isn't fastpath eligible. " + fm + " is an unsupported collection type: " + fm.getTypeCode()));
                    }
                    return true;
                }
                if (this.hasEagerToSelf(fm.getDeclaringMapping(), fm.getElementMapping())) {
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("Type " + fm.getDeclaringMapping() + " isn't fastpath eligible. " + fm + " contains a relationship to the same type."));
                    }
                    return true;
                }
                if (!this.hasMultiLevelEagers(fm.getElementMapping(), fm.getMappedByMapping(), inDfg)) break;
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("Type " + fm.getDeclaringMapping() + " isn't fastpath eligible. " + fm + " contains a multi-eager relationship graph."));
                }
                return true;
            }
            case 1: 
            case 3: {
                if (this.hasEagerToSelf(fm.getDeclaringMapping(), fm.getValueMapping())) {
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("Type " + fm.getDeclaringMapping() + " isn't fastpath eligible. " + fm + " contains a relationship to the same type."));
                    }
                    return true;
                }
                if (!this.hasMultiLevelEagers(fm.getValueMapping(), fm.getMappedByMapping(), inDfg)) break;
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("Type " + fm.getDeclaringMapping() + " isn't fastpath eligible. " + fm + " contains a multi-eager relationship graph."));
                }
                return true;
            }
            case 4: {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("Type " + fm.getDeclaringMapping() + " isn't fastpath eligible. " + fm + " is a ManyToMany"));
                }
                return true;
            }
        }
        return false;
    }

    private boolean hasMultiLevelEagers(ValueMapping vm, FieldMapping m2m, boolean inDfg) {
        if (vm == null) {
            return false;
        }
        ClassMapping cm = vm.getDeclaredTypeMapping();
        if (cm == null) {
            return false;
        }
        block4: for (FieldMapping fm : cm.getFieldMappings()) {
            if (!fm.isInDefaultFetchGroup() || m2m == fm) continue;
            switch (fm.getAssociationType()) {
                case 2: {
                    if (inDfg) {
                        return true;
                    }
                    if (this.hasMultiLevelEagers(fm.getElementMapping(), fm.getMappedByMapping(), false)) {
                        return true;
                    }
                }
                case 1: 
                case 3: {
                    if (inDfg) {
                        return true;
                    }
                    if (!this.hasMultiLevelEagers(fm.getValueMapping(), fm.getMappedByMapping(), false)) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasEagerToSelf(ClassMapping cm, ValueMapping vm) {
        ClassMapping vmcm;
        if (vm != null && (vmcm = vm.getDeclaredTypeMapping()) != null) {
            return vmcm.equals((Object)cm);
        }
        return false;
    }
}

