/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.fastpath.javagen;

import com.ibm.ws.persistence.fastpath.AbstractFindFastPath;
import com.ibm.ws.persistence.fastpath.AbstractLoadFastPath;
import com.ibm.ws.persistence.fastpath.AbstractQueryFastPath;
import com.ibm.ws.persistence.fastpath.FindFastPath;
import com.ibm.ws.persistence.fastpath.LoadFastPath;
import com.ibm.ws.persistence.fastpath.QueryFastPath;
import com.ibm.ws.persistence.fastpath.util.TransferStateManager;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.persistence.util.SourceCode;
import org.apache.openjpa.util.ObjectId;
import org.apache.openjpa.util.OpenJPAId;
import org.apache.openjpa.util.Proxy;

public abstract class AbstractJavaSourceGenerator {
    public static final String FIND_POSTFIX = "$Find$FastPath";
    public static final String LOAD_POSTFIX = "$Load$FastPath";
    public static final String QUERY_POSTFIX = "$Query$FastPath";
    public static final String ABSTRACT_FINDER_FASTPATH = AbstractFindFastPath.class.getName();
    public static final String INTERFACE_FINDER_FASTHPAT = FindFastPath.class.getName();
    public static final String ABSTRACT_LOAD_FASTPATH = AbstractLoadFastPath.class.getName();
    public static final String INTERFACE_LOAD_FASTHPAT = LoadFastPath.class.getName();
    public static final String ABSTRACT_QUERY_FASTPATH = AbstractQueryFastPath.class.getName();
    public static final String INTERFACE_QUERY_FASTHPATH = QueryFastPath.class.getName();
    public static final String VAR_CM = "_cm";
    public static final String VAR_THIS_PC = "_thisPc";
    public static final String VAR_REL_PCS = "_relatedPCs";
    public static final String VAR_REL_METAS = "_relatedMetas";
    public static final String VAR_PROXY_MGR = "_proxyMgr";
    public static final String VAR_QUERY_PCS = "_pcs";
    public static final String VAR_QUERY_METAS = "_metas";
    protected final WsJpaJDBCConfiguration _conf;
    protected final MappingRepository _repo;
    protected Map<String, List<ClassMapping>> _tableNameToClassMapping = new HashMap<String, List<ClassMapping>>();
    protected Map<ClassMapping, Map<String, List<FieldMapping>>> _classMappingToStringFieldToFieldMapping = new HashMap<ClassMapping, Map<String, List<FieldMapping>>>();
    protected Map<ClassMapping, Map<String, Discriminator>> _classMappingToStringColumnToDiscriminator = new HashMap<ClassMapping, Map<String, Discriminator>>();

    public AbstractJavaSourceGenerator(MappingRepository repo) {
        this._repo = repo;
        this._conf = (WsJpaJDBCConfiguration)repo.getConfiguration();
        this.configureStringTableNameToClassMapping();
        this.configureClassMappingToStringFieldNameToFieldMapping();
        this.configureStringColumnToDiscriminator();
    }

    private void configureStringTableNameToClassMapping() {
        for (ClassMapping cm : this._repo.getMappings()) {
            Table table = cm.getTable();
            if (table == null) continue;
            String tableName = table.getIdentifier().getName().toUpperCase(Locale.ENGLISH);
            List<ClassMapping> m = this._tableNameToClassMapping.get(tableName);
            if (m == null) {
                m = new ArrayList<ClassMapping>();
                this._tableNameToClassMapping.put(tableName, m);
            }
            if (m.contains(cm)) continue;
            m.add(cm);
        }
    }

    private void configureClassMappingToStringFieldNameToFieldMapping() {
        for (Map.Entry<String, List<ClassMapping>> entry : this._tableNameToClassMapping.entrySet()) {
            List<ClassMapping> cms = entry.getValue();
            String table = entry.getKey();
            for (ClassMapping cm : cms) {
                Map<String, List<FieldMapping>> strToFm = this._classMappingToStringFieldToFieldMapping.get(cm);
                if (strToFm == null) {
                    strToFm = new HashMap<String, List<FieldMapping>>();
                    this._classMappingToStringFieldToFieldMapping.put(cm, strToFm);
                }
                for (FieldMapping fm : cm.getFieldMappings()) {
                    Column[] cols;
                    for (Column col : cols = fm.getColumns()) {
                        String colTable = col.getTable().getIdentifier().getName().toUpperCase(Locale.ENGLISH);
                        String name = col.getIdentifier().getName().toUpperCase(Locale.ENGLISH);
                        if (!colTable.equals(table)) continue;
                        List<FieldMapping> fms = strToFm.get(name);
                        if (fms == null) {
                            fms = new ArrayList<FieldMapping>();
                            strToFm.put(name, fms);
                        }
                        if (fms.contains(fm)) continue;
                        fms.add(fm);
                    }
                }
            }
        }
    }

    private void configureStringColumnToDiscriminator() {
        for (List<ClassMapping> cms : this._tableNameToClassMapping.values()) {
            for (ClassMapping cm : cms) {
                for (Column discCol : cm.getDiscriminator().getColumns()) {
                    String name = discCol.getIdentifier().getName().toUpperCase(Locale.ENGLISH);
                    Map<String, Discriminator> disc = this._classMappingToStringColumnToDiscriminator.get(cm);
                    if (disc == null) {
                        disc = new HashMap<String, Discriminator>();
                        this._classMappingToStringColumnToDiscriminator.put(cm, disc);
                    }
                    disc.put(name, cm.getDiscriminator());
                    for (ClassMapping sub : cm.getPCSubclassMappings()) {
                        this._classMappingToStringColumnToDiscriminator.put(sub, disc);
                    }
                }
            }
        }
    }

    protected String sanatizeJavaNameIdentifier(String str) {
        StringBuilder sb = new StringBuilder();
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isJavaIdentifierPart(chars[i])) {
                sb.append("$");
                sb.append((int)chars[i]);
                sb.append("$");
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    protected String generateClassName(String str) {
        StringBuilder sb = new StringBuilder(str);
        sb.insert(str.lastIndexOf(".") + 1, "_");
        return sb.toString();
    }

    protected SourceCode generateCode(String generatedFileName) {
        return new SourceCode(generatedFileName);
    }

    protected SourceCode.Class generateClsStart(SourceCode code, String iface, String abstractCls, boolean load, boolean query) {
        SourceCode.Class cls = code.getTopLevelClass();
        code.getOrCreateImport(BigInteger.class.getName());
        code.getOrCreateImport(OpenJPAId.class.getName());
        code.getOrCreateImport(PersistenceCapable.class.getName());
        code.getOrCreateImport(Collection.class.getName());
        code.getOrCreateImport(List.class.getName());
        code.getOrCreateImport(ArrayList.class.getName());
        code.getOrCreateImport(StateManagerImpl.class.getName());
        code.getOrCreateImport(FindFastPath.class.getName());
        code.getOrCreateImport(TransferStateManager.class.getName());
        code.getOrCreateImport(ResultSet.class.getName());
        code.getOrCreateImport(Map.class.getName());
        code.getOrCreateImport(HashMap.class.getName());
        code.getOrCreateImport(Proxy.class.getName());
        code.getOrCreateImport(OpenJPAStateManager.class.getName());
        code.getOrCreateImport(PCRegistry.class.getName());
        code.getOrCreateImport(ObjectId.class.getName());
        code.getOrCreateImport(ClassMapping.class.getName());
        code.getOrCreateImport(Timestamp.class.getName());
        cls.addInterface(iface).setSuper(abstractCls);
        cls.makeFinal();
        if (query) {
            SourceCode.Constructor ctor = cls.addConstructor();
            ctor.addArgument(String.class.getName(), "sql");
            ctor.addArgument(JDBCConfiguration.class.getName(), "conf");
            ctor.addArgument("java.lang.Class[]", "classes");
            ctor.addArgument("ClassMapping[]", "metas");
            ctor.addCodeLine("super(sql, conf, classes, metas);", true);
            return cls;
        }
        SourceCode.Constructor ctor = cls.addConstructor();
        ctor.addArgument(String.class.getName(), "sql");
        ctor.addArgument(ClassMapping.class.getName(), "cm");
        if (load) {
            ctor.addArgument(FieldMapping.class.getName(), "fm");
        }
        ctor.addArgument(JDBCConfiguration.class.getName(), "conf");
        if (load) {
            ctor.addCodeLine("super(sql,cm,fm,conf);", true);
        } else {
            ctor.addCodeLine("super(sql,cm,conf);", true);
        }
        return cls;
    }

    public List<ClassMapping> getClassMappingsByTableName(String name) {
        return this._tableNameToClassMapping.get(name);
    }

    public Map<String, List<FieldMapping>> getFieldMappingsMap(ClassMapping cm) {
        return this._classMappingToStringFieldToFieldMapping.get(cm);
    }

    public Collection<FieldMapping> getFieldMapping(String tableName, String fieldName) {
        HashSet<FieldMapping> res = new HashSet<FieldMapping>();
        List<ClassMapping> cms = this._tableNameToClassMapping.get(tableName.toUpperCase(Locale.ENGLISH));
        if (cms == null) {
            throw new UnsupportedOperationException("Unable to find which ClassMapping for the table.FieldName " + tableName + "." + fieldName);
        }
        for (ClassMapping cm : cms) {
            Map<String, List<FieldMapping>> sfm = this._classMappingToStringFieldToFieldMapping.get(cm);
            List<FieldMapping> fms = sfm.get(fieldName.toUpperCase(Locale.ENGLISH));
            if (fms == null) continue;
            res.addAll(fms);
        }
        return res;
    }

    public Class<PersistenceCapable>[] getPCTypes(ClassMapping[] cms) {
        Class[] res = new Class[cms.length];
        for (int i = 0; i < cms.length; ++i) {
            res[i] = cms[i].getDescribedType();
        }
        return res;
    }
}

