/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.fastpath.javagen;

import com.ibm.ws.persistence.QueryImpl;
import com.ibm.ws.persistence.fastpath.FastPathManager;
import com.ibm.ws.persistence.fastpath.javagen.AbstractJavaSourceGenerator;
import com.ibm.ws.persistence.fastpath.util.PrimaryKeyFieldManager;
import com.ibm.ws.persistence.fastpath.util.TransferStateManager;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import com.ibm.ws.persistence.kernel.WsJpaBrokerImpl;
import com.ibm.ws.persistence.objectcache.ObjectCache;
import com.ibm.ws.persistence.objectcache.ObjectCacheManager;
import java.io.PrintWriter;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.JavaSQLTypes;
import org.apache.openjpa.jdbc.meta.Joinable;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.strats.EnumValueHandler;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.lib.util.OrderedMap;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.util.SourceCode;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.OpenJPAId;
import org.apache.openjpa.util.UnsupportedException;

public class JavaSourceGenerator
extends AbstractJavaSourceGenerator {
    private static final Localizer _loc = Localizer.forPackage(JavaSourceGenerator.class);
    static boolean debug = Boolean.valueOf(System.getProperty("FastPathBuilder.debug", "false"));
    private final String PARAM_FIND_ID = "oid";
    private final String PARAM_TSM = "tsm";
    private final String PARAM_DICT = "_dict";
    private final String PARAM_STMT = "stmt";
    private final String PARAM_BROKER = "broker";
    private final String PARAM_PKFM = "pkfm";
    private final String PARAM_LOAD_PC = "owner";
    private final String PARAM_QUERY_PARAMS = "params";
    private ObjectCache _oc;
    private boolean _ocInit = false;
    private final WsJpaJDBCConfiguration _conf;
    private final boolean _checkCacheForLazyOids;
    private static Pattern tablesPattern = Pattern.compile("(JOIN [_a-zA-Z0-9]+)+|(FROM [_a-zA-Z0-9]+)+");

    public JavaSourceGenerator(MappingRepository repo, WsJpaJDBCConfiguration conf) {
        super(repo);
        this._conf = conf;
        Options bProps = Configurations.parseProperties((String)Configurations.getProperties((String)conf.getBrokerImpl()));
        String str = bProps.getProperty("checkCacheForLazyFields", "false");
        this._checkCacheForLazyOids = Boolean.parseBoolean(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectCache getObjectCache() {
        if (!this._ocInit) {
            JavaSourceGenerator javaSourceGenerator = this;
            synchronized (javaSourceGenerator) {
                if (!this._ocInit) {
                    ObjectCacheManager ocm = this._conf.getObjectCacheManagerInstance(null);
                    this._oc = ocm != null ? ocm.getCache() : null;
                }
                this._ocInit = true;
            }
        }
        return this._oc;
    }

    public String generateLoadFastPath(FieldMapping loadingField, ResultSetMetaData rsmd, PrintWriter out, FetchPlan fetchPlan, String sql, ParameterMetaData pmd) throws SQLException {
        JavaSourceGenerator.checkSQL(sql);
        ClassMapping loadingType = this._repo.getMapping(loadingField.getRelationType(), null, true);
        String puName = loadingField.getRepository().getConfiguration().getId();
        String clsName = this.generateClassName(loadingField.getDeclaringMapping().getDescribedTypeString() + "$" + loadingField.getName() + "$" + this.sanatizeJavaNameIdentifier(puName) + "$Load$FastPath");
        SourceCode code = this.generateCode(clsName);
        SourceCode.Class cls = this.generateClsStart(code, INTERFACE_LOAD_FASTHPAT, ABSTRACT_LOAD_FASTPATH, true, false);
        SourceCode.Method meth = this.addLoadDataMethod(cls);
        meth.addCodeLine("try {");
        meth.addCodeLine("", true);
        this.addSetParametersForLoad(meth, loadingField, loadingType, pmd);
        this.addProcessLoadResultSet(meth, loadingField, loadingType, rsmd, fetchPlan);
        meth.addCodeLine("}catch(java.lang.Exception e){", false);
        meth.addCodeLine("throw new java.lang.RuntimeException(e);", true);
        meth.addCodeLine("}", false);
        meth.addCodeLine("return false;");
        code.write(out);
        return cls.getPackageName() + "." + cls.getName();
    }

    public String generateFindFastPath(ClassMapping cm, ResultSetMetaData rsmd, PrintWriter out, FetchPlan fetchPlan, String sql, ParameterMetaData pmd) throws SQLException {
        JavaSourceGenerator.checkSQL(sql);
        String puName = this.sanatizeJavaNameIdentifier(cm.getRepository().getConfiguration().getId());
        ClassMapping[] eagers = JavaSourceGenerator.getEagers(cm, fetchPlan);
        String clsName = this.generateClassName(cm.getDescribedTypeString() + "$" + puName + "$Find$FastPath");
        SourceCode code = this.generateCode(clsName);
        SourceCode.Class cls = this.generateClsStart(code, INTERFACE_FINDER_FASTHPAT, ABSTRACT_FINDER_FASTPATH, false, false);
        SourceCode.Method meth = this.addLoadMethod(cls);
        meth.addCodeLine("try {");
        meth.addCodeLine("", true);
        this.addSetParameters(meth, cm, null, "oid", "_thisPc", true, pmd);
        this.addProcessFindResultSet(meth, cm, rsmd, eagers, "oid", fetchPlan);
        meth.addCodeLine("}catch(java.lang.Exception e){", false);
        meth.addCodeLine("throw new java.lang.RuntimeException(e);", true);
        meth.addCodeLine("}", false);
        code.write(out);
        return cls.getPackageName() + "." + cls.getName();
    }

    public String generateQueryFastPath(FastPathManager fpm, ResultSetMetaData rsmd, QueryImpl<?> query, QueryMetaData qmd, PrintWriter out, FetchPlan fetchPlan, String sql, ParameterMetaData pmd) throws SQLException {
        Class resultType = query.getDelegate().getResultType();
        org.apache.openjpa.kernel.QueryImpl qi = (org.apache.openjpa.kernel.QueryImpl)query.getDelegate();
        Object[] projections = qi.getProjectionTypes();
        if (resultType != null) {
            if (!fpm.isFastPathEligible(resultType)) {
                throw new UnsupportedException("[ " + qmd + " ] : Result type = [ " + resultType + " ]");
            }
        } else if (projections != null && projections.length > 0) {
            throw new UnsupportedException("Unable to fastpath query [ " + qmd + " ] with projections . " + Arrays.toString(projections));
        }
        JavaSourceGenerator.checkSQL(sql);
        String lang = qmd.getLanguage();
        if (lang == null || !lang.equals("javax.persistence.JPQL")) {
            throw new UnsupportedException("Unsupported query language : [ " + lang + "]");
        }
        String puName = this.sanatizeJavaNameIdentifier(qi.getBroker().getBrokerFactory().getConfiguration().getId());
        String qmdName = this.sanatizeJavaNameIdentifier(qmd.getName());
        String clsName = this.generateClassName(qmd.getDefiningType().getPackage().getName() + "." + qmd.getDefiningType().getSimpleName() + "$" + qmdName + "$" + puName + "$Query$FastPath");
        SourceCode code = this.generateCode(clsName);
        SourceCode.Class cls = this.generateClsStart(code, INTERFACE_QUERY_FASTHPATH, ABSTRACT_QUERY_FASTPATH, false, true);
        SourceCode.Method meth = this.addGetResultListMethod(cls);
        meth.addCodeLine("try {");
        meth.addCodeLine("", true);
        this.addSetParametersQuery(meth, query, pmd);
        this.addProcessQueryResultSet(meth, rsmd, query, fetchPlan);
        meth.addCodeLine("}catch(java.lang.Exception e){", false);
        meth.addCodeLine("throw new java.lang.RuntimeException(e);", true);
        meth.addCodeLine("}", false);
        code.write(out);
        return clsName;
    }

    public ClassMapping[] findQueryEagers(ResultSetMetaData rsmd, Class<?> candidate, FetchPlan fetchPlan) {
        ArrayList<ClassMapping> result = new ArrayList<ClassMapping>();
        ClassMapping root = this._repo.getMapping(candidate, null, true);
        result.add(root);
        block4: for (FieldMapping fm : root.getFieldMappings()) {
            if (!JavaSourceGenerator.needsFetch(fetchPlan, fm)) continue;
            switch (fm.getAssociationType()) {
                case 1: 
                case 3: {
                    result.add(fm.getDeclaredTypeMapping());
                    continue block4;
                }
                case 2: {
                    result.add((ClassMapping)fm.getElement().getDeclaredTypeMetaData());
                }
            }
        }
        return result.toArray(new ClassMapping[0]);
    }

    /*
     * WARNING - void declaration
     */
    private SourceCode.Method addProcessQueryResultSetRow(SourceCode.Method meth, ResultSetMetaData rsmd, QueryImpl<?> pQuery, String varRs, String varResult, FetchPlan fetchPlan) throws SQLException {
        void var14_18;
        Class candidate = pQuery.getDelegate().getCandidateType();
        ClassMapping root = this._repo.getMapping(candidate, null, true);
        Object[] loadings = this.findQueryEagers(rsmd, candidate, fetchPlan);
        ArrayList<ClassMapping> t = new ArrayList<ClassMapping>();
        for (ClassMapping classMapping : loadings) {
            if (classMapping == root) continue;
            t.add(classMapping);
        }
        ClassMapping[] eagers = t.toArray(new ClassMapping[0]);
        if (debug) {
            meth.addCodeLine("// start addProcessQueryResultSetRow [ " + Arrays.toString(loadings) + " ] " + candidate);
        }
        String[] keys = this.addProcessResultSetPks(meth, rsmd, varRs, (ClassMapping[])loadings);
        int i = 0;
        for (Object loading : loadings) {
            String varSm = loading.getDescribedType().getSimpleName().toLowerCase() + "Sm";
            String varPc = loading.getDescribedType().getSimpleName().toLowerCase() + "Pc";
            this.addProcessResultSetCreateInstance(meth, (ClassMapping)loading, rsmd, varSm, varPc, varRs, keys[i], "_metas[" + i + "]");
            ++i;
        }
        i = 0;
        Object var14_17 = null;
        String[] relatedPcs = new String[loadings.length - 1];
        int relatedPcsindex = 0;
        for (Object loading : loadings) {
            String varSm = loading.getDescribedType().getSimpleName().toLowerCase() + "Sm";
            String varPc = loading.getDescribedType().getSimpleName().toLowerCase() + "Pc";
            String pcs = this.addProcessResultSet(meth, (ClassMapping)loading, rsmd, varSm, varPc, varRs, keys[i], "_metas[" + i + "]", fetchPlan);
            if (loading != root) {
                relatedPcs[relatedPcsindex] = pcs;
                ++relatedPcsindex;
            } else {
                String string = varSm;
            }
            ++i;
        }
        this.addProcessLoadResultEagerRelationships(meth, (String)var14_18, root, eagers, relatedPcs, fetchPlan);
        String varPc = root.getDescribedType().getSimpleName().toLowerCase() + "Pc";
        meth.addCodeLine("if(!" + varResult + ".contains(" + varPc + ")) {");
        meth.addCodeLine(varResult + ".add(" + varPc + ");", true);
        meth.addCodeLine("}", false);
        if (debug) {
            meth.addCodeLine("// end addProcessQueryResultSetRow");
        }
        return meth;
    }

    private SourceCode.Method addProcessQueryResultSet(SourceCode.Method meth, ResultSetMetaData rsmd, QueryImpl<?> pQuery, FetchPlan fetchPlan) throws SQLException {
        if (debug) {
            meth.addCodeLine("// start addProcessQueryResultSet [ " + pQuery + " ]");
        }
        String varResult = "res";
        String varRs = "rs";
        meth.addCodeLine("List " + varResult + " = new ArrayList();");
        meth.addCodeLine("ResultSet " + varRs + " = " + "stmt" + ".executeQuery();");
        meth.addCodeLine("try {");
        meth.addCodeLine("if(!" + varRs + ".next())", true);
        meth.addCodeLine("return " + varResult + ";", true);
        meth.addCodeLine("do {", false);
        meth.addCodeLine("", true);
        this.addProcessQueryResultSetRow(meth, rsmd, pQuery, varRs, varResult, fetchPlan);
        meth.addCodeLine("} while (" + varRs + ".next())", false);
        meth.addCodeLine("return " + varResult + ";");
        meth.addCodeLine("} catch(Exception e) {", false);
        meth.addCodeLine("throw new RuntimeException(e);", true);
        meth.addCodeLine("} finally {", false);
        meth.addCodeLine(varRs + ".close();", true);
        meth.addCodeLine("}", false);
        if (debug) {
            meth.addCodeLine("// end addProcessQueryResultSet");
        }
        return meth;
    }

    private SourceCode.Method addProcessLoadResultSet(SourceCode.Method meth, FieldMapping loadingField, ClassMapping loadingType, ResultSetMetaData rsmd, FetchPlan fetchPlan) throws SQLException {
        int i;
        if (debug) {
            meth.addCodeLine("// start addProcessLoadResultSet");
        }
        ClassMapping[] eagers = JavaSourceGenerator.getEagers(loadingType, fetchPlan);
        boolean loadingToOne = loadingField.getAssociationType() == 1 || loadingField.getAssociationType() == 3;
        ArrayList<ClassMapping> cms = new ArrayList<ClassMapping>(Arrays.asList(eagers));
        for (ClassMapping cm : eagers) {
            if (cm != loadingField.getDeclaringMapping()) continue;
            cms.remove(cm);
        }
        eagers = cms.toArray(new ClassMapping[0]);
        String varSm = "sm";
        String varPc = "pc";
        String varRs = "rs";
        meth.addCodeLine("ResultSet " + varRs + " = " + "stmt" + ".executeQuery();");
        meth.addCodeLine("try {");
        String varRes = null;
        if (!loadingToOne) {
            varRes = "col";
            meth.addCodeLine("Collection " + varRes + " = null;");
            meth.addCodeLine("boolean delayed = ((OpenJPAStateManager)owner.pcGetStateManager()).isDelayed(" + loadingField.getIndex() + ");");
            meth.addCodeLine("if(delayed){");
            meth.addCodeLine(varRes + " = (Collection)((OpenJPAStateManager)" + "owner" + ".pcGetStateManager()).fetchObjectField(" + loadingField.getIndex() + ");", true);
            meth.addCodeLine("} else {", false);
            meth.addCodeLine(varRes + " =  (Collection)" + "_proxyMgr" + ".newCollectionProxy(" + loadingField.getProxyType().getName() + ".class," + loadingType.getDescribedType().getName() + ".class,null," + this._conf.getCompatibilityInstance().getAutoOff() + ");", true);
            meth.addCodeLine("}", false);
        }
        meth.addCodeLine("if(!rs.next()){", true);
        if (loadingToOne) {
            meth.addCodeLine("((OpenJPAStateManager)owner.pcGetStateManager()).store(" + loadingField.getIndex() + "," + varRes + ");", true);
            meth.addCodeLine("return false;");
            meth.addCodeLine("}", false);
        } else {
            meth.addCodeLine("if(!delayed){", true);
            meth.addCodeLine("((OpenJPAStateManager)owner.pcGetStateManager()).store(" + loadingField.getIndex() + "," + varRes + ");", true);
            meth.addCodeLine("Proxy proxy = (Proxy)" + varRes + ";");
            meth.addCodeLine("proxy.setOwner((OpenJPAStateManager)owner.pcGetStateManager()," + loadingField.getIndex() + ");");
            meth.addCodeLine("proxy.getChangeTracker().startTracking();");
            meth.addCodeLine("}", false);
            meth.addCodeLine("return false;");
            meth.addCodeLine("}", false);
            meth.addCodeLine("do {");
            meth.addCodeLine("", true);
        }
        String varOidLoadingType = this.addProcessResultSetPks(meth, rsmd, varRs, loadingType)[0];
        String[] varOidEagers = this.addProcessResultSetPks(meth, rsmd, varRs, eagers);
        String[] relatedPcs = new String[varOidEagers.length];
        this.addProcessResultSetCreateInstance(meth, loadingType, rsmd, varSm, varPc, varRs, varOidLoadingType, "_cm");
        for (i = 0; i < varOidEagers.length; ++i) {
            this.addProcessResultSetCreateInstance(meth, eagers[i], rsmd, varOidEagers[i] + varSm, varOidEagers[i] + varPc, varRs, varOidEagers[i], "_relatedMetas[" + JavaSourceGenerator.calculateRelatedMetasIndex(loadingType, eagers[i]) + "]");
        }
        this.addProcessResultSet(meth, loadingType, rsmd, varSm, varPc, varRs, varOidLoadingType, "_cm", fetchPlan);
        for (i = 0; i < varOidEagers.length; ++i) {
            relatedPcs[i] = this.addProcessResultSet(meth, eagers[i], rsmd, varOidEagers[i] + varSm, varOidEagers[i] + varPc, varRs, varOidEagers[i], "_relatedMetas[" + JavaSourceGenerator.calculateRelatedMetasIndex(loadingType, eagers[i]) + "]", fetchPlan);
        }
        this.addProcessLoadResultEagerRelationships(meth, varSm, loadingType, eagers, relatedPcs, fetchPlan);
        if (loadingToOne) {
            meth.addCodeLine("((OpenJPAStateManager)owner.pcGetStateManager()).store(" + loadingField.getIndex() + "," + varPc + ");");
        } else {
            meth.addCodeLine(varRes + ".add(" + varPc + ");");
            meth.addCodeLine("} while(rs.next())", false);
            meth.addCodeLine("if(!delayed){", true);
            meth.addCodeLine("((OpenJPAStateManager)owner.pcGetStateManager()).store(" + loadingField.getIndex() + "," + varRes + ");");
            meth.addCodeLine("Proxy proxy = (Proxy)" + varRes + ";");
            meth.addCodeLine("proxy.setOwner((OpenJPAStateManager)owner.pcGetStateManager()," + loadingField.getIndex() + ");");
            meth.addCodeLine("proxy.getChangeTracker().startTracking();");
            meth.addCodeLine("}", false);
        }
        meth.addCodeLine("} finally {", false);
        meth.addCodeLine(varRs + ".close();", true);
        meth.addCodeLine("}", false);
        if (debug) {
            meth.addCodeLine("// end addProcessLoadResultSet");
        }
        return meth;
    }

    private SourceCode.Method addProcessLoadResultEagerRelationships(SourceCode.Method meth, String varSm, ClassMapping rootCm, ClassMapping[] eagers, String[] relatedPcs, FetchPlan fetchPlan) throws SQLException {
        if (debug) {
            meth.addCodeLine("// start addProcessLoadResultEagerRelationships");
        }
        for (int i = 0; i < eagers.length; ++i) {
            ClassMapping eager = eagers[i];
            for (FieldMapping fm : rootCm.getFieldMappings()) {
                if (!JavaSourceGenerator.needsFetch(fetchPlan, fm)) continue;
                if (eager == fm.getDeclaredTypeMapping()) {
                    meth.addCodeLine(varSm + ".store(" + fm.getIndex() + "," + relatedPcs[i] + ");");
                }
                if (fm.getAssociationType() != 2 || eager != fm.getElement().getDeclaredTypeMetaData()) continue;
                meth.addCodeLine(varSm + ".getPersistenceCapable().pcReplaceStateManager(" + "tsm" + ");");
                if (fm.getDeclaredTypeCode() == 11) {
                    throw new UnsupportedException("Unsupported. ToMany via an Array. " + fm);
                }
                String collectionVar = "collection$" + fm.getName();
                meth.addCodeLine(varSm + ".getPersistenceCapable().pcProvideField(" + fm.getIndex() + ");");
                meth.addCodeLine("Collection " + collectionVar + " = (Collection)" + "tsm" + ".getObject();");
                meth.addCodeLine("if ( " + collectionVar + " == null) {");
                meth.addCodeLine(collectionVar + " = (Collection) " + "_proxyMgr" + ".newCollectionProxy(" + fm.getProxyType().getName() + ".class, " + fm.getDeclaredType().getName() + ".class, null, " + this._conf.getCompatibilityInstance().getAutoOff() + ");", true);
                meth.addCodeLine("tsm.setObject(" + collectionVar + ");");
                meth.addCodeLine(varSm + ".getPersistenceCapable().pcReplaceField(" + fm.getIndex() + ");");
                meth.addCodeLine("}", false);
                meth.addCodeLine(varSm + ".getPersistenceCapable().pcReplaceStateManager(" + varSm + ");");
                meth.addCodeLine(collectionVar + ".add(" + relatedPcs[i] + ");");
            }
        }
        if (debug) {
            meth.addCodeLine("// end addProcessLoadResultEagerRelationships");
        }
        return meth;
    }

    private SourceCode.Method addProcessFindResultSet(SourceCode.Method meth, ClassMapping cm, ResultSetMetaData rsmd, ClassMapping[] eagers, String varOid, FetchPlan fetchPlan) throws SQLException {
        int i;
        boolean hasEagerToMany = JavaSourceGenerator.hasEagerToMany(cm, fetchPlan);
        if (debug) {
            meth.addCodeLine("// start addProcessFindResultSet");
        }
        String varSm = "sm";
        String varPc = "pc";
        String varRs = "rs";
        String varResult = "res";
        meth.addCodeLine("Object " + varResult + " = null;");
        meth.addCodeLine("ResultSet " + varRs + " = " + "stmt" + ".executeQuery();");
        meth.addCodeLine("try {");
        meth.addCodeLine("if(!rs.next())", true);
        meth.addCodeLine("return " + varResult + ";", true);
        meth.addCodeLine("", false);
        if (hasEagerToMany) {
            meth.addCodeLine("do {");
            meth.addCodeLine("", true);
        }
        String[] varOidEagers = this.addProcessResultSetPks(meth, rsmd, varRs, eagers);
        String[] relatedPcs = new String[varOidEagers.length];
        this.addProcessResultSetCreateInstance(meth, cm, rsmd, varSm, varPc, varRs, varOid, "_cm");
        meth.addCodeLine(varResult + " = " + varPc + ";");
        for (i = 0; i < varOidEagers.length; ++i) {
            this.addProcessResultSetCreateInstance(meth, eagers[i], rsmd, varOidEagers[i] + varSm, varOidEagers[i] + varPc, varRs, varOidEagers[i], "_relatedMetas[" + JavaSourceGenerator.calculateRelatedMetasIndex(cm, eagers[i]) + "]");
        }
        this.addProcessResultSet(meth, cm, rsmd, varSm, varPc, varRs, varOid, "_cm", fetchPlan);
        for (i = 0; i < varOidEagers.length; ++i) {
            relatedPcs[i] = this.addProcessResultSet(meth, eagers[i], rsmd, varOidEagers[i] + varSm, varOidEagers[i] + varPc, varRs, varOidEagers[i], "_relatedMetas[" + JavaSourceGenerator.calculateRelatedMetasIndex(cm, eagers[i]) + "]", fetchPlan);
        }
        this.addProcessLoadResultEagerRelationships(meth, varSm, cm, eagers, relatedPcs, fetchPlan);
        if (hasEagerToMany) {
            meth.addCodeLine("", false);
            meth.addCodeLine("} while ( " + varRs + ".next() );");
        }
        meth.addCodeLine("return " + varResult + ";");
        meth.addCodeLine("} finally {", false);
        meth.addCodeLine(varRs + ".close();", true);
        meth.addCodeLine("}", false);
        if (debug) {
            meth.addCodeLine("// end addProcessFindResultSet");
        }
        return meth;
    }

    private String[] addProcessResultSetPks(SourceCode.Method meth, ResultSetMetaData rsmd, String varRs, ClassMapping ... loadingTypes) throws SQLException {
        if (debug) {
            meth.addCodeLine("// start addProcessLoadResultSetPks " + Arrays.toString(loadingTypes));
        }
        ArrayList<String> oidVars = new ArrayList<String>();
        for (ClassMapping loadingType : loadingTypes) {
            ArrayList<Column> columns = new ArrayList<Column>();
            KeyType keyType = this.getKeyType(loadingType);
            for (FieldMapping pk : loadingType.getPrimaryKeyFieldMappings()) {
                for (Column pkCol : pk.getColumns()) {
                    columns.add(pkCol);
                }
            }
            oidVars.add(this.addProcessResultSetKey(meth, rsmd, "Pk", varRs, loadingType, keyType, columns.toArray(new Column[0])));
        }
        if (debug) {
            meth.addCodeLine("// end addProcessLoadResultSetPks");
        }
        return oidVars.toArray(new String[0]);
    }

    private String addProcessResultSetKey(SourceCode.Method meth, ResultSetMetaData rsmd, String varPostFix, String varRs, ClassMapping keyType, KeyType key, Column ... columns) throws SQLException {
        if (debug) {
            meth.addCodeLine("// start addProcessResultSetKey " + Arrays.toString(columns));
        }
        String oidVar = "oid" + keyType.getDescribedType().getSimpleName() + varPostFix;
        String varOidValues = "oidValues" + keyType.getDescribedType().getSimpleName() + varPostFix;
        String nullOidValue = oidVar + "NullValue" + varPostFix;
        meth.addCodeLine("boolean " + nullOidValue + " = false;");
        meth.addCodeLine("OpenJPAId " + oidVar + " = null;");
        meth.addCodeLine("Object[] " + varOidValues + " = new Object[" + columns.length + "];");
        String oidTypeString = null;
        String oidValueTypeString = null;
        int index = 0;
        for (Column pkCol : columns) {
            int fieldIndex = JavaSourceGenerator.getColumnIndex(pkCol, rsmd);
            switch (pkCol.getJavaType()) {
                case 14: {
                    meth.addCodeLine(varOidValues + "[" + index + "]" + " = " + varRs + ".getDate(" + fieldIndex + ");");
                    oidTypeString = "new org.apache.openjpa.util.DateId";
                    oidValueTypeString = "(java.util.Date)";
                    break;
                }
                case 1007: {
                    meth.addCodeLine(varOidValues + "[" + index + "]" + " = " + varRs + ".getDate(" + fieldIndex + ", null);");
                    oidTypeString = "new org.apache.openjpa.util.DateId";
                    oidValueTypeString = "(java.util.Date)";
                    break;
                }
                case 1010: {
                    meth.addCodeLine(varOidValues + "[" + index + "]" + " = " + "_dict" + ".getTime(" + varRs + "," + fieldIndex + ", java.util.Calendar.getInstance());");
                    oidTypeString = "new org.apache.openjpa.util.DateId";
                    oidValueTypeString = "(java.sql.Time)";
                    break;
                }
                case 1011: {
                    meth.addCodeLine(varOidValues + "[" + index + "]" + " = " + "_dict" + ".getTimestamp(" + varRs + "," + fieldIndex + ", java.util.Calendar.getInstance());");
                    oidTypeString = "new org.apache.openjpa.util.DateId";
                    oidValueTypeString = "(java.sql.Timestamp)";
                    break;
                }
                case 0: 
                case 16: {
                    meth.addCodeLine(varOidValues + "[" + index + "]" + " = (" + varRs + ".getBoolean(" + fieldIndex + ")) ? java.lang.Boolean.TRUE : java.lang.Boolean.FALSE;");
                    oidTypeString = "new org.apache.openjpa.util.BooleanId";
                    oidValueTypeString = "(java.lang.Boolean)";
                    break;
                }
                case 2: 
                case 18: {
                    meth.addCodeLine(varOidValues + "[" + index + "]" + " = " + "_dict" + ".getChar(" + varRs + ", " + fieldIndex + ");");
                    oidTypeString = "new org.apache.openjpa.util.CharId";
                    oidValueTypeString = "(java.lang.Character)";
                    break;
                }
                case 24: {
                    meth.addCodeLine(varOidValues + "[" + index + "]" + " = " + "_dict" + ".getBigDecimal(" + varRs + ", " + fieldIndex + ");");
                    oidTypeString = "new org.apache.openjpa.util.BigDecimalId";
                    oidValueTypeString = "(java.math.BigDecimal)";
                    break;
                }
                case 25: {
                    meth.addCodeLine(varOidValues + "[" + index + "]" + " = " + "_dict" + ".getBigInteger(" + varRs + ", " + fieldIndex + ");");
                    oidTypeString = "new org.apache.openjpa.util.BigIntegerId";
                    oidValueTypeString = "(java.math.BigInteger)";
                    break;
                }
                case 1: 
                case 17: {
                    meth.addCodeLine(varOidValues + "[" + index + "]" + " = " + "_dict" + ".getByte(" + varRs + ", " + fieldIndex + ");");
                    oidTypeString = "new org.apache.openjpa.util.ByteId";
                    oidValueTypeString = "(java.lang.Byte)";
                    break;
                }
                case 3: 
                case 19: {
                    meth.addCodeLine(varOidValues + "[" + index + "]" + " = " + "_dict" + ".getDouble(" + varRs + ", " + fieldIndex + ");");
                    oidTypeString = "new org.apache.openjpa.util.DoubleId";
                    oidValueTypeString = "(java.lang.Double)";
                    break;
                }
                case 4: 
                case 20: {
                    meth.addCodeLine(varOidValues + "[" + index + "]" + " = " + "_dict" + ".getFloat(" + varRs + ", " + fieldIndex + ");");
                    oidTypeString = "new org.apache.openjpa.util.FloatId";
                    oidValueTypeString = "(java.lang.Float)";
                    break;
                }
                case 5: 
                case 21: {
                    meth.addCodeLine(varOidValues + "[" + index + "]" + " = " + "_dict" + ".getInt(" + varRs + ", " + fieldIndex + ");");
                    oidTypeString = "new org.apache.openjpa.util.IntId";
                    oidValueTypeString = "(java.lang.Integer)";
                    break;
                }
                case 6: 
                case 22: {
                    meth.addCodeLine(varOidValues + "[" + index + "]" + " = " + "_dict" + ".getLong(" + varRs + ", " + fieldIndex + ");");
                    oidTypeString = "new org.apache.openjpa.util.LongId";
                    oidValueTypeString = "(java.lang.Long)";
                    break;
                }
                case 7: 
                case 23: {
                    meth.addCodeLine(varOidValues + "[" + index + "]" + " = " + "_dict" + ".getShort(" + varRs + ", " + fieldIndex + ");");
                    oidTypeString = "new org.apache.openjpa.util.ShortId";
                    oidValueTypeString = "(java.lang.Short)";
                    break;
                }
                case 9: {
                    meth.addCodeLine(varOidValues + "[" + index + "]" + " = " + "_dict" + ".getString(" + varRs + ", " + fieldIndex + ");");
                    oidTypeString = "new org.apache.openjpa.util.StringId";
                    oidValueTypeString = "(java.lang.String)";
                    break;
                }
                default: {
                    throw new UnsupportedException("type = " + pkCol.getJavaType());
                }
            }
            ++index;
            meth.addCodeLine("if(" + varRs + ".wasNull())");
            meth.addCodeLine(nullOidValue + " = true;", true);
            meth.addCodeLine("", false);
        }
        meth.addCodeLine("if(!" + nullOidValue + "){");
        meth.addCodeLine("// space", true);
        switch (key) {
            case ID_CLASS: {
                meth.addCodeLine(oidVar + " = (OpenJPAId) PCRegistry.newObjectId(" + keyType.getDescribedType().getName() + ".class);");
                meth.addCodeLine("pkfm.setStore(" + varOidValues + ");");
                meth.addCodeLine("PCRegistry.copyKeyFieldsToObjectId(" + keyType.getDescribedType().getName() + ".class," + "pkfm" + "," + oidVar + ");");
                meth.addCodeLine("");
                break;
            }
            case BASIC: {
                meth.addCodeLine(oidVar + " = " + oidTypeString + "(" + keyType.getDescribedType().getName() + ".class, " + oidValueTypeString + " " + varOidValues + "[0])");
                break;
            }
            case EMBEDDED: {
                ClassMapping embed = keyType;
                String embeddedKeyType = keyType.getPrimaryKeyFieldMappings()[0].getType().getName();
                String oidPc = keyType.getDescribedType().getSimpleName() + "OidPc";
                meth.addCodeLine("PersistenceCapable " + oidPc + " =  PCRegistry.newInstance(" + embeddedKeyType + ".class, " + "tsm" + ", false);");
                meth.addCodeLine(oidVar + " = new ObjectId(" + embed.getDescribedType().getName() + ".class, " + oidPc + ");");
                index = 0;
                for (Column pkCol : columns) {
                    switch (pkCol.getJavaType()) {
                        case 2: {
                            meth.addCodeLine("tsm.setChar((java.lang.Character)" + varOidValues + "[" + index + "]);");
                            break;
                        }
                        case 3: {
                            meth.addCodeLine("tsm.setDouble((Double)" + varOidValues + "[" + index + "]);");
                            break;
                        }
                        case 5: {
                            meth.addCodeLine("tsm.setInt((Integer)" + varOidValues + "[" + index + "]);");
                            break;
                        }
                        case 4: {
                            meth.addCodeLine("tsm.setFloat((Float)" + varOidValues + "[" + index + "]);");
                            break;
                        }
                        case 7: {
                            meth.addCodeLine("tsm.setShort((Short)" + varOidValues + "[" + index + "]);");
                            break;
                        }
                        case 6: {
                            meth.addCodeLine("tsm.setLong((Long)" + varOidValues + "[" + index + "]);");
                            break;
                        }
                        case 9: {
                            meth.addCodeLine("tsm.setString((String)" + varOidValues + "[" + index + "]);");
                            break;
                        }
                        case 0: {
                            meth.addCodeLine("tsm.setBoolean((Boolean)" + varOidValues + "[" + index + "]);");
                            break;
                        }
                        case 1: {
                            meth.addCodeLine("tsm.setByte((Byte)" + varOidValues + "[" + index + "]);");
                            break;
                        }
                        case 14: 
                        case 16: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 1007: 
                        case 1010: 
                        case 1011: {
                            meth.addCodeLine("tsm.setObject(" + varOidValues + "[" + index + "]);");
                            break;
                        }
                        default: {
                            throw new UnsupportedException("embedded id [" + pkCol + "] type -> " + pkCol.getJavaType());
                        }
                    }
                    meth.addCodeLine(oidPc + ".pcReplaceField(" + index + ");");
                    ++index;
                }
                meth.addCodeLine(oidPc + ".pcReplaceStateManager(null);");
            }
        }
        meth.addCodeLine("}", false);
        if (debug) {
            meth.addCodeLine("// end addProcessResultSetKey " + oidVar);
        }
        return oidVar;
    }

    private String addProcessResultSetCreateInstance(SourceCode.Method meth, ClassMapping cm, ResultSetMetaData rsmd, String varSm, String varPc, String varRs, String oid, String varCm) throws SQLException {
        if (debug) {
            meth.addCodeLine("// start addProcessResultSetCreateInstance [" + cm + "]");
        }
        ClassMapping root = JavaSourceGenerator.getRootPC(cm);
        Discriminator discriminator = root.getDiscriminator();
        Column[] discriminatorColumns = discriminator.getColumns();
        Column discriminatorColumn = null;
        if (discriminatorColumns.length > 0) {
            if (discriminatorColumns.length != 1) {
                throw new InternalException();
            }
            discriminatorColumn = discriminatorColumns[0];
        }
        String discVar = "disc" + cm.getDescribedType().getSimpleName();
        if (discriminatorColumn != null) {
            block10: for (int i = 1; i < rsmd.getColumnCount(); ++i) {
                String column;
                String table = rsmd.getTableName(i).toUpperCase(Locale.ENGLISH);
                if (!((List)this._tableNameToClassMapping.get(table)).contains(cm) || !(column = rsmd.getColumnName(i).toUpperCase(Locale.ENGLISH)).equals(discriminatorColumn.getIdentifier().getName().toUpperCase(Locale.ENGLISH))) continue;
                switch (discriminatorColumn.getJavaType()) {
                    case 5: 
                    case 21: {
                        meth.addCodeLine("Integer " + discVar + " = Integer.valueOf(" + varRs + ".getInt(" + i + "));");
                        continue block10;
                    }
                    case 2: 
                    case 18: {
                        meth.addCodeLine("java.lang.Character " + discVar + " = java.lang.Character.valueOf(" + "_dict" + ".getChar(" + varRs + ", " + i + "));");
                        continue block10;
                    }
                    case 9: {
                        meth.addCodeLine("java.lang.String " + discVar + " = " + varRs + ".getString(" + i + ");");
                        continue block10;
                    }
                    default: {
                        throw new InternalException(cm + " " + discriminatorColumn.getJavaType());
                    }
                }
            }
        }
        meth.addCodeLine("OpenJPAStateManager " + varSm + " = null;");
        ObjectCache oc = this.getObjectCache();
        if (oc != null && oc.isCacheable((ClassMetaData)cm)) {
            meth.addCodeLine("PersistenceCapable " + varPc + " = (PersistenceCapable) " + "broker" + ".findCached(" + oid + ", null, true);");
        } else {
            meth.addCodeLine("PersistenceCapable " + varPc + " = (PersistenceCapable) " + "broker" + ".findCached(" + oid + ", null, false);");
        }
        meth.addCodeLine("boolean " + varPc + "Load = true;");
        meth.addCodeLine("if(" + oid + " == null) {");
        meth.addCodeLine(varPc + "Load = false;", true);
        meth.addCodeLine("} else if(" + varPc + " == null){", false);
        if (discriminatorColumn != null) {
            ArrayList<ClassMapping> types = new ArrayList<ClassMapping>();
            types.add(cm);
            types.addAll(Arrays.asList(cm.getPCSubclassMappings()));
            boolean elseNeeded = false;
            for (int i = 0; i < types.size(); ++i) {
                String predicate;
                ClassMapping type = (ClassMapping)types.get(i);
                String typeStr = varCm;
                if (i > 0) {
                    typeStr = varCm + ".getPCSubclassMappings()[" + (i - 1) + "]";
                }
                String string = predicate = elseNeeded ? "else if " : "if ";
                if (!elseNeeded) {
                    meth.addCodeLine("", true);
                }
                elseNeeded = true;
                switch (discriminatorColumn.getJavaType()) {
                    case 5: 
                    case 21: {
                        meth.addCodeLine(predicate + "(" + discVar + ".equals(Integer.valueOf(" + type.getDiscriminator().getValue() + "))){");
                        break;
                    }
                    case 2: 
                    case 18: {
                        meth.addCodeLine(predicate + "(" + discVar + ".equals(java.lang.Character.valueOf('" + type.getDiscriminator().getValue() + "'))){");
                        break;
                    }
                    case 9: {
                        meth.addCodeLine(predicate + "(" + discVar + ".equals(\"" + type.getDiscriminator().getValue() + "\")){");
                        break;
                    }
                    default: {
                        throw new InternalException();
                    }
                }
                meth.addCodeLine(varSm + " " + "= initializeNewStateManager(" + oid + "," + "broker" + ", " + typeStr + ");", true);
                meth.addCodeLine("}", false);
            }
            meth.addCodeLine("else {");
            meth.addCodeLine("throw new org.apache.openjpa.util.InternalException(\"Invalid discriminator [\"+" + discVar + "+\"]\");", true);
            meth.addCodeLine("}", false);
        } else {
            meth.addCodeLine(varSm + " " + "= initializeNewStateManager(" + oid + "," + "broker" + ", " + varCm + ");", true);
        }
        meth.addCodeLine(varPc + " = " + varSm + ".getPersistenceCapable()");
        meth.addCodeLine("} else {", false);
        meth.addCodeLine(varPc + "Load = false;", true);
        meth.addCodeLine(varSm + " = (OpenJPAStateManager) " + varPc + ".pcGetStateManager();");
        meth.addCodeLine("}", false);
        if (debug) {
            meth.addCodeLine("// end addProcessResultSetCreateInstance [" + cm + "]");
        }
        return varPc;
    }

    private String addProcessResultSet(SourceCode.Method meth, ClassMapping cm, ResultSetMetaData rsmd, String varSm, String varPc, String varRs, String oid, String varCm, FetchPlan fetchPlan) throws SQLException {
        if (debug) {
            meth.addCodeLine("// start addProcessResultSet " + cm);
        }
        meth.addCodeLine("if(" + varPc + "Load) {");
        meth.addCodeLine("", true);
        meth.addCodeLine(varPc + ".pcReplaceStateManager(" + "tsm" + ");");
        ArrayList<Integer> fkColumn = new ArrayList<Integer>();
        String varVersion = "loadVersion_" + cm.getDescribedType().getSimpleName();
        for (int i = 1; i < rsmd.getColumnCount() + 1; ++i) {
            String table = rsmd.getTableName(i);
            String column = rsmd.getColumnName(i);
            Collection<FieldMapping> fms = this.getFieldMapping(table, column);
            for (FieldMapping fm : fms) {
                if (fm.getDeclaringMapping() != cm && !Arrays.asList(fm.getDeclaringMapping().getPCSubclassMappings()).contains(cm) || !this.addProcessResultSetColumn(meth, fm, i, varRs, varPc, varSm, varVersion, false, fetchPlan, rsmd)) continue;
                fkColumn.add(i);
            }
        }
        meth.addCodeLine(varPc + ".pcReplaceStateManager(" + varSm + ");");
        HashSet<FieldMapping> processed = new HashSet<FieldMapping>();
        Iterator i$ = fkColumn.iterator();
        while (i$.hasNext()) {
            int intermediateIndex = (Integer)i$.next();
            String table = rsmd.getTableName(intermediateIndex);
            String column = rsmd.getColumnName(intermediateIndex);
            Collection<FieldMapping> fms = this.getFieldMapping(table, column);
            for (FieldMapping fm : fms) {
                if (fm.getDefiningMapping() != cm || !processed.add(fm)) continue;
                this.addProcessResultSetColumn(meth, fm, intermediateIndex, varRs, varPc, varSm, varVersion, true, fetchPlan, rsmd);
            }
        }
        if (cm.getVersionField() == null) {
            meth.addCodeLine("super.registerEntityInContext(" + varPc + ", " + oid + ", null, " + "broker" + ");");
        } else {
            meth.addCodeLine("super.registerEntityInContext(" + varPc + ", " + oid + ", " + varVersion + ", " + "broker" + ");");
        }
        meth.addCodeLine("}", false);
        if (debug) {
            meth.addCodeLine("// end addProcessResultSet");
        }
        return varPc;
    }

    private boolean addProcessResultSetColumn(SourceCode.Method meth, FieldMapping fm, int resultIndex, String varRs, String varPc, String varSm, String varVersion, boolean fullSm, FetchPlan fetchPlan, ResultSetMetaData rsmd) throws SQLException {
        if (fm.isPrimaryKey()) {
            return false;
        }
        int fieldIndex = fm.getIndex();
        switch (fm.getAssociationType()) {
            case 2: 
            case 4: {
                throw new InternalException();
            }
            case 1: 
            case 3: {
                if (!fullSm) {
                    return true;
                }
                ClassMapping type = this._repo.getMapping(fm.getRelationType(), null, true);
                Column[] cols = fm.getColumns();
                String fkOidVar = this.addProcessResultSetKey(meth, rsmd, "Fk", varRs, type, this.getKeyType(type), fm.getColumns());
                String otherPc = "otherPc" + fm.getName();
                meth.addCodeLine("PersistenceCapable " + otherPc + " = null");
                if (this._checkCacheForLazyOids || JavaSourceGenerator.needsFetch(fetchPlan, fm)) {
                    ClassMapping fkCm = this._repo.getMapping(fm.getRelationType(), null, true);
                    ObjectCache oc = this.getObjectCache();
                    if (oc != null && oc.isCacheable((ClassMetaData)fkCm)) {
                        meth.addCodeLine(otherPc + " = (PersistenceCapable) " + "broker" + ".findCached(" + fkOidVar + ",null, true)", true);
                    } else {
                        meth.addCodeLine(otherPc + " = (PersistenceCapable) " + "broker" + ".findCached(" + fkOidVar + ",null, false)", true);
                    }
                }
                meth.addCodeLine("if(" + otherPc + " == null) {");
                meth.addCodeLine(varSm + ".setIntermediate(" + fm.getIndex() + "," + fkOidVar + ");", true);
                meth.addCodeLine("} else {", false);
                meth.addCodeLine(varSm + ".store(" + fm.getIndex() + "," + otherPc + ");", true);
                Object[] inverses = fm.getInverseMappings();
                boolean loadInverse = inverses.length != 0;
                for (FieldMapping fieldMapping : inverses) {
                    if (!JavaSourceGenerator.needsFetch(fetchPlan, fieldMapping)) {
                        loadInverse = false;
                        continue;
                    }
                    if (inverses.length <= 1) continue;
                    throw new UnsupportedException("unsupported " + Arrays.toString(inverses));
                }
                if (loadInverse) {
                    FieldMapping inverse = inverses[0];
                    switch (inverse.getAssociationType()) {
                        case 2: {
                            meth.addCodeLine("// crap, probably need to add some logic here.");
                            break;
                        }
                        case 1: 
                        case 3: {
                            meth.addCodeLine("((StateManagerImpl)" + otherPc + ".pcGetStateManager()).store(" + inverse.getIndex() + "," + varPc + ");");
                            break;
                        }
                        case 4: {
                            throw new InternalException();
                        }
                    }
                }
                meth.addCodeLine("}", false);
                return false;
            }
        }
        if (fullSm) {
            return false;
        }
        boolean isVersion = fm.isVersion();
        block9 : switch (fm.getTypeCode()) {
            case 24: {
                meth.addCodeLine("tsm.setObject(_dict.getBigDecimal(" + varRs + "," + resultIndex + "));");
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 25: {
                meth.addCodeLine("tsm.setObject(_dict.getBigInteger(" + varRs + "," + resultIndex + "));");
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 16: {
                meth.addCodeLine("tsm.setObject(" + varRs + ".getBoolean(" + resultIndex + "));");
                meth.addCodeLine("if( " + varRs + ".wasNull() ) " + "tsm" + ".setObject(null);");
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 17: {
                meth.addCodeLine("tsm.setObject(" + varRs + ".getByte(" + resultIndex + "));");
                meth.addCodeLine("if( " + varRs + ".wasNull() ) " + "tsm" + ".setObject(null);");
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 18: {
                meth.addCodeLine("tsm.setObject(java.lang.Character.valueOf(_dict.getChar(" + varRs + "," + resultIndex + ")));");
                meth.addCodeLine("if( " + varRs + ".wasNull() ) " + "tsm" + ".setObject(null);");
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 19: {
                meth.addCodeLine("tsm.setObject(" + varRs + ".getDouble(" + resultIndex + "));");
                meth.addCodeLine("if( " + varRs + ".wasNull() ) " + "tsm" + ".setObject(null);");
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 20: {
                meth.addCodeLine("tsm.setObject(" + varRs + ".getFloat(" + resultIndex + "));");
                meth.addCodeLine("if( " + varRs + ".wasNull() ) " + "tsm" + ".setObject(null);");
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 21: {
                if (isVersion) {
                    meth.addCodeLine("final java.lang.Integer " + varVersion + " = " + varRs + ".getInt(" + resultIndex + ");");
                    meth.addCodeLine("tsm.setObject(" + varVersion + ");");
                    meth.addCodeLine("if( " + varRs + ".wasNull() ) " + "tsm" + ".setObject(null);");
                    meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                    break;
                }
                meth.addCodeLine("tsm.setObject(" + varRs + ".getInt(" + resultIndex + "));");
                meth.addCodeLine("if( " + varRs + ".wasNull() ) " + "tsm" + ".setObject(null);");
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 22: {
                if (isVersion) {
                    meth.addCodeLine("final java.lang.Long " + varVersion + " = " + varRs + ".getLong(" + resultIndex + ");");
                    meth.addCodeLine("tsm.setObject(" + varVersion + ");");
                    meth.addCodeLine("if( " + varRs + ".wasNull() ) " + "tsm" + ".setObject(null);");
                    meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                    break;
                }
                meth.addCodeLine("tsm.setObject(" + varRs + ".getLong(" + resultIndex + "));");
                meth.addCodeLine("if( " + varRs + ".wasNull() ) " + "tsm" + ".setObject(null);");
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 23: {
                if (isVersion) {
                    meth.addCodeLine("final java.lang.Short " + varVersion + " = " + varRs + ".getShort(" + resultIndex + ");");
                    meth.addCodeLine("tsm.setObject(" + varVersion + ");");
                    meth.addCodeLine("if( " + varRs + ".wasNull() ) " + "tsm" + ".setObject(null);");
                    meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                    break;
                }
                meth.addCodeLine("tsm.setObject(" + varRs + ".getShort(" + resultIndex + "));");
                meth.addCodeLine("if( " + varRs + ".wasNull() ) " + "tsm" + ".setObject(null);");
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 5: {
                if (isVersion) {
                    meth.addCodeLine("final int " + varVersion + " = " + varRs + ".getInt(" + resultIndex + ");");
                    meth.addCodeLine("tsm.setInt(" + varVersion + ");");
                } else {
                    meth.addCodeLine("tsm.setInt(" + varRs + ".getInt(" + resultIndex + "));");
                }
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 6: {
                if (isVersion) {
                    meth.addCodeLine("final long " + varVersion + " = " + varRs + ".getLong(" + resultIndex + ");");
                    meth.addCodeLine("tsm.setLong(" + varVersion + ");");
                } else {
                    meth.addCodeLine("tsm.setLong(" + varRs + ".getLong(" + resultIndex + "));");
                }
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 9: {
                meth.addCodeLine("tsm.setString(_dict.getString(" + varRs + "," + resultIndex + "));");
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 28: {
                meth.addCodeLine("tsm.setObject(_dict.getCalendar(" + varRs + "," + resultIndex + "));");
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 32: {
                boolean useOrdinal = this.getUseOrdinal(fm);
                if (useOrdinal) {
                    meth.addCodeLine("int ordEnumVal = " + varRs + ".getInt(" + resultIndex + ")");
                    meth.addCodeLine("if( " + varRs + ".wasNull() ) {");
                    meth.addCodeLine("tsm.setObject(null);");
                    meth.addCodeLine("} else {");
                    meth.addCodeLine("tsm.setObject(" + fm.getDeclaredType().getName().replaceAll("[$]", "\\.") + ".values()[ordEnumVal]);");
                    meth.addCodeLine("}");
                } else {
                    meth.addCodeLine("String strEnumValue = " + varRs + ".getString(" + resultIndex + ")");
                    meth.addCodeLine("if( " + varRs + ".wasNull() ) {");
                    meth.addCodeLine("tsm.setObject(null);");
                    meth.addCodeLine("} else {");
                    meth.addCodeLine("tsm.setObject(" + fm.getDeclaredType().getName().replaceAll("[$]", "\\.") + ".valueOf(strEnumValue));");
                    meth.addCodeLine("}");
                }
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 2: {
                meth.addCodeLine("tsm.setChar((char)" + varRs + ".getInt(" + resultIndex + "));");
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 7: {
                if (isVersion) {
                    meth.addCodeLine("final short " + varVersion + " = " + varRs + ".getShort(" + resultIndex + ");");
                    meth.addCodeLine("tsm.setShort(" + varVersion + ");");
                } else {
                    meth.addCodeLine("tsm.setShort(" + varRs + ".getShort(" + resultIndex + "));");
                }
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 3: {
                meth.addCodeLine("tsm.setDouble(" + varRs + ".getDouble(" + resultIndex + "));");
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 4: {
                meth.addCodeLine("tsm.setFloat(" + varRs + ".getFloat(" + resultIndex + "));");
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 0: {
                meth.addCodeLine("tsm.setBoolean(" + varRs + ".getBoolean(" + resultIndex + "));");
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 1: {
                meth.addCodeLine("tsm.setByte(" + varRs + ".getByte(" + resultIndex + "));");
                meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                break;
            }
            case 14: {
                switch (JavaSQLTypes.getDateTypeCode((Class)fm.getDeclaredType())) {
                    case 1010: {
                        meth.addCodeLine("tsm.setObject(_dict.getTime(" + varRs + "," + resultIndex + ", java.util.Calendar.getInstance()));");
                        meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                        break block9;
                    }
                    case 1011: {
                        if (isVersion) {
                            meth.addCodeLine("final java.sql.Timestamp " + varVersion + " = " + "_dict" + ".getTimestamp(" + varRs + "," + resultIndex + ", java.util.Calendar.getInstance());");
                            meth.addCodeLine("tsm.setObject(" + varVersion + ");");
                            meth.addCodeLine("if( " + varRs + ".wasNull() ) " + "tsm" + ".setObject(null);");
                            meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                            break block9;
                        }
                        meth.addCodeLine("tsm.setObject(_dict.getTimestamp(" + varRs + "," + resultIndex + ", java.util.Calendar.getInstance()));");
                        meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                        break block9;
                    }
                    case 1007: {
                        meth.addCodeLine("tsm.setObject(_dict.getDate(" + varRs + "," + resultIndex + ", null));");
                        meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                        break block9;
                    }
                    case 14: {
                        meth.addCodeLine("tsm.setObject(_dict.getDate(" + varRs + "," + resultIndex + "));");
                        meth.addCodeLine(varPc + ".pcReplaceField(" + fieldIndex + ");");
                        break block9;
                    }
                }
                throw new InternalException(fm + " " + fm.getTypeCode());
            }
            default: {
                throw new InternalException(fm + " " + fm.getTypeCode());
            }
        }
        meth.addCodeLine("");
        return false;
    }

    private SourceCode.Method addSetParametersForLoad(SourceCode.Method meth, FieldMapping loadingField, ClassMapping loadingType, ParameterMetaData pmd) throws SQLException {
        if (debug) {
            meth.addCodeLine("// start addSetParametersForLoad");
        }
        String sm = "pcSm";
        meth.addCodeLine("OpenJPAStateManager " + sm + " = (OpenJPAStateManager)" + "owner" + ".pcGetStateManager()");
        String oidParam = "oid$spfl$" + loadingField.getDeclaringType().getSimpleName();
        meth.addCodeLine("OpenJPAId " + oidParam + " = (OpenJPAId) " + sm + ".getObjectId();");
        FieldMapping mappedBy = loadingField.getMappedByMapping();
        if (mappedBy == null) {
            throw new UnsupportedException("Unable to generate a FP for a field that doesn't own, or is mapped by another field.");
        }
        ClassMapping mappedByType = mappedBy.getDeclaredTypeMapping();
        String pc = "_relatedPCs[" + mappedBy.getIndex() + "]";
        return this.addSetParameters(meth, mappedByType, mappedBy.getForeignKey(), oidParam, pc, false, pmd);
    }

    private SourceCode.Method addSetParametersQuery(SourceCode.Method meth, QueryImpl<?> pQuery, ParameterMetaData pmd) throws SQLException {
        if (debug) {
            meth.addCodeLine("// addSetParametersQuery [ " + pQuery + ", " + pmd + " ]");
        }
        OrderedMap orderedParamTypeMap = pQuery.getDelegate().getOrderedParameterTypes();
        if (pmd.getParameterCount() != orderedParamTypeMap.size()) {
            throw new UnsupportedException("Found " + pmd.getParameterCount() + " parameter(s), but we were passed " + orderedParamTypeMap.size() + ". Query = [ " + pQuery.getQueryString() + " ]");
        }
        int index = 1;
        for (Map.Entry entry : orderedParamTypeMap.entrySet()) {
            this.addSetSingleQueryParameter(meth, index, "params[" + (index - 1) + "]", (Class)entry.getValue(), pmd);
            ++index;
        }
        if (debug) {
            meth.addCodeLine("// endSetParametersQuery ");
        }
        return meth;
    }

    private SourceCode.Method addSetParameters(SourceCode.Method meth, ClassMapping cm, ForeignKey fk, String varIdStr, String oidTypePc, boolean discriminate, ParameterMetaData pmd) throws SQLException {
        int i;
        if (debug) {
            meth.addCodeLine("// addSetParametersForLoad " + cm);
        }
        FieldMapping[] pkFms = cm.getPrimaryKeyFieldMappings();
        String pkvals = "pkvals";
        int discCount = this.addCopyValuesToOidArray(meth, cm, varIdStr, oidTypePc, pkvals, discriminate);
        if (!discriminate) {
            discCount = 0;
        }
        for (i = 0; i < discCount; ++i) {
            this.addSetSingleDiscriminatorParameter(meth, i + 1, pkvals + "[" + i + "]", JavaSourceGenerator.getRootPC(cm).getDiscriminator());
        }
        if (fk != null) {
            Column[] pkCols = fk.getPrimaryKeyColumns();
            Joinable joinable = null;
            if (pmd.getParameterCount() != pkCols.length) {
                throw new UnsupportedException("Unable to load a relationship to a type with a discriminator column.");
            }
            int paramIndex = discCount <= 0 ? 1 : discCount;
            for (Column pkCol : pkCols) {
                joinable = cm.assertJoinable(pkCol);
                int joinableFieldIndex = joinable.getFieldIndex();
                int pksIndex = cm.getField(joinableFieldIndex).getPrimaryKeyIndex();
                this.addSetSingleParameterWorker(meth, paramIndex, pkvals + "[" + pksIndex + "]", pkCol, pkCol.getJavaType(), null, null);
                ++paramIndex;
            }
        } else {
            for (i = 0; i < pkFms.length; ++i) {
                FieldMapping fm = pkFms[i];
                for (int j = discCount + i; j < discCount + fm.getColumns().length + i; ++j) {
                    this.addSetSingleParameter(meth, j + 1, pkvals + "[" + j + "]", fm);
                }
            }
        }
        meth.addCodeLine("pkfm.reset()");
        return meth;
    }

    private int addCopyValuesToOidArray(SourceCode.Method meth, ClassMapping cm, String varIdStr, String oidTypePc, String pkValsStr, boolean discriminate) {
        if (debug) {
            meth.addCodeLine("// addCopyValuesToOidArray ");
        }
        int discriminatorCount = 0;
        ClassMapping root = JavaSourceGenerator.getRootPC(cm);
        Discriminator discriminator = root.getDiscriminator();
        if (discriminator.getStrategy() != null && root != cm && discriminate && cm.getDiscriminator().getValue() != null) {
            ++discriminatorCount;
            for (ClassMapping sub : cm.getPCSubclassMappings()) {
                ++discriminatorCount;
            }
        }
        FieldMapping[] pkFms = cm.getPrimaryKeyFieldMappings();
        int pkCols = 0;
        boolean embeddedId = false;
        if (pkFms.length == 1) {
            pkCols = pkFms[0].getColumns().length;
            ClassMapping embed = pkFms[0].getEmbeddedMapping();
            if (embed != null) {
                embeddedId = embed.isEmbeddable();
            }
        } else {
            for (FieldMapping fm : pkFms) {
                int col = fm.getColumns().length;
                pkCols += col;
                if (col > 1) {
                    throw new UnsupportedException("not sure what this case is. We have multiple fields and multiple columns for one of those fields? " + fm);
                }
                ClassMapping embed = fm.getEmbeddedMapping();
                if (embed == null) continue;
                throw new UnsupportedException("we have multiple pk fields, atleast one of them is an embeddedid. " + fm);
            }
        }
        meth.addCodeLine("Object[] " + pkValsStr + " = new Object[" + (pkCols + discriminatorCount) + "];");
        if (discriminatorCount > 0) {
            ArrayList<ClassMapping> cms = new ArrayList<ClassMapping>();
            cms.add(0, cm);
            cms.addAll(Arrays.asList(cm.getPCSubclassMappings()));
            int count = 0;
            for (ClassMapping type : cms) {
                Object dv = type.getDiscriminator().getValue();
                switch (discriminator.getColumns()[0].getJavaType()) {
                    case 2: 
                    case 18: {
                        meth.addCodeLine(pkValsStr + "[" + count + "] = java.lang.Character.valueOf('" + dv + "');");
                        break;
                    }
                    case 5: 
                    case 21: {
                        meth.addCodeLine(pkValsStr + "[" + count + "] = Integer.valueOf(" + dv + ");");
                        break;
                    }
                    case 9: {
                        meth.addCodeLine(pkValsStr + "[" + count + "] = \"" + dv + "\";");
                    }
                }
                ++count;
            }
        }
        meth.addCodeLine("pkfm.setStore(" + pkValsStr + "," + discriminatorCount + ");");
        if (embeddedId) {
            String pcid = "pcid";
            meth.addCodeLine("PersistenceCapable " + pcid + " = (PersistenceCapable) " + varIdStr + ".getIdObject();");
            meth.addCodeLine(pcid + ".pcReplaceStateManager(" + "tsm" + ");");
            int index = 0;
            block19: for (Column col : pkFms[0].getColumns()) {
                meth.addCodeLine(pcid + ".pcProvideField(" + index + ");");
                switch (col.getJavaType()) {
                    case 7: {
                        meth.addCodeLine(pkValsStr + "[" + index++ + "] = " + "tsm" + ".getShort();");
                        continue block19;
                    }
                    case 0: {
                        meth.addCodeLine(pkValsStr + "[" + index++ + "] = " + "tsm" + ".getBoolean();");
                        continue block19;
                    }
                    case 2: {
                        meth.addCodeLine(pkValsStr + "[" + index++ + "] = " + "tsm" + ".getChar();");
                        continue block19;
                    }
                    case 3: {
                        meth.addCodeLine(pkValsStr + "[" + index++ + "] = " + "tsm" + ".getDouble();");
                        continue block19;
                    }
                    case 4: {
                        meth.addCodeLine(pkValsStr + "[" + index++ + "] = " + "tsm" + ".getFloat();");
                        continue block19;
                    }
                    case 5: {
                        meth.addCodeLine(pkValsStr + "[" + index++ + "] = " + "tsm" + ".getInt();");
                        continue block19;
                    }
                    case 6: {
                        meth.addCodeLine(pkValsStr + "[" + index++ + "] = " + "tsm" + ".getLong();");
                        continue block19;
                    }
                    case 14: 
                    case 16: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 1007: {
                        meth.addCodeLine(pkValsStr + "[" + index++ + "] = " + "tsm" + ".getObject();");
                        continue block19;
                    }
                    case 9: {
                        meth.addCodeLine(pkValsStr + "[" + index++ + "] = " + "tsm" + ".getString();");
                        continue block19;
                    }
                    default: {
                        throw new UnsupportedException("unsupported atm " + col + " " + col.getJavaType());
                    }
                }
            }
            meth.addCodeLine(pcid + ".pcReplaceStateManager(null);");
        } else {
            meth.addCodeLine(oidTypePc + ".pcCopyKeyFieldsFromObjectId(" + "pkfm" + "," + varIdStr + ");");
        }
        return discriminatorCount;
    }

    private void addSetSingleParameter(SourceCode.Method meth, int paramIndex, String paramValue, FieldMapping fm) throws SQLException {
        Column[] cols = fm == null ? null : fm.getColumns();
        Column col = null;
        col = cols.length > 1 ? cols[paramIndex - 1] : cols[0];
        int switchParam = col.getJavaType();
        this.addSetSingleParameterWorker(meth, paramIndex, paramValue, col, switchParam, null, null);
    }

    private void addSetSingleDiscriminatorParameter(SourceCode.Method meth, int paramIndex, String paramValue, Discriminator disc) throws SQLException {
        Column[] cols = disc.getColumns();
        if (cols.length != 1) {
            throw new InternalException("Unable to support a Discriminator with non-one column(s). " + disc + " " + disc.getClassMapping());
        }
        Column col = cols[0];
        int switchParam = col.getJavaType();
        this.addSetSingleParameterWorker(meth, paramIndex, paramValue, col, switchParam, null, null);
    }

    private void addSetSingleQueryParameter(SourceCode.Method meth, int paramIndex, String paramValue, Class<?> paramType, ParameterMetaData pmd) throws SQLException {
        int switchParam = JavaTypes.getTypeCode(paramType);
        this.addSetSingleParameterWorker(meth, paramIndex, paramValue, null, switchParam, paramType, pmd);
    }

    private void addSetSingleParameterWorker(SourceCode.Method meth, int paramIndex, String paramValue, Column col, int switchParam, Class<?> paramType, ParameterMetaData pmd) throws SQLException {
        switch (switchParam) {
            case 32: {
                boolean useOrdinal = this.getUseOrdinal(paramIndex, pmd);
                if (useOrdinal) {
                    meth.addCodeLine("stmt.setInt(" + paramIndex + ",  ((" + paramType.getName() + ")" + paramValue + ").ordinal());");
                    break;
                }
                meth.addCodeLine("stmt.setString(" + paramIndex + ",  ((" + paramType.getName() + ")" + paramValue + ").name());");
                break;
            }
            case 0: 
            case 16: {
                meth.addCodeLine("stmt.setInt(" + paramIndex + ",((java.lang.Boolean)" + paramValue + ").equals(java.lang.Boolean.TRUE) ? 1 : 0 );");
                break;
            }
            case 7: 
            case 23: {
                meth.addCodeLine("stmt.setShort(" + paramIndex + ",(java.lang.Short)" + paramValue + ");");
                break;
            }
            case 4: 
            case 20: {
                meth.addCodeLine("stmt.setFloat(" + paramIndex + ",(java.lang.Float)" + paramValue + ");");
                break;
            }
            case 3: 
            case 19: {
                meth.addCodeLine("stmt.setDouble(" + paramIndex + ",(java.lang.Double)" + paramValue + ");");
                break;
            }
            case 24: {
                if (col != null && col.isCompatible(12, null, 0, 0) || col == null && this._conf.getDBDictionaryInstance().storeLargeNumbersAsStrings) {
                    meth.addCodeLine("stmt.setString(" + paramIndex + ",((java.math.BigDecimal)" + paramValue + ").toString());");
                    break;
                }
                meth.addCodeLine("stmt.setBigDecimal(" + paramIndex + ",(java.math.BigDecimal)" + paramValue + ");");
                break;
            }
            case 25: {
                if (col != null && col.isCompatible(12, null, 0, 0) || col == null && this._conf.getDBDictionaryInstance().storeLargeNumbersAsStrings) {
                    meth.addCodeLine("stmt.setString(" + paramIndex + ",((java.math.BigInteger)" + paramValue + ").toString());");
                    break;
                }
                meth.addCodeLine("stmt.setBigDecimal(" + paramIndex + ",new java.math.BigDecimal((java.math.BigInteger)" + paramValue + "));");
                break;
            }
            case 6: 
            case 22: {
                meth.addCodeLine("stmt.setLong(" + paramIndex + ",(Long)" + paramValue + ");");
                break;
            }
            case 5: 
            case 21: {
                meth.addCodeLine("stmt.setInt(" + paramIndex + ",(Integer)" + paramValue + ");");
                break;
            }
            case 2: 
            case 18: {
                meth.addCodeLine("stmt.setInt(" + paramIndex + ", (java.lang.Character)" + paramValue + ");");
                break;
            }
            case 9: {
                meth.addCodeLine("stmt.setString(" + paramIndex + ",(String)" + paramValue + ");");
                break;
            }
            case 1: 
            case 17: {
                meth.addCodeLine("stmt.setByte(" + paramIndex + ",((java.lang.Byte)" + paramValue + ").byteValue());");
                break;
            }
            case 14: 
            case 1007: {
                meth.addCodeLine("stmt.setObject(" + paramIndex + ", new java.sql.Date(((java.util.Date)" + paramValue + ").getTime()));");
                break;
            }
            case 8: {
                meth.addCodeLine("stmt.setObject(" + paramIndex + ",(Object)" + paramValue + ");");
                break;
            }
            default: {
                throw new InternalException(Arrays.toString(new Object[]{col, switchParam}));
            }
        }
    }

    private SourceCode.Method addLoadDataMethod(SourceCode.Class cls) {
        SourceCode.Method meth = cls.addMethod("loadData", "boolean");
        meth.addArgument(PersistenceCapable.class.getName(), "owner");
        meth.addArgument(WsJpaBrokerImpl.class.getName(), "broker");
        meth.addArgument(TransferStateManager.class.getName(), "tsm");
        meth.addArgument(PreparedStatement.class.getName(), "stmt");
        meth.addArgument(PrimaryKeyFieldManager.class.getName(), "pkfm");
        return meth;
    }

    private SourceCode.Method addGetResultListMethod(SourceCode.Class cls) {
        SourceCode.Method meth = cls.addMethod("getResultList", "java.util.List");
        meth.addArgument(WsJpaBrokerImpl.class.getName(), "broker");
        meth.addArgument(PreparedStatement.class.getName(), "stmt");
        meth.addArgument(TransferStateManager.class.getName(), "tsm");
        meth.addArgument(PrimaryKeyFieldManager.class.getName(), "pkfm");
        meth.addArgument(Object.class.getName() + "[]", "params");
        return meth;
    }

    private SourceCode.Method addLoadMethod(SourceCode.Class cls) {
        SourceCode.Method meth = cls.addMethod("loadData", "Object");
        meth.addArgument(DBDictionary.class.getName(), "_dict");
        meth.addArgument(OpenJPAId.class.getName(), "oid");
        meth.addArgument(WsJpaBrokerImpl.class.getName(), "broker");
        meth.addArgument(TransferStateManager.class.getName(), "tsm");
        meth.addArgument(PreparedStatement.class.getName(), "stmt");
        meth.addArgument(PrimaryKeyFieldManager.class.getName(), "pkfm");
        return meth;
    }

    private static ClassMapping getRootPC(ClassMapping cm) {
        ClassMapping root = cm;
        while (root.getPCSuperclassMapping() != null) {
            root = root.getPCSuperclassMapping();
        }
        return root;
    }

    private static boolean hasEagerToMany(ClassMapping root, FetchPlan fp) {
        ClassMapping[] eagers = JavaSourceGenerator.getEagers(root, fp);
        for (FieldMapping fieldMapping : root.getFieldMappings()) {
            if (!JavaSourceGenerator.needsFetch(fp, fieldMapping) || fieldMapping.getAssociationType() != 2) continue;
            return true;
        }
        for (FieldMapping fieldMapping : eagers) {
            for (FieldMapping fm : fieldMapping.getFieldMappings()) {
                if (!JavaSourceGenerator.needsFetch(fp, fm) || fm.getAssociationType() != 2) continue;
                return true;
            }
        }
        return false;
    }

    private static ClassMapping[] getEagers(ClassMapping root, FetchPlan fp) {
        Set<ClassMapping> eagers = JavaSourceGenerator.getEagersWorker(root, null, fp);
        eagers.remove(root);
        return eagers.toArray(new ClassMapping[0]);
    }

    private static Set<ClassMapping> getEagersWorker(ClassMapping cm, Set<ClassMapping> known, FetchPlan fp) {
        if (known == null) {
            known = new HashSet<ClassMapping>();
        }
        block4: for (FieldMapping fm : cm.getFieldMappings()) {
            if (!JavaSourceGenerator.needsFetch(fp, fm)) continue;
            switch (fm.getAssociationType()) {
                case 2: {
                    ClassMapping rel = (ClassMapping)fm.getElement().getDeclaredTypeMetaData();
                    if (!known.add(rel)) continue block4;
                    known.addAll(JavaSourceGenerator.getEagersWorker(rel, known, fp));
                    continue block4;
                }
                case 1: 
                case 3: {
                    ClassMapping rel = fm.getDeclaredTypeMapping();
                    if (!known.add(rel)) continue block4;
                    known.addAll(JavaSourceGenerator.getEagersWorker(rel, known, fp));
                    continue block4;
                }
            }
        }
        return known;
    }

    private static Integer getColumnIndex(Column col, ResultSetMetaData rsmd) throws SQLException {
        String table = col.getTable().getIdentifier().getName().toUpperCase(Locale.ENGLISH);
        String colName = col.getIdentifier().getName().toUpperCase(Locale.ENGLISH);
        for (int i = 1; i < rsmd.getColumnCount() + 1; ++i) {
            String rsmdTable = rsmd.getTableName(i).toUpperCase(Locale.ENGLISH);
            String rsmdColunmn = rsmd.getColumnName(i).toUpperCase(Locale.ENGLISH);
            if (!table.equals(rsmdTable) || !colName.equals(rsmdColunmn)) continue;
            return i;
        }
        throw new UnsupportedException("Unknown column identifier : [ " + table + "." + colName + " ] \n" + rsmd);
    }

    private static int calculateRelatedMetasIndex(ClassMapping owner, ClassMapping cm) {
        block4: for (FieldMapping fm : owner.getFieldMappings()) {
            switch (fm.getAssociationType()) {
                case 2: {
                    if (fm.getElement().getDeclaredTypeMetaData() != cm) continue block4;
                    return fm.getIndex();
                }
                case 1: 
                case 3: {
                    if (fm.getDeclaredTypeMapping() != cm) continue block4;
                    return fm.getIndex();
                }
            }
        }
        throw new UnsupportedException("unknown : " + owner + " " + cm);
    }

    public static boolean needsFetch(FetchPlan fp, FieldMapping fm) {
        return fp.hasField(fm.getDeclaringType(), fm.getName()) || fm.isInDefaultFetchGroup();
    }

    private static void checkSQL(String sql) {
        Matcher matcher = tablesPattern.matcher(sql);
        HashSet<String> tables = new HashSet<String>();
        while (matcher.find()) {
            String table = matcher.group().split(" ")[1];
            if (tables.add(table)) continue;
            throw new UnsupportedException("Found an SQL that is selecting data from the same table multiple times. Table = [" + table + "], SQL = [" + sql + "]");
        }
        if (sql.toUpperCase(Locale.ENGLISH).contains("IS NULL")) {
            throw new UnsupportedException("SQL contains a NULL parameter -> SQL [" + sql + "]");
        }
    }

    private KeyType getKeyType(ClassMapping cm) {
        KeyType res = KeyType.BASIC;
        FieldMapping[] pkFms = cm.getPrimaryKeyFieldMappings();
        if (pkFms.length == 1) {
            ClassMapping embed = pkFms[0].getEmbeddedMapping();
            if (embed != null && embed.isEmbeddable()) {
                res = KeyType.EMBEDDED;
            }
        } else {
            res = KeyType.ID_CLASS;
        }
        return res;
    }

    private boolean isStringType(int sqlType) {
        switch (sqlType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private boolean getUseOrdinal(FieldMapping fm) {
        if (fm.getValueMapping() != null && fm.getValueMapping().getHandler() != null && fm.getValueMapping().getHandler() instanceof EnumValueHandler) {
            return ((EnumValueHandler)fm.getValueMapping().getHandler()).getStoreOrdinal();
        }
        return true;
    }

    private boolean getUseOrdinal(int paramIndex, ParameterMetaData pmd) throws SQLException {
        if (pmd != null && paramIndex <= pmd.getParameterCount()) {
            int sqlType = pmd.getParameterType(paramIndex);
            return !this.isStringType(sqlType);
        }
        return true;
    }

    static enum KeyType {
        EMBEDDED,
        ID_CLASS,
        BASIC;

    }
}

